/*
    dllloader
    copyright (c) 2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#ifndef __WINUSER_H__
#define __WINUSER_H__


#include "windef.h"


/* Standard dialog button IDs */
#define IDOK				1
#define IDCANCEL			2
#define IDABORT				3
#define IDRETRY				4
#define IDIGNORE			5
#define IDYES				6
#define IDNO				7
#define IDCLOSE				8
#define IDHELP				9


/******************************************************************************
*                                                                             *
* ɥ                                                                  *
*                                                                             *
******************************************************************************/
typedef struct WindowExtraData_Tag {
	DWORD dwStyle;
	DWORD dwExStyle;
	WNDPROC lpfnWndProc;
	HINSTANCE hInstance;
	HWND hWndParent;
	WORD wID;
	DWORD dwUserData;
	DLGPROC lpDialogFunc;
	LRESULT lResult;
	DWORD dwUser;
	GtkWidget **child,**sister;
} WindowExtraData;


/******************************************************************************
*                                                                             *
* å                                                                  *
*                                                                             *
******************************************************************************/
/* Win32 button control messages */
#define BM_GETCHECK					0x00f0
#define BM_SETCHECK					0x00f1
#define BM_GETSTATE					0x00f2
#define BM_SETSTATE					0x00f3
#define BM_SETSTYLE					0x00f4
#define BM_CLICK					0x00f5
#define BM_GETIMAGE					0x00f6
#define BM_SETIMAGE					0x00f7

/* Combo box messages */
#define CB_GETEDITSEL				0x0140
#define CB_LIMITTEXT				0x0141
#define CB_SETEDITSEL				0x0142
#define CB_ADDSTRING				0x0143
#define CB_DELETESTRING				0x0144
#define CB_DIR						0x0145
#define CB_GETCOUNT					0x0146
#define CB_GETCURSEL				0x0147
#define CB_GETLBTEXT				0x0148
#define CB_GETLBTEXTLEN				0x0149
#define CB_INSERTSTRING				0x014a
#define CB_RESETCONTENT				0x014b
#define CB_FINDSTRING				0x014c
#define CB_SELECTSTRING				0x014d
#define CB_SETCURSEL				0x014e
#define CB_SHOWDROPDOWN				0x014f
#define CB_GETITEMDATA				0x0150
#define CB_SETITEMDATA				0x0151
#define CB_GETDROPPEDCONTROLRECT	0x0152
#define CB_SETITEMHEIGHT			0x0153
#define CB_GETITEMHEIGHT			0x0154
#define CB_SETEXTENDEDUI			0x0155
#define CB_GETEXTENDEDUI			0x0156
#define CB_GETDROPPEDSTATE			0x0157
#define CB_FINDSTRINGEXACT			0x0158
#define CB_SETLOCALE				0x0159
#define CB_GETLOCALE				0x015a
#define CB_GETTOPINDEX				0x015b
#define CB_SETTOPINDEX				0x015c
#define CB_GETHORIZONTALEXTENT		0x015d
#define CB_SETHORIZONTALEXTENT		0x015e
#define CB_GETDROPPEDWIDTH			0x015f
#define CB_SETDROPPEDWIDTH			0x0160
#define CB_INITSTORAGE				0x0161

/* Combo box message return values */
#define CB_OKAY						0
#define CB_ERR						(-1)
#define CB_ERRSPACE					(-2)


/******************************************************************************
*                                                                             *
*                                                                   *
*                                                                             *
******************************************************************************/
/* Button control styles */
#define BS_PUSHBUTTON			0x00000000L
#define BS_DEFPUSHBUTTON		0x00000001L
#define BS_CHECKBOX				0x00000002L
#define BS_AUTOCHECKBOX			0x00000003L
#define BS_RADIOBUTTON			0x00000004L
#define BS_3STATE				0x00000005L
#define BS_AUTO3STATE			0x00000006L
#define BS_GROUPBOX				0x00000007L
#define BS_USERBUTTON			0x00000008L
#define BS_AUTORADIOBUTTON		0x00000009L
#define BS_OWNERDRAW			0x0000000BL
#define BS_LEFTTEXT				0x00000020L
#define BS_RIGHTBUTTON			BS_LEFTTEXT
#define BS_TEXT					0x00000000L
#define BS_ICON					0x00000040L
#define BS_BITMAP				0x00000080L
#define BS_LEFT					0x00000100L
#define BS_RIGHT				0x00000200L
#define BS_CENTER				0x00000300L
#define BS_TOP					0x00000400L
#define BS_BOTTOM				0x00000800L
#define BS_VCENTER				0x00000C00L
#define BS_PUSHLIKE				0x00001000L
#define BS_MULTILINE			0x00002000L
#define BS_NOTIFY				0x00004000L
#define BS_FLAT					0x00008000L

/* Button notification codes */
#define BN_CLICKED				0
#define BN_PAINT				1
#define BN_HILITE				2
#define BN_UNHILITE				3
#define BN_DISABLE				4
#define BN_DOUBLECLICKED		5
#define BN_DBLCLK				BN_DOUBLECLICKED

/* Button states */
#define BST_UNCHECKED			0x0000
#define BST_CHECKED				0x0001
#define BST_INDETERMINATE		0x0002
#define BST_PUSHED				0x0004
#define BST_FOCUS				0x0008

/* Combo box styles */
#define CBS_SIMPLE				0x0001L
#define CBS_DROPDOWN			0x0002L
#define CBS_DROPDOWNLIST		0x0003L
#define CBS_OWNERDRAWFIXED		0x0010L
#define CBS_OWNERDRAWVARIABLE	0x0020L
#define CBS_AUTOHSCROLL			0x0040L
#define CBS_OEMCONVERT			0x0080L
#define CBS_SORT				0x0100L
#define CBS_HASSTRINGS			0x0200L
#define CBS_NOINTEGRALHEIGHT	0x0400L
#define CBS_DISABLENOSCROLL		0x0800L

/* Static Control Styles */
#define SS_LEFT					0x00000000L
#define SS_CENTER				0x00000001L
#define SS_RIGHT				0x00000002L
#define SS_ICON					0x00000003L
#define SS_BLACKRECT			0x00000004L
#define SS_GRAYRECT				0x00000005L
#define SS_WHITERECT			0x00000006L
#define SS_BLACKFRAME			0x00000007L
#define SS_GRAYFRAME			0x00000008L
#define SS_WHITEFRAME			0x00000009L
#define SS_SIMPLE				0x0000000BL
#define SS_LEFTNOWORDWRAP		0x0000000CL
#define SS_OWNERDRAW			0x0000000DL
#define SS_BITMAP				0x0000000EL
#define SS_ENHMETAFILE			0x0000000FL
#define SS_ETCHEDHORZ			0x00000010L
#define SS_ETCHEDVERT			0x00000011L
#define SS_ETCHEDFRAME			0x00000012L
#define SS_NOPREFIX				0x00000080L
#define SS_NOTIFY				0x00000100L
#define SS_CENTERIMAGE			0x00000200L
#define SS_RIGHTJUST			0x00000400L
#define SS_REALSIZEIMAGE		0x00000800L
#define SS_SUNKEN				0x00001000L

/* Window Styles */
#define WS_OVERLAPPED			0x00000000L
#define WS_POPUP				0x80000000L
#define WS_CHILD				0x40000000L
#define WS_MINIMIZE				0x20000000L
#define WS_VISIBLE				0x10000000L
#define WS_DISABLED				0x08000000L
#define WS_CLIPSIBLINGS			0x04000000L
#define WS_CLIPCHILDREN			0x02000000L
#define WS_MAXIMIZE				0x01000000L
#define WS_CAPTION				0x00C00000L
#define WS_BORDER				0x00800000L
#define WS_DLGFRAME				0x00400000L
#define WS_VSCROLL				0x00200000L
#define WS_HSCROLL				0x00100000L
#define WS_SYSMENU				0x00080000L
#define WS_THICKFRAME			0x00040000L
#define WS_GROUP				0x00020000L
#define WS_TABSTOP				0x00010000L
#define WS_MINIMIZEBOX			0x00020000L
#define WS_MAXIMIZEBOX			0x00010000L
#define WS_TILED				WS_OVERLAPPED
#define WS_ICONIC				WS_MINIMIZE
#define WS_SIZEBOX				WS_THICKFRAME
#define WS_OVERLAPPEDWINDOW		(WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU \
											| WS_THICKFRAME| WS_MINIMIZEBOX	\
															| WS_MAXIMIZEBOX)
#define WS_POPUPWINDOW			(WS_POPUP | WS_BORDER | WS_SYSMENU)
#define WS_CHILDWINDOW			(WS_CHILD)
#define WS_TILEDWINDOW			(WS_OVERLAPPEDWINDOW)

#define WM_INITDIALOG			0x0110
#define WM_COMMAND				0x0111


/******************************************************************************
*                                                                             *
* Хå                                                                *
*                                                                             *
******************************************************************************/
LRESULT CALLBACK DefWindowProc(HWND hWnd,UINT Msg,WPARAM wParam,LPARAM lParam);


#endif
