/*
    Video maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <pthread.h>
#include "command.h"
#include "file.h"
#include "general.h"
#include "jump.h"
#include "prop.h"
#include "save.h"
#include "size.h"
#include "thread.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ˥塼ؿ                                                              *
*                                                                             *
******************************************************************************/
void command_new(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	pthread_t id;

	pthread_create(&id,NULL,(void *)file_open_edit,NULL);
	pthread_detach(id);
}


static gboolean command_open_merge;
static gchar *command_open_file;
static GtkWidget *command_open_dialog,*command_open_check;


static void command_open_ok(GtkWidget *widget,gpointer user_data)
{
	command_open_file=g_strdup(gtk_file_selection_get_filename(
									GTK_FILE_SELECTION(command_open_dialog)));
	if (command_open_check!=NULL)
		command_open_merge=gtk_toggle_button_get_active(
										GTK_TOGGLE_BUTTON(command_open_check));
    gtk_widget_destroy(command_open_dialog);
}


void command_open(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	pthread_t id;
	FileOpen *file_open;

	command_open_file=NULL;
	command_open_dialog=gtk_file_selection_new(_("Open"));
	gtk_signal_connect(
				GTK_OBJECT(command_open_dialog),"destroy",gtk_main_quit,NULL);
	gtk_signal_connect(
				GTK_OBJECT(GTK_FILE_SELECTION(command_open_dialog)->ok_button),
											"clicked",command_open_ok,NULL);
	gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(command_open_dialog)->cancel_button),
				"clicked",gtk_widget_destroy,GTK_OBJECT(command_open_dialog));
	if (open_path!=NULL)
		gtk_file_selection_set_filename(
							GTK_FILE_SELECTION(command_open_dialog),open_path);
	command_open_check=gtk_check_button_new_with_label(_("Continual"));
	gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(command_open_check),
																file_merge);
	gtk_box_pack_start(
				GTK_BOX(GTK_FILE_SELECTION(command_open_dialog)->main_vbox),
											command_open_check,TRUE,TRUE,0);
	gtk_widget_show(command_open_check);
	gtk_widget_show(command_open_dialog);
	gtk_grab_add(command_open_dialog);
	gtk_main();
	if (command_open_file!=NULL) {
		g_free(open_path);
		open_path=misc_get_full_path(command_open_file);
		*g_basename(open_path)='\0';
		file_open=g_malloc(sizeof(FileOpen));
		file_open->file=command_open_file;
		file_open->merge=file_merge=command_open_merge;
		pthread_create(&id,NULL,(void *)file_open_edit,file_open);
		pthread_detach(id);
	}
}


void command_save(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	pthread_t id;
	FileSave *file_save;
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	command_open_file=NULL;
	command_open_check=NULL;
	command_open_dialog=gtk_file_selection_new(_("Save As"));
	gtk_signal_connect(
				GTK_OBJECT(command_open_dialog),"destroy",gtk_main_quit,NULL);
	gtk_signal_connect(
				GTK_OBJECT(GTK_FILE_SELECTION(command_open_dialog)->ok_button),
											"clicked",command_open_ok,NULL);
	gtk_signal_connect_object(
			GTK_OBJECT(GTK_FILE_SELECTION(command_open_dialog)->cancel_button),
				"clicked",gtk_widget_destroy,GTK_OBJECT(command_open_dialog));
	if (save_path!=NULL)
		gtk_file_selection_set_filename(
							GTK_FILE_SELECTION(command_open_dialog),save_path);
	gtk_widget_show(command_open_dialog);
	gtk_grab_add(command_open_dialog);
	gtk_main();
	if (command_open_file!=NULL) {
		g_free(save_path);
		save_path=misc_get_full_path(command_open_file);
		*g_basename(save_path)='\0';
		file_save=g_malloc(sizeof(FileSave));
		file_save->file=command_open_file;
		if (vmaid->avi[0]!=NULL) {
			file_save->max=avi_length(vmaid->avi[0])-1;
			if (vmaid->select.stream>=0) {
				file_save->start=MIN(vmaid->cursor.frame,vmaid->select.frame);
				file_save->end=MIN(MAX(vmaid->cursor.frame,
										vmaid->select.frame)-1,file_save->max);
				if (file_save->start>file_save->end) {
					file_save->start=0;
					file_save->end=file_save->max;
				}
			} else {
				file_save->start=file_save->end
									=MIN(vmaid->cursor.frame,file_save->max);
			}
			file_save->avi[0]=avi_clone(vmaid->avi[0]);
		}
		file_save->avi[1]=vmaid->avi[1]!=NULL?avi_clone(vmaid->avi[1]):NULL;
		if (save_dialog(file_save)) {
			/*  */
			if (file_save->mode==0 || file_save->mode==3) {
				vmaid->edit=FALSE;
				g_free(vmaid->file);
				vmaid->file=g_strdup(command_open_file);
				delete_list(&vmaid->undo);
				delete_list(&vmaid->redo);
				set_menu_bar(vmaid);
			}
			if (file_save->mode!=2 || file_save->start==file_save->end)
				file_set_history(command_open_file);
			/* ¸ */
			pthread_create(&id,NULL,(void *)file_save_edit,file_save);
			pthread_detach(id);
		} else {
			if (file_save->avi[0]!=NULL)
				avi_release(file_save->avi[0]);
			if (file_save->avi[1]!=NULL)
				avi_release(file_save->avi[1]);
			g_free(command_open_file);
		}
	}
}


void command_close(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint page;
	VmaidWindow *vmaid;

	if ((page=gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))>=0) {
		vmaid=gtk_object_get_user_data(GTK_OBJECT(
					gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),page)));
		if (prompt_close(vmaid))
			gtk_notebook_remove_page(GTK_NOTEBOOK(notebook),page);
	}
}


void command_property(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	VmaidWindow *vmaid;
	PropertyDialog prop;

	vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	prop.rate=vmaid->rate;
	prop.scale=vmaid->scale;
	if (vmaid->avi[0]!=NULL) {
		prop.width=avi_get_width(vmaid->avi[0]);
		prop.height=avi_get_height(vmaid->avi[0]);
		prop.bit_count=avi_get_bit_count(vmaid->avi[0]);
		prop.x_pixels_per_meter=avi_get_x_pixels_per_meter(vmaid->avi[0]);
		prop.y_pixels_per_meter=avi_get_y_pixels_per_meter(vmaid->avi[0]);
	} else {
		prop.width=0;
		prop.height=0;
		prop.bit_count=0;
		prop.x_pixels_per_meter=-1;
		prop.y_pixels_per_meter=-1;
	}
	if (vmaid->avi[1]!=NULL) {
		prop.samples_per_sec=avi_get_samples_per_sec(vmaid->avi[1]);
		prop.channels=avi_get_channels(vmaid->avi[1]);
		prop.bits_per_sample=avi_get_bits_per_sample(vmaid->avi[1]);
	} else {
		prop.samples_per_sec=0;
		prop.channels=0;
		prop.bits_per_sample=0;
	}
	if (property_dialog(&prop)) {
		vmaid->rate=prop.rate;
		vmaid->scale=prop.scale;
		if (vmaid->avi[0]!=NULL) {
			avi_set_width(vmaid->avi[0],prop.width);
			avi_set_height(vmaid->avi[0],prop.height);
			avi_set_bit_count(vmaid->avi[0],prop.bit_count);
			avi_set_x_pixels_per_meter(vmaid->avi[0],prop.x_pixels_per_meter);
			avi_set_y_pixels_per_meter(vmaid->avi[0],prop.y_pixels_per_meter);
		}
		if (vmaid->avi[1]!=NULL) {
			avi_set_samples_per_sec(vmaid->avi[1],prop.samples_per_sec);
			avi_set_channels(vmaid->avi[1],prop.channels);
			avi_set_bits_per_sample(vmaid->avi[1],prop.bits_per_sample);
		}
		vmaid->cursor.stream=vmaid->avi[0]!=NULL?0:1;
		vmaid->cursor.frame=0;
		vmaid->select.stream=-1;
		vmaid->select.frame=-1;
		vmaid->top=0;
		delete_list(&vmaid->undo);
		delete_list(&vmaid->redo);
		set_menu_bar(vmaid);
		gtk_widget_draw(vmaid->drawing,NULL);
	}
}


void command_exit(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	GdkEvent event;

	event.any.type=GDK_DELETE;
	event.any.window=window->window;
	event.any.send_event=FALSE;
	gdk_event_put(&event);
}


void command_undo(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	history_operation(vmaid,FALSE);
}


void command_redo(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	history_operation(vmaid,TRUE);
}


void command_cut(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	command_copy(callback_data,callback_action,widget);
	command_delete(callback_data,callback_action,widget);
}


void command_copy(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint i=0,start,end,length,max;
	AviEdit *avi[3];
	VmaidWindow *vmaid;

	if (gtk_selection_owner_set(window,atom_clipboard,GDK_CURRENT_TIME)) {
		vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
		/* ӥǥ */
		if (MIN(vmaid->cursor.stream,vmaid->select.stream)==0) {
			max=avi_length(vmaid->avi[0]);
			start=MAX(MIN(vmaid->cursor.frame,vmaid->select.frame),0);
			end=MIN(MAX(vmaid->cursor.frame,vmaid->select.frame),max);
			length=end-start;
			if (length>0
						&& (avi[i]=avi_copy(vmaid->avi[0],start,length))!=NULL)
				i++;
		}
		/* ǥ */
		if (MAX(vmaid->cursor.stream,vmaid->select.stream)==1) {
			max=avi_length(vmaid->avi[1]);
			start=MAX(avi_time_to_sample(vmaid->avi[1],
					(gint64)MIN(vmaid->cursor.frame,vmaid->select.frame)*1000
												*vmaid->scale/vmaid->rate),0);
			end=MIN(avi_time_to_sample(vmaid->avi[1],
					(gint64)MAX(vmaid->cursor.frame,vmaid->select.frame)*1000
											*vmaid->scale/vmaid->rate),max);
			length=end-start;
			if (length>0 && (avi[i]=avi_copy(vmaid->avi[1],start,length))!=NULL)
				i++;
		}
		if (i>0) {
			g_free(clipboard_scenario);
			avi[i]=NULL;
			clipboard_scenario=avi_to_scenario(avi,FALSE);
			for (i=0;avi[i]!=NULL;i++)
				avi_release(avi[i]);
		}
	}
}


void command_paste(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gtk_selection_convert(window,atom_clipboard,atom_targets,GDK_CURRENT_TIME);
}


void command_delete(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gboolean result=TRUE;
	gint i,start,end,length,max,sx;
	VmaidHistory *d;
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));

	/* UNDOΤν */
	d=g_malloc(sizeof(VmaidHistory));
	for (i=0;i<2;i++) {
		d->avi[i]=NULL;
		if (vmaid->avi[i]!=NULL && (d->avi[i]=avi_clone(vmaid->avi[i]))==NULL)
			result=FALSE;
	}
	if (!result) {
		misc_message_box("Video maid",_("AVI Clone Error"),0,_("OK"),NULL);
		for (i=0;i<2;i++)
			if (d->avi[i]!=NULL)
				avi_release(d->avi[i]);
		g_free(d);
		return;
	}
	d->cursor=vmaid->cursor;
	d->select=vmaid->select;
	/* ӥǥ */
	if (MIN(vmaid->cursor.stream,vmaid->select.stream)==0) {
		max=avi_length(vmaid->avi[0]);
		start=MAX(MIN(vmaid->cursor.frame,vmaid->select.frame),0);
		end=MIN(MAX(vmaid->cursor.frame,vmaid->select.frame),max);
		if (start==0 && end==max) {
			if (!avi_release(vmaid->avi[0]))
				result=FALSE;
			vmaid->avi[0]=NULL;
		} else {
			length=end-start;
			if (length>0 && !avi_delete(vmaid->avi[0],start,length))
				result=FALSE;
		}
	}
	/* ǥ */
	if (MAX(vmaid->cursor.stream,vmaid->select.stream)==1) {
		max=avi_length(vmaid->avi[1]);
		start=MAX(avi_time_to_sample(vmaid->avi[1],
					(gint64)MIN(vmaid->cursor.frame,vmaid->select.frame)*1000
												*vmaid->scale/vmaid->rate),0);
		end=MIN(avi_time_to_sample(vmaid->avi[1],
					(gint64)MAX(vmaid->cursor.frame,vmaid->select.frame)*1000
											*vmaid->scale/vmaid->rate),max);
		if (start==0 && end==max) {
			if (!avi_release(vmaid->avi[1]))
				result=FALSE;
			vmaid->avi[1]=NULL;
		} else {
			length=end-start;
			if (length>0 && !avi_delete(vmaid->avi[1],start,length))
				result=FALSE;
		}
	}
	if (!result) {
		misc_message_box("Video maid",_("AVI Delete Error"),0,_("OK"),NULL);
		for (i=0;i<2;i++) {
			if (vmaid->avi[i]!=NULL)
				avi_release(vmaid->avi[i]);
			vmaid->avi[i]=d->avi[i];
		}
		g_free(d);
		return;
	}
	d->next=vmaid->undo;
	vmaid->undo=d;
	delete_list(&vmaid->redo);
	max=get_max_frame(vmaid,-1)+1;
	sx=MAX((vmaid->drawing->allocation.width-4)/vmaid->width-2,1);
	vmaid->cursor.frame=(vmaid->avi[0]!=NULL || vmaid->avi[1]!=NULL)
							?MIN(vmaid->cursor.frame,vmaid->select.frame):0;
	vmaid->cursor.stream=vmaid->avi[0]==NULL && vmaid->avi[1]==NULL?-1
													:vmaid->avi[0]!=NULL?0:1;
	vmaid->select.stream=-1;
	if (vmaid->cursor.frame>max)
		vmaid->cursor.frame=max;
	if (vmaid->top>vmaid->cursor.frame)
		vmaid->top=vmaid->cursor.frame;
	else if (vmaid->top<vmaid->cursor.frame-sx)
		vmaid->top=MAX(vmaid->cursor.frame-sx,0);
	/* ˥塼,ơȥ,ҥɥ */
	set_menu_bar(vmaid);
	gtk_widget_set_usize(vmaid->drawing,vmaid->width*3+4,system_font_height*2
		+((vmaid->avi[0]!=NULL?1:0)+(vmaid->avi[1]!=NULL?1:0))*vmaid->height);
	gtk_container_queue_resize(GTK_CONTAINER(window));
	gtk_widget_draw(vmaid->drawing,NULL);
	draw_caret(vmaid,NULL);
	misc_set_scroll_bar(vmaid->hscroll,signal_value_changed_hscroll,vmaid,
														0,max,sx,vmaid->top);
	vmaid->edit=TRUE;
}


void command_jump(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint sx,top;
	JumpDialog jump;
	VmaidCursor cursor,select;
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	cursor=vmaid->cursor;
	select=vmaid->select;
	top=vmaid->top;
	jump.frame=vmaid->cursor.frame;
	jump.max=get_max_frame(vmaid,-1)+1;
	jump.rate=vmaid->rate;
	jump.scale=vmaid->scale;
	if (jump_dialog(&jump)) {
		vmaid->cursor.frame=jump.frame;
		sx=MAX((vmaid->drawing->allocation.width-4)/vmaid->width-2,1);
		/* åȤɽ褦Ĵ */
		if (vmaid->top>vmaid->cursor.frame)
			vmaid->top=vmaid->cursor.frame;
		else if (vmaid->top<vmaid->cursor.frame-sx)
			vmaid->top=MAX(vmaid->cursor.frame-sx,0);
		if (vmaid->cursor.frame==vmaid->select.frame) {
			/*  */
			vmaid->select.stream=-1;
			set_menu_bar(vmaid);
		}
		if (vmaid->top!=top)
			misc_set_scroll_bar(vmaid->hscroll,signal_value_changed_hscroll,
											vmaid,0,jump.max,sx,vmaid->top);
		clear_sel(vmaid,&cursor,&select,top);
		draw_caret(vmaid,&cursor);
	}
}


void command_all(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	gint max,sx,top;
	VmaidCursor cursor,select;
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	if (vmaid->avi[0]!=NULL || vmaid->avi[1]!=NULL) {
		cursor=vmaid->cursor;
		select=vmaid->select;
		top=vmaid->top;
		sx=MAX((vmaid->drawing->allocation.width-4)/vmaid->width-2,1);
		max=get_max_frame(vmaid,-1)+1;
		vmaid->select.frame=0;
		vmaid->cursor.frame=max;
		vmaid->select.stream=vmaid->avi[0]==NULL?1:0;
		vmaid->cursor.stream=vmaid->avi[1]==NULL?0:1;
		/* åȤɽ褦Ĵ */
		if (vmaid->top>vmaid->cursor.frame)
			vmaid->top=vmaid->cursor.frame;
		else if (vmaid->top<vmaid->cursor.frame-sx)
			vmaid->top=MAX(vmaid->cursor.frame-sx,0);
		if (select.stream<0)
			set_menu_bar(vmaid);
		if (vmaid->top!=top)
			misc_set_scroll_bar(vmaid->hscroll,signal_value_changed_hscroll,
													vmaid,0,max,sx,vmaid->top);
		clear_sel(vmaid,&cursor,&select,top);
		draw_caret(vmaid,&cursor);
	}
}


void command_size(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	SizeDialog size;
	VmaidWindow *vmaid;

	vmaid=gtk_object_get_user_data(GTK_OBJECT(
				gtk_notebook_get_nth_page(GTK_NOTEBOOK(notebook),
					gtk_notebook_get_current_page(GTK_NOTEBOOK(notebook)))));
	size.view=default_view;
	size.ratio=default_ratio;
	size.width=vmaid->width;
	size.height=vmaid->height;
	if (vmaid->avi[0]!=NULL) {
		size.def_width=avi_get_width(vmaid->avi[0]);
		size.def_height=avi_get_height(vmaid->avi[0]);
	} else {
		size.def_width=0;
		size.def_height=0;
	}
	if (size_dialog(&size)) {
		default_view=size.view;
		default_ratio=size.ratio;
		vmaid->width=size.width;
		vmaid->height=size.height;
		gtk_widget_set_usize(vmaid->drawing,vmaid->width*3+4,
								system_font_height*2+((vmaid->avi[0]!=NULL?1:0)
									+(vmaid->avi[1]!=NULL?1:0))*vmaid->height);
		gtk_container_queue_resize(GTK_CONTAINER(window));
		gtk_widget_draw(vmaid->drawing,NULL);
	}
}


void command_cancel(gpointer callback_data,guint callback_action,
															GtkWidget *widget)
{
	thread_break(FALSE);
}
