/*
    Video maid
    copyright (c) 1998-2002 Kazuki IWAMOTO http://www.maid.org/ iwm@maid.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include "prop.h"
#include "misc/misc.h"


/******************************************************************************
*                                                                             *
* ץѥƥؿ                                                  *
*                                                                             *
******************************************************************************/
static gboolean prop_clicked_ok,prop_changed_entry;
static GtkWidget *dialog,*button0,*combo,*entry;
static GtkWidget *spin0,*spin1,*spin2,*spin3,*spin4,*radio0,*radio2;
static struct {
	const gchar *text;
	const gint bit;
} bit_count[]={{N_("Monochrome"),1},{N_("16 colors"),4},{N_("256 colors"),8},
	{N_("16 bits"),16},{N_("Full Color"),24},{N_("32 bits"),32},{NULL,0}};


/* OKܥ󤬲줿 */
static void prop_dialog_clicked(GtkWidget *widget,PropertyDialog *prop)
{
	gchar *text;
	gint i,rate,scale;

	if (prop_changed_entry) {
		misc_str_to_float(&rate,&scale,gtk_entry_get_text(GTK_ENTRY(entry)));
		prop->rate=rate;
		prop->scale=scale;
	}
	if (prop->width>0 && prop->height>0 && prop->bit_count!=0) {
		prop->width=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0));
		prop->height=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1));
		text=gtk_entry_get_text(GTK_ENTRY(GTK_COMBO(combo)->entry));
		for (i=0;bit_count[i].text!=NULL;i++)
			if (strcmp(gettext(bit_count[i].text),text)==0)
				prop->bit_count=bit_count[i].bit;
		prop->x_pixels_per_meter
					=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin2));
		prop->y_pixels_per_meter
					=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin3));
	}
	if (prop->samples_per_sec!=0 && prop->channels!=0
												&& prop->bits_per_sample!=0) {
		prop->samples_per_sec
					=gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4));
		prop->channels
				=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio0))?1:2;
		prop->bits_per_sample
				=gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(radio2))?8:16;
	}
	gtk_widget_destroy(dialog);
	prop_clicked_ok=TRUE;
}


/* ȥ꡼/ԥܥǥ꥿󤬲줿 */
static void prop_dialog_activate(GtkWidget *widget,PropertyDialog *prop)
{
	gint rate,scale;

	if (misc_str_to_float(&rate,&scale,gtk_entry_get_text(GTK_ENTRY(entry)))
			&& rate>0
			&& (prop->width<=0 || prop->height<=0 || prop->bit_count==0
				|| (gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0))>0
				&& gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1))>0))
			&& (prop->samples_per_sec==0 || prop->channels==0
													|| prop->bits_per_sample==0
				|| gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4))>0))
		prop_dialog_clicked(widget,prop);
}


/* 饸ܥѹ줿 */
#define prop_dialog_toggled prop_dialog_changed
/* ܥܥå/ԥܥѹ줿 */
static void prop_dialog_changed(GtkWidget *widget,PropertyDialog *prop)
{
	gint rate,scale;

	gtk_widget_set_sensitive(button0,
		misc_str_to_float(&rate,&scale,gtk_entry_get_text(GTK_ENTRY(entry)))
		&& rate>0
		&& (prop->width<=0 || prop->height<=0 || prop->bit_count==0
			|| (gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin0))>0
				&& gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin1))>0))
		&& (prop->samples_per_sec==0 || prop->channels==0
													|| prop->bits_per_sample==0
			|| gtk_spin_button_get_value_as_int(GTK_SPIN_BUTTON(spin4))>0));
}


/* ȥ꡼ѹ줿 */
static void prop_dialog_changed_entry(GtkWidget *widget,PropertyDialog *prop)
{
	prop_changed_entry=TRUE;
	prop_dialog_changed(widget,prop);
}


/* ESC줿 */
static gboolean prop_dialog_key_press(GtkWidget *widget,GdkEventKey *event,
															gpointer user_data)
{
	if (event->keyval==GDK_Escape)
		gtk_widget_destroy(widget);
	return FALSE;
}


gboolean property_dialog(PropertyDialog *prop)
{
	gchar *text;
	gint i;
	guint key;
	GList *glist=NULL;
	GtkAccelGroup *accel;
	GtkWidget *button1,*label0,*label1,*label2,*label3,*label4,*label5,*label6;
	GtkWidget *radio1,*radio3,*frame0=NULL,*frame1=NULL,*hbox,*vbox;

	/* ᥤ󥦥ɥ */
	dialog=gtk_window_new(GTK_WINDOW_DIALOG);
	gtk_window_set_title(GTK_WINDOW(dialog),_("Property"));
	gtk_signal_connect_after(GTK_OBJECT(dialog),"key-press-event",
								GTK_SIGNAL_FUNC(prop_dialog_key_press),NULL);
	gtk_signal_connect(GTK_OBJECT(dialog),"destroy",gtk_main_quit,NULL);
	/* 졼 */
	accel=gtk_accel_group_new();
	gtk_accel_group_attach(accel,GTK_OBJECT(dialog));
	/* ܥ */
	button0=gtk_button_new_with_label(_("OK"));
	button1=gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect(GTK_OBJECT(button0),"clicked",prop_dialog_clicked,prop);
	gtk_signal_connect_object(GTK_OBJECT(button1),"clicked",
										gtk_widget_destroy,GTK_OBJECT(dialog));
	GTK_WIDGET_SET_FLAGS(button0,GTK_CAN_DEFAULT);
	GTK_WIDGET_SET_FLAGS(button1,GTK_CAN_DEFAULT);
	/* ȥ꡼ */
	entry=gtk_entry_new();
	text=misc_str_from_float(prop->rate,prop->scale);
	gtk_entry_set_text(GTK_ENTRY(entry),text);
	g_free(text);
	gtk_signal_connect(GTK_OBJECT(entry),"activate",prop_dialog_activate,prop);
	gtk_signal_connect(GTK_OBJECT(entry),"changed",
											prop_dialog_changed_entry,prop);
	gtk_editable_select_region(GTK_EDITABLE(entry),0,-1);
	/* ٥ */
	label0=gtk_label_new(NULL);
	key=gtk_label_parse_uline(GTK_LABEL(label0),_("_Frame per second"));
	gtk_widget_add_accelerator(entry,"grab-focus",accel,key,GDK_MOD1_MASK,0);

	if (prop->width>0 && prop->height>0 && prop->bit_count!=0) {
		/* ܥܥå */
		for (i=0;bit_count[i].text!=NULL;i++)
			glist=g_list_append(glist,gettext(bit_count[i].text));
		combo=gtk_combo_new();
		gtk_combo_set_popdown_strings(GTK_COMBO(combo),glist);
		gtk_combo_set_value_in_list(GTK_COMBO(combo),TRUE,FALSE);
		gtk_editable_set_editable(GTK_EDITABLE(GTK_COMBO(combo)->entry),FALSE);
		for (i=0;bit_count[i].text!=NULL;i++)
			if (bit_count[i].bit==prop->bit_count)
				gtk_entry_set_text(GTK_ENTRY(GTK_COMBO(combo)->entry),
												gettext(bit_count[i].text));
		gtk_signal_connect(GTK_OBJECT(GTK_COMBO(combo)->entry),"changed",
													prop_dialog_changed,prop);
		/* ԥܥ */
		spin0=gtk_spin_button_new(GTK_ADJUSTMENT(
				gtk_adjustment_new(prop->width,1,G_MAXINT,1,5,0)),0,0);
		spin1=gtk_spin_button_new(GTK_ADJUSTMENT(
				gtk_adjustment_new(prop->height,1,G_MAXINT,1,5,0)),0,0);
		spin2=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(
							prop->y_pixels_per_meter,0,G_MAXINT,1,5,0)),0,0);
		spin3=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(
							prop->y_pixels_per_meter,0,G_MAXINT,1,5,0)),0,0);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin0),TRUE);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin1),TRUE);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin2),TRUE);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin3),TRUE);
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin0),GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin1),GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin2),GTK_SHADOW_IN);
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin3),GTK_SHADOW_IN);
		gtk_signal_connect(GTK_OBJECT(spin0),"activate",
													prop_dialog_activate,prop);
		gtk_signal_connect(GTK_OBJECT(spin1),"activate",
													prop_dialog_activate,prop);
		gtk_signal_connect(GTK_OBJECT(spin2),"activate",
													prop_dialog_activate,prop);
		gtk_signal_connect(GTK_OBJECT(spin3),"activate",
													prop_dialog_activate,prop);
		gtk_signal_connect(GTK_OBJECT(spin0),"changed",
													prop_dialog_changed,prop);
		gtk_signal_connect(GTK_OBJECT(spin1),"changed",
													prop_dialog_changed,prop);
		gtk_signal_connect(GTK_OBJECT(spin2),"changed",
													prop_dialog_changed,prop);
		gtk_signal_connect(GTK_OBJECT(spin3),"changed",
													prop_dialog_changed,prop);
		/* ٥ */
		label1=gtk_label_new(NULL);
		label2=gtk_label_new(NULL);
		label3=gtk_label_new(NULL);
		label4=gtk_label_new(NULL);
		label5=gtk_label_new(NULL);
		key=gtk_label_parse_uline(GTK_LABEL(label1),_("_Width"));
		gtk_widget_add_accelerator(spin0,"grab-focus",accel,key,
															GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(label2),_("_Height"));
		gtk_widget_add_accelerator(spin1,"grab-focus",accel,key,
															GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(label3),_("_Color"));
		gtk_widget_add_accelerator(combo,"grab-focus",accel,key,
															GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(label4),_("_X pixels per meter"));
		gtk_widget_add_accelerator(spin0,"grab-focus",accel,key,
															GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(label5),_("_Y pixels per meter"));
		gtk_widget_add_accelerator(spin1,"grab-focus",accel,key,
															GDK_MOD1_MASK,0);

		/* ե졼ȥܥå */
		vbox=gtk_vbox_new(FALSE,8);
		gtk_container_set_border_width(GTK_CONTAINER(vbox),8);

		hbox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),label1,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),spin0,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		hbox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),label2,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),spin1,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		hbox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),label3,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),combo,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		hbox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),label4,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),spin2,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		hbox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),label5,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),spin3,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		frame0=gtk_frame_new(_("Video"));
		gtk_container_add(GTK_CONTAINER(frame0),vbox);
	}

	if (prop->samples_per_sec!=0 && prop->channels!=0
												&& prop->bits_per_sample!=0) {
		/* ԥܥ */
		spin4=gtk_spin_button_new(GTK_ADJUSTMENT(gtk_adjustment_new(
								prop->samples_per_sec,1,G_MAXINT,1,5,0)),0,0);
		gtk_spin_button_set_numeric(GTK_SPIN_BUTTON(spin4),TRUE);
		gtk_spin_button_set_shadow_type(GTK_SPIN_BUTTON(spin4),GTK_SHADOW_IN);
		gtk_signal_connect(GTK_OBJECT(spin4),"activate",
													prop_dialog_activate,prop);
		gtk_signal_connect(GTK_OBJECT(spin4),"changed",
													prop_dialog_changed,prop);
		/* ٥ */
		label6=gtk_label_new(NULL);
		key=gtk_label_parse_uline(GTK_LABEL(label6),_("_Rate"));
		gtk_widget_add_accelerator(spin4,"grab-focus",accel,key,
															GDK_MOD1_MASK,0);
		/* 饸ܥ */
		radio0=gtk_radio_button_new_with_label(NULL,NULL);
		radio1=gtk_radio_button_new_with_label_from_widget(
												GTK_RADIO_BUTTON(radio0),NULL);
		radio2=gtk_radio_button_new_with_label(NULL,NULL);
		radio3=gtk_radio_button_new_with_label_from_widget(
												GTK_RADIO_BUTTON(radio2),NULL);
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio0)->child),
															_("_Monophone"));
		gtk_widget_add_accelerator(radio0,"clicked",accel,key,GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio1)->child),
																_("_Stereo"));
		gtk_widget_add_accelerator(radio1,"clicked",accel,key,GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio2)->child),
																_("_8 bits"));
		gtk_widget_add_accelerator(radio2,"clicked",accel,key,GDK_MOD1_MASK,0);
		key=gtk_label_parse_uline(GTK_LABEL(GTK_BIN(radio3)->child),
																_("_16 bits"));
		gtk_widget_add_accelerator(radio3,"clicked",accel,key,GDK_MOD1_MASK,0);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(
										prop->channels==1?radio0:radio1),TRUE);
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(
								prop->bits_per_sample==8?radio2:radio3),TRUE);
		gtk_signal_connect(GTK_OBJECT(radio0),"toggled",
									GTK_SIGNAL_FUNC(prop_dialog_toggled),prop);
		gtk_signal_connect(GTK_OBJECT(radio1),"toggled",
									GTK_SIGNAL_FUNC(prop_dialog_toggled),prop);
		gtk_signal_connect(GTK_OBJECT(radio2),"toggled",
									GTK_SIGNAL_FUNC(prop_dialog_toggled),prop);
		gtk_signal_connect(GTK_OBJECT(radio3),"toggled",
									GTK_SIGNAL_FUNC(prop_dialog_toggled),prop);
		/* ե졼ȥܥå */
		vbox=gtk_vbox_new(FALSE,8);
		gtk_container_set_border_width(GTK_CONTAINER(vbox),8);

		hbox=gtk_hbox_new(FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),label6,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),spin4,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

		hbox=gtk_hbox_new(FALSE,8);
		gtk_container_set_border_width(GTK_CONTAINER(hbox),8);
		gtk_box_pack_start(GTK_BOX(hbox),radio0,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),radio1,FALSE,FALSE,0);
		frame1=gtk_frame_new(_("Channel"));
		gtk_container_add(GTK_CONTAINER(frame1),hbox);
		gtk_box_pack_start(GTK_BOX(vbox),frame1,FALSE,FALSE,0);

		hbox=gtk_hbox_new(FALSE,8);
		gtk_container_set_border_width(GTK_CONTAINER(hbox),8);
		gtk_box_pack_start(GTK_BOX(hbox),radio2,FALSE,FALSE,0);
		gtk_box_pack_start(GTK_BOX(hbox),radio3,FALSE,FALSE,0);
		frame1=gtk_frame_new(_("Bit"));
		gtk_container_add(GTK_CONTAINER(frame1),hbox);
		gtk_box_pack_start(GTK_BOX(vbox),frame1,FALSE,FALSE,0);

		frame1=gtk_frame_new(_("Audio"));
		gtk_container_add(GTK_CONTAINER(frame1),vbox);
	}

	/* ե졼ȥܥå */
	vbox=gtk_vbox_new(FALSE,8);
	gtk_container_set_border_width(GTK_CONTAINER(vbox),8);

	hbox=gtk_hbox_new(FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),label0,FALSE,FALSE,0);
	gtk_box_pack_start(GTK_BOX(hbox),entry,TRUE,TRUE,0);
	gtk_box_pack_start(GTK_BOX(vbox),hbox,FALSE,FALSE,0);

	if (frame0!=NULL && frame1!=NULL) {
		hbox=gtk_hbox_new(FALSE,8);
		gtk_box_pack_start(GTK_BOX(hbox),frame0,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(hbox),frame1,TRUE,TRUE,0);
		gtk_box_pack_start(GTK_BOX(vbox),hbox,TRUE,TRUE,0);
	} else {
		gtk_box_pack_start(GTK_BOX(vbox),
									frame0!=NULL?frame0:frame1,TRUE,TRUE,0);
	}

	hbox=gtk_hbox_new(FALSE,8);
	gtk_box_pack_end(GTK_BOX(hbox),button1,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(hbox),button0,FALSE,FALSE,0);
	gtk_box_pack_end(GTK_BOX(vbox),hbox,FALSE,FALSE,0);
	gtk_container_add(GTK_CONTAINER(dialog),vbox);

	/* ɽ */
	if (frame1!=NULL)
		gtk_widget_set_sensitive(frame1,FALSE);
	gtk_widget_set_sensitive(button0,FALSE);
	gtk_widget_grab_focus(entry);
	prop_clicked_ok=FALSE;
	prop_changed_entry=FALSE;

	gtk_window_set_policy(GTK_WINDOW(dialog),FALSE,TRUE,FALSE);
	gtk_grab_add(dialog);
	gtk_widget_show_all(dialog);
	gtk_main();

	return prop_clicked_ok;
}
