#!/bin/sh

progname=${0#./}
system=`(uname -s) 2>/dev/null`

libtoolize='libtoolize'
libtool=
aclocal='aclocal'
aclocalo=
autoheader='autoheader'
automake='automake'
autoconf='autoconf'

case ${system} in
  Linux)
    if ! which ${aclocal} >/dev/null 2>/dev/null; then
      aclocal='aclocal-1.8'
    fi
    if ! which ${automake} >/dev/null 2>/dev/null; then
      automake='automake-1.8'
    fi
    ;;
  FreeBSD)
    libtool='/usr/local/share/aclocal/libtool.m4'
    if ! which ${aclocal} >/dev/null 2>/dev/null; then
      aclocal='aclocal14'
    fi
    aclocalo='-I m4'
    if ! which ${autoheader} >/dev/null 2>/dev/null; then
      autoheader='autoheader213'
    fi
    if ! which ${automake} >/dev/null 2>/dev/null; then
      automake='automake14'
    fi
    if ! which ${autoconf} >/dev/null 2>/dev/null; then
      autoconf='autoconf213'
    fi
    ;;
esac

echo; echo; echo "${progname}: libtoolize..."
if test -f acinclude.m4; then
  mv --force acinclude.m4 acinclude.m4.original
  cp --force acinclude.m4.original acinclude.m4
fi
if ${libtoolize} --force && test ${libtool} && test -f ${libtool}; then
  cat ${libtool} >> acinclude.m4
fi

echo; echo; echo "${progname}: aclocal..."
${aclocal} ${aclocalo}
if test -f acinclude.m4.original; then
  mv --force acinclude.m4.original acinclude.m4
else
  rm --force acinclude.m4
fi

echo; echo; echo "${progname}: autoheader..."
${autoheader}

echo; echo; echo "${progname}: automake..."
${automake} --add-missing

echo; echo; echo "${progname}: autoconf..."
${autoconf}
