/***************************************************************************
                          csourceformat.cpp  -  description
                             -------------------
    begin                : 2004ǯ  6 13  16:00:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "csourceformat.h"

/////////////////////////////////////////////////////////////////////////////

QString 
CSourceFormat::sampleFormatString(SampleFormat format)
{
  if ( format == U8 ) {
    return "u8";
  }
  if ( format == S16_LE ) {
    return "s16_le";
  }
  if ( format == S16_BE ) {
    return "s16_be";
  }
  if ( format == S24_LE ) {
    return "s24_le";
  }
  if ( format == S24_BE ) {
    return "s24_be";
  }
  if ( format == S32_LE ) {
    return "s32_le";
  }
  if ( format == S32_BE ) {
    return "s32_be";
  }
  if ( format == F32_LE ) {
    return "f32_le";
  }
  if ( format == F32_BE ) {
    return "f32_be";
  }

  return "";
}

/////////////////////////////////////////////////////////////////////////////

QStringList
CSourceFormat::sampleFormatStringList()
{
  QStringList strlReturn;

  strlReturn.append("u8");
  strlReturn.append("s16_le");
  strlReturn.append("s16_be");
  strlReturn.append("s24_le");
  strlReturn.append("s24_be");
  strlReturn.append("s32_le");
  strlReturn.append("s32_be");
  strlReturn.append("f32_le");
  strlReturn.append("f32_be");

  return strlReturn;
}

/////////////////////////////////////////////////////////////////////////////

CSourceFormat::SampleFormat 
CSourceFormat::sampleFormatIdentifier(const QString& strFormat)
{
  if ( strFormat == "u8" ) {
    return U8;
  }
  if ( strFormat == "s16_le" ) {
    return S16_LE;
  }
  if ( strFormat == "s16_be" ) {
    return S16_BE;
  }
  if ( strFormat == "s24_le" ) {
    return S24_LE;
  }
  if ( strFormat == "s24_be" ) {
    return S24_BE;
  }
  if ( strFormat == "s32_le" ) {
    return S32_LE;
  }
  if ( strFormat == "s32_be" ) {
    return S32_BE;
  }
  if ( strFormat == "f32_le" ) {
    return F32_LE;
  }
  if ( strFormat == "f32_be" ) {
    return F32_BE;
  }

  return Invalid;
}

/////////////////////////////////////////////////////////////////////////////

CSourceFormat::CSourceFormat(
  SampleFormat format/* =S16_LE */, 
  int          nChannel/* =2 */, 
  int          nRate/* =44100 */)
 : sfFormat(format), nChannelCount(nChannel), nSampleRate(nRate)
{
}

/////////////////////////////////////////////////////////////////////////////

CSourceFormat::CSourceFormat(const QString& strEcaFormat)
{
  QStringList strlEcaFormat = QStringList::split(",", strEcaFormat);

  if ( strlEcaFormat.count() != 3 ) { // invalid
    sfFormat      = S16_LE;
    nChannelCount = 2;
    nSampleRate   = 44100;
    return;
  }

  setSampleFormat(strlEcaFormat[0]);

  if ( sfFormat == Invalid ) { // invalid
    sfFormat      = S16_LE;
    nChannelCount = 2;
    nSampleRate   = 44100;
    return;
  }

  bool bResult;
  nChannelCount = strlEcaFormat[1].toInt(&bResult);

  if ( !bResult || nChannelCount < 0 ) { // invalid
    sfFormat      = S16_LE;
    nChannelCount = 2;
    nSampleRate   = 44100;
    return;
  }

  nSampleRate = strlEcaFormat[2].toInt(&bResult);

  if ( !bResult || nSampleRate < 0 ) { // invalid
    sfFormat      = S16_LE;
    nChannelCount = 2;
    nSampleRate   = 44100;
    return;
  }
}

/////////////////////////////////////////////////////////////////////////////

CSourceFormat::~CSourceFormat()
{
}

/////////////////////////////////////////////////////////////////////////////

CSourceFormat::SampleFormat 
CSourceFormat::sampleFormat() const
{
  return sfFormat;
}

/////////////////////////////////////////////////////////////////////////////

int 
CSourceFormat::channelCount() const
{
  return nChannelCount;
}

/////////////////////////////////////////////////////////////////////////////

int 
CSourceFormat::sampleRate() const
{
  return nSampleRate;
}

/////////////////////////////////////////////////////////////////////////////

void 
CSourceFormat::setSampleFormat(SampleFormat format)
{
  sfFormat = format;
}

/////////////////////////////////////////////////////////////////////////////

void 
CSourceFormat::setSampleFormat(const QString& strFormat)
{
  sfFormat = sampleFormatIdentifier(strFormat);
}

/////////////////////////////////////////////////////////////////////////////

void 
CSourceFormat::setChannelCount(int nChannel)
{
  if ( nChannel < 0 ) {
    nChannelCount = 2;
    return;
  }
  nChannelCount = nChannel;
}

/////////////////////////////////////////////////////////////////////////////

void 
CSourceFormat::setSampleRate(int nRate)
{
  if ( nRate < 0 ) {
    nSampleRate = 44100;
    return;
  }
  nSampleRate = nRate;
}

/////////////////////////////////////////////////////////////////////////////

QString
CSourceFormat::sourceFormatInString() const
{
  QString strReturn = sampleFormatString(sfFormat) + ",";
  strReturn += QString("%1,%2").arg(nChannelCount).arg(nSampleRate);
  return strReturn;
}

/////////////////////////////////////////////////////////////////////////////
