/***************************************************************************
                          cecaiamanager.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5 28  17:10:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include "cecaiacontroller.h"

#include <string>
#include <vector>
using namespace std;

/////////////////////////////////////////////////////////////////////////////

const QString CEcaIAController::DQ("\"");

/////////////////////////////////////////////////////////////////////////////

CEcaIAController::CEcaIAController()
{
}

/////////////////////////////////////////////////////////////////////////////

CEcaIAController::~CEcaIAController()
{
}

/////////////////////////////////////////////////////////////////////////////

bool
CEcaIAController::isValidChainsetup()
{
  command("cs-is-valid", false);
  int nValid = ecaEngine.last_integer();

  if ( nValid == 0 ) {
    return false;
  }
  return true;
}

/////////////////////////////////////////////////////////////////////////////

void
CEcaIAController::command(const QString& strCommand, bool bOut)
{
  ecaEngine.command(strCommand.ascii());
  if ( bOut ) {
    emit messageGenerated(strCommand + "\n");
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
CEcaIAController::commandFloatArg(
  const QString& strCommand, 
  double         dArg, 
  bool           bOut)
{
  ecaEngine.command_float_arg(strCommand.ascii(), dArg);
  if ( bOut ) {
    emit messageGenerated(strCommand + "\n");
  }
}

/////////////////////////////////////////////////////////////////////////////

int 
CEcaIAController::lastInteger() const
{
  return ecaEngine.last_integer();
}

/////////////////////////////////////////////////////////////////////////////

long 
CEcaIAController::lastLongInteger() const
{
  return ecaEngine.last_long_integer();
}

/////////////////////////////////////////////////////////////////////////////

double 
CEcaIAController::lastFloat() const
{
  return ecaEngine.last_float();
}

/////////////////////////////////////////////////////////////////////////////

bool 
CEcaIAController::lastBool() const
{
  return ecaEngine.last_boolean();
}

/////////////////////////////////////////////////////////////////////////////

QString 
CEcaIAController::lastString() const
{
  return QString(ecaEngine.last_string().c_str());
}

/////////////////////////////////////////////////////////////////////////////

QStringList 
CEcaIAController::lastStringList() const
{
  QStringList strlReturn;
  vector<string> vstrList = ecaEngine.last_string_list();
  vector<string>::iterator it = vstrList.begin();

  while ( it != vstrList.end() ) {
    strlReturn.append((*it).c_str());
    it++;
  }

  return strlReturn;
}

/////////////////////////////////////////////////////////////////////////////

int 
CEcaIAController::lastCountOfStringList() const
{
  return ecaEngine.last_string_list().size();
}

/////////////////////////////////////////////////////////////////////////////

QString 
CEcaIAController::lastError() const
{
  return QString(ecaEngine.last_error().c_str());
}

/////////////////////////////////////////////////////////////////////////////

QString 
CEcaIAController::lastType() const
{
  return QString(ecaEngine.last_type().c_str());
}

/////////////////////////////////////////////////////////////////////////////

bool 
CEcaIAController::occuredError() const
{
  return ecaEngine.error();
}

/////////////////////////////////////////////////////////////////////////////

bool 
CEcaIAController::areEventsAvailable()
{
  return ecaEngine.events_available();
}

/////////////////////////////////////////////////////////////////////////////

void 
CEcaIAController::advanceNextEvent()
{
  return ecaEngine.next_event();
}

/////////////////////////////////////////////////////////////////////////////

QString
CEcaIAController::currentEvent()
{
  return ecaEngine.current_event().c_str();
}

/////////////////////////////////////////////////////////////////////////////

CEcaIAController::Status
CEcaIAController::engineStatus()
{
  command("engine-status", false);
  QString strStatus = ecaEngine.last_string().c_str();

  if ( strStatus == "running" ) {
    return Running;
  }
  if ( strStatus == "not started" ) {
    return NotStarted;
  }
  if ( strStatus == "stopped" ) {
    return Stopped;
  }
  if ( strStatus == "finished" ) {
    return Finished;
  }
  if ( strStatus == "not ready" ) {
    return NotReady;
  }
  return Error;
}

/////////////////////////////////////////////////////////////////////////////

#include "cecaiacontroller.moc"
