/***************************************************************************
                          ceffectport.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 18  15:57:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "ceffectport.h"

/////////////////////////////////////////////////////////////////////////////

CEffectPort::CEffectPort()
  : strName(), 
    fMax(0.0f), 
    fMin(0.0f)
{
  fValue = fMin;
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort::CEffectPort(
  const QString& strPortName,
  const LADSPA_PortRangeHint& hint)
  : strName(strPortName), 
    fMax(hint.UpperBound), 
    fMin(hint.LowerBound)
{
  fValue = fMin;
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort::CEffectPort(const CEffectPort& src)
  : strName(src.strName), 
    fMax(src.fMax), 
    fMin(src.fMin)
{
  if ( src.fValue < fMin ) {
    fValue = fMin;
  } else if ( src.fValue > fMax ) {
    fValue = fMax;
  } else {
    fValue = src.fValue;
  }
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort::~CEffectPort()
{
}

/////////////////////////////////////////////////////////////////////////////

CEffectPort&
CEffectPort::operator=(const CEffectPort& src)
{
  this->strName = src.strName;
  this->fMax    = src.fMax;
  this->fMin    = src.fMin;
  if ( src.fValue < fMin ) {
    fValue = fMin;
  } else if ( src.fValue > fMax ) {
    fValue = fMax;
  } else {
    fValue = src.fValue;
  }

  return (*this);
}

/////////////////////////////////////////////////////////////////////////////

QString 
CEffectPort::name() const
{
  return strName;
}

/////////////////////////////////////////////////////////////////////////////

float 
CEffectPort::maximumValue() const
{
  return fMax;
}

/////////////////////////////////////////////////////////////////////////////

float 
CEffectPort::minimumValue() const
{
  return fMin;
}

/////////////////////////////////////////////////////////////////////////////

float 
CEffectPort::value() const
{
  return fValue;
}

/////////////////////////////////////////////////////////////////////////////

void 
CEffectPort::setName(const QString& strPortName)
{
  this->strName = strPortName;
}

/////////////////////////////////////////////////////////////////////////////

void 
CEffectPort::setMaximumValue(float fMaxValue)
{
  this->fMax = fMaxValue;
}

/////////////////////////////////////////////////////////////////////////////

void 
CEffectPort::setMinimumValue(float fMinValue)
{
  this->fMin = fMinValue;
}

/////////////////////////////////////////////////////////////////////////////

void 
CEffectPort::setValue(float fPortValue)
{
  if ( fPortValue < fMin ) {
    fValue = fMin;
  } else if ( fPortValue > fMax ) {
    fValue = fMax;
  } else {
    fValue = fPortValue;
  }
}

/////////////////////////////////////////////////////////////////////////////
