/***************************************************************************
                          weffectporteditor.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 19  16:15:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <qlayout.h>
#include <qlabel.h>
#include "weffectporteditor.h"

/////////////////////////////////////////////////////////////////////////////

WEffectPortEditor::WEffectPortEditor(
  const CLadspaEffect& effectDisplay,
  QWidget*             WidgetParent,
  const char*          cName)
  : QScrollView(WidgetParent, cName), 
    effect(effectDisplay)
{
  VBoxBase = new QVBox(this->viewport());
  this->addChild(VBoxBase);

  setupWidgets();
}

/////////////////////////////////////////////////////////////////////////////

WEffectPortEditor::~WEffectPortEditor()
{
}

/////////////////////////////////////////////////////////////////////////////

void 
WEffectPortEditor::setupWidgets()
{
  //!!
  /*  //  QLabel* LabelTest = new QLabel("test", this);
  KDoubleNumInput* Input = new KDoubleNumInput(this);
  Input->setMaxValue(2.0);
  Input->setMinValue(0.0);
  Input->setValue(1.0);
  printf("%d\n", this->height());
  */
  QValueVector<KDoubleNumInput*>::iterator it = vInputs.begin();
  while ( it != vInputs.end() ) {
    delete (*it);
    (*it) = NULL;
    it++;
  }
  vInputs.clear();

  int nCount = effect.effectPortCount();
  int i;

  for ( i = 0; i < nCount; i++ ) {
    CEffectPort port = effect.effectPort(i);

    KDoubleNumInput* Input = new KDoubleNumInput(VBoxBase);
    QString strLabel = port.name();
    strLabel += QString(" [%1  -  %2]").
      arg(port.minimumValue()).arg(port.maximumValue());
    Input->setLabel(strLabel);
    Input->setRange(port.minimumValue(), 
                    port.maximumValue(), 
                    0.1, 
                    true);
    Input->setValue(1.0);

    vInputs.push_back(Input);
  }

  if ( vInputs.size() == 0 ) {
    return;
  }
    
  int nWidth = vInputs[0]->sizeHint().width() + this->verticalScrollBar()->width();
  this->setMaximumWidth(nWidth);
  this->setMinimumWidth(nWidth);
}

/////////////////////////////////////////////////////////////////////////////

void 
WEffectPortEditor::slotSetEffect(const CLadspaEffect& effectDisplay)
{
  this->effect = effectDisplay;

  setupWidgets();
}

/////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////

#include "weffectporteditor.moc"
