/***************************************************************************
                          wladspadialog.cpp  -  description
                             -------------------
    begin                : 2004ǯ  7 18  02:26:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdlib.h>
#include <ladspa.h>
#include <qcursor.h>
#include <qdir.h>
#include <qlayout.h>
#include <qpushbutton.h>
#include <klocale.h>
#include "wladspadialog.h"
#include "cladspapluginlibrary.h"

/////////////////////////////////////////////////////////////////////////////

WLadspaDialog::WLadspaDialog(
  const QString& strLadspaPluginPath, 
  QWidget*       WidgetParent,
  const char*    cName)
  : KDialogBase(KDialogBase::Plain,
                "Set Effects",
                Ok | Cancel,
                Ok,
                WidgetParent,
                cName)
{
  nIDApply = 0;
  PortEditor = NULL;

  slotSetLadspaPath(strLadspaPluginPath);

  setupWidgets();
  setupPopupMenus();
  slotLoadAvailableEffects();
}

/////////////////////////////////////////////////////////////////////////////

WLadspaDialog::~WLadspaDialog()
{
}

/////////////////////////////////////////////////////////////////////////////

void 
WLadspaDialog::setupWidgets()
{
  QFrame *FramePage = plainPage();

  QVBoxLayout* LayoutTop = new QVBoxLayout(FramePage);
  QLabel*      Label;

  // display LADSPA path
  {
    QHBoxLayout* Layout = new QHBoxLayout(FramePage);

    Label = new QLabel(FramePage);
    LabelLadspaPath = new QLabel(FramePage);
    LabelLadspaPath->setFrameStyle(QFrame::Panel | QFrame::Sunken);
    Layout->addWidget(Label);
    Layout->addWidget(LabelLadspaPath);
    Layout->addStretch();

    if ( !this->strLadspaPath.isEmpty() ) {
      Label->setText(i18n("Searched plugin from "));
      Label->setAlignment(AlignRight);
      LabelLadspaPath->setText(this->strLadspaPath);
    }

    LayoutTop->addLayout(Layout);
  }

  LayoutTop->insertSpacing(1, 20);

  // display effect lists (available and applied)
  {
    QHBoxLayout* LayoutEffect = new QHBoxLayout(FramePage);

    // display available effect list
    {
      QVBoxLayout* Layout = new QVBoxLayout(FramePage);
      Label = new QLabel(i18n("Available effects list"), FramePage);
      Layout->addWidget(Label);

      ListViewAvailable = new KListView(FramePage);
      ListViewAvailable->addColumn(i18n("Effect"));
      ListViewAvailable->addColumn(i18n("File"));
      ListViewAvailable->addColumn(i18n("ID"));
      ListViewAvailable->setColumnWidthMode(0, QListView::Manual);
      ListViewAvailable->setColumnWidthMode(2, QListView::Manual);
      ListViewAvailable->setColumnWidth(0, 100);
      ListViewAvailable->hideColumn(2);
      connect(ListViewAvailable, 
              SIGNAL(doubleClicked(QListViewItem*, const QPoint&, int)), 
              this, 
              SLOT(slotAdd()));
      Layout->addWidget(ListViewAvailable);

      LayoutEffect->addLayout(Layout);
    }

    // display command buttons
    {
      QVBoxLayout* Layout = new QVBoxLayout(FramePage);
      QPushButton* Button;

      Layout->addStretch();
      Button = new QPushButton(i18n("Add"), FramePage);
      connect(Button, SIGNAL(clicked()), this, SLOT(slotAdd()));
      Layout->addWidget(Button);

      Button = new QPushButton(i18n("Remove"), FramePage);
      connect(Button, SIGNAL(clicked()), this, SLOT(slotRemove()));
      Layout->addWidget(Button);

      Layout->addStretch();
      Layout->addStretch();

      LayoutEffect->addLayout(Layout);
    }

    // display applied effect list
    {
      QVBoxLayout* Layout = new QVBoxLayout(FramePage);
      Label = new QLabel(i18n("Applied effects list"), FramePage);
      Layout->addWidget(Label);

      ListViewApply = new KListView(FramePage);
      ListViewApply->addColumn(i18n("Effect"));
      ListViewApply->addColumn(i18n("File"));
      ListViewApply->addColumn(i18n("ID"));
      ListViewApply->setColumnWidthMode(0, QListView::Manual);
      ListViewApply->setColumnWidthMode(1, QListView::Manual);
      ListViewApply->setColumnWidthMode(2, QListView::Manual);
      ListViewApply->setColumnWidth(0, 100);
      ListViewApply->hideColumn(2);
      connect(ListViewApply, SIGNAL(selectionChanged()), 
              this, SLOT(slotShowParamEditor()));
      Layout->addWidget(ListViewApply);

      LayoutEffect->addLayout(Layout);
    }

    LayoutTop->addLayout(LayoutEffect);
  }

  LayoutTop->insertSpacing(3, 10);

  // display port editor panel
  {
    WidgetEditor = new QWidget(FramePage);
    WidgetEditor->setMinimumHeight(220);

    QVBoxLayout* Layout = new QVBoxLayout(WidgetEditor);
    Label = new QLabel(i18n("Selected effect's parameter"), WidgetEditor);
    Layout->addWidget(Label);

    LayoutEditor = new QHBoxLayout(WidgetEditor);
    Layout->addLayout(LayoutEditor);

    LabelEffectName = new QLabel("Not selected", WidgetEditor);
    LayoutEditor->addWidget(LabelEffectName);

    LayoutEditor->addStretch();

    LayoutTop->addWidget(WidgetEditor);
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
WLadspaDialog::setupPopupMenus()
{
  // available-list's popup
  {
    PopupAvailable = new QPopupMenu(ListViewAvailable);
    PopupAvailable->insertItem(i18n("Add"),
                      this, 
                      SLOT(slotAdd()));
    connect(ListViewAvailable, 
            SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)), 
            this, 
            SLOT(slotPopupAvailable()));
  }

  // applied-list's popup
  {
    PopupApplied = new QPopupMenu(ListViewApply);
    PopupApplied->insertItem(i18n("Remove"),
                      this, 
                      SLOT(slotRemove()));
    connect(ListViewApply, 
            SIGNAL(rightButtonPressed(QListViewItem*, const QPoint&, int)), 
            this, 
            SLOT(slotPopupApplied()));
  }
}

/////////////////////////////////////////////////////////////////////////////

QString 
WLadspaDialog::ladspaPath() const
{
  return strLadspaPath;
}

/////////////////////////////////////////////////////////////////////////////

void 
WLadspaDialog::slotSetLadspaPath(const QString& strPath)
{
  if ( strPath.isEmpty() ) {
    strLadspaPath = getenv("LADSPA_PATH");
  } else {
    strLadspaPath = strPath;
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
WLadspaDialog::slotLoadAvailableEffects()
{
  QDir dirLadspa(this->strLadspaPath);
  dirLadspa.setFilter(QDir::Files);
  int  nFiles = dirLadspa.count();
  int  i;
  int  nID = 0;

  ListViewAvailable->clear();
  effectsAvailable.clear();

  for ( i = 0; i < nFiles; i++ ) {
    QString strFileName = dirLadspa.path();
    strFileName += "/" + dirLadspa.entryList()[i];

    CLadspaPluginLibrary pluginLib(strFileName);
    if ( !pluginLib.isLadspaPluginLibrary() ) {
      continue;
    }

    int nEffects = pluginLib.effectCount();
    int j;
    for ( j = 0; j < nEffects; j++ ) {
      QListViewItem* Item = new QListViewItem(ListViewAvailable);
      Item->setText(0, pluginLib.effect(j).name());
      Item->setText(1, dirLadspa.entryList()[i]);
      Item->setText(2, QString("%1").arg(nID++));
      ListViewAvailable->insertItem(Item);
      effectsAvailable.push_back(pluginLib.effect(j));
    }
  }
}

/////////////////////////////////////////////////////////////////////////////

void
WLadspaDialog::slotAdd()
{
  const QListViewItem* Item = ListViewAvailable->selectedItem();
  if ( Item == NULL ) {  // not selected
    return;
  }

  int nID = Item->text(2).toInt();
  effectsApply.push_back(effectsAvailable[nID]);

  QListViewItem* ItemAdd = new QListViewItem(ListViewApply);
  ItemAdd->setText(0, Item->text(0));
  ItemAdd->setText(1, Item->text(1));
  // effectAvailableΤˡID򿶤롣
  ItemAdd->setText(2, QString("%1").arg(nIDApply++));
  ListViewApply->insertItem(ItemAdd);
}

/////////////////////////////////////////////////////////////////////////////

void
WLadspaDialog::slotRemove()
{
  QListViewItem* Item = ListViewApply->selectedItem();
  if ( Item == NULL ) {  // not selected
    return;
  }

  int nID = Item->text(2).toInt();
  int i = 0;
  QValueVector<CLadspaEffect>::iterator it = effectsApply.begin();
  while ( it != effectsApply.end() ) {
    if ( i == nID ) {
      effectsApply.erase(it);
      break;
    }

    it++;
    i++;
  }

  ListViewApply->takeItem(Item);

  if ( PortEditor != NULL ) {
    delete PortEditor;
    PortEditor = NULL;
  }
}

/////////////////////////////////////////////////////////////////////////////

void 
WLadspaDialog::slotShowParamEditor()
{
  if ( PortEditor != NULL ) {
    delete PortEditor;
    PortEditor = NULL;
  }

  QListViewItem* Item = ListViewApply->selectedItem();
  if ( Item == NULL ) {  // not selected
    LabelEffectName->setText("Not selected");
    return;
  }

  LabelEffectName->setText(Item->text(0));
  PortEditor = new WEffectPortEditor(
                     effectsApply[Item->text(2).toInt()], 
                     WidgetEditor);
  LayoutEditor->addWidget(PortEditor);
  PortEditor->show();
}

/////////////////////////////////////////////////////////////////////////////

void 
WLadspaDialog::slotPopupAvailable()
{
  PopupAvailable->exec(QCursor::pos());
}

/////////////////////////////////////////////////////////////////////////////

void 
WLadspaDialog::slotPopupApplied()
{
  PopupApplied->exec(QCursor::pos());
}

/////////////////////////////////////////////////////////////////////////////

#include "wladspadialog.moc"
