/***************************************************************************/
/*! \file   wladspadialog.h
    \brief  饹WLadspaDialogΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  7 14  23:13:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WLADSPADIALOG_H
#define WLADSPADIALOG_H

#include <qvaluevector.h>
#include <qlabel.h>
#include <qpopupmenu.h>
#include <kdialogbase.h>
#include <klistview.h>
#include "weffectporteditor.h"
#include "cladspaeffect.h"

/*-------------------------------------------------------------------------*/
/*! \class  WLadspaDialog
    \brief  LADSPAץ饰󥨥եȥ
*/
/*-------------------------------------------------------------------------*/
class WLadspaDialog : public KDialogBase
{
  Q_OBJECT

public:
  //! \brief 󥹥ȥ饯
  //! \param strLadspaPluginPath LADSPAץ饰Υѥ
  //! ʸ󤬻ꤵ줿硢ĶѿLADSPA_PATHȤ롣
  //! \param WidgetParent ƥåȤؤΥݥ󥿡
  //! \param cName åȤ̾Ρ
  WLadspaDialog(
    const QString& strLadspaPluginPath="", 
    QWidget* WidgetParent=0, 
    const char* cName=0);
  //! \brief ǥȥ饯
  ~WLadspaDialog();

  QString ladspaPath() const;

private:
  //! Ѳǽʥեȡ
  QValueVector<CLadspaEffect> effectsAvailable;
  //! ŬѤ륨եȡ
  QValueVector<CLadspaEffect> effectsApply;
  //! ѲǽʥեȤŬѤ륨եȤΤǻѤ롣
  int nIDApply;

  //! ꤵƤLADSPAץ饰Υѥɽ뤿Υåȡ
  QLabel*       LabelLadspaPath;
  //! ѲǽʥեȤɽꥹȥӥ塼
  KListView*    ListViewAvailable;
  //! ŬѤ륨եȤɽꥹȥӥ塼
  KListView*    ListViewApply;
  //! եȥݡȥѥ᡼ǥɽΰ衣
  QWidget*      WidgetEditor;
  //! ե̾Τɽ륦åȡ
  QLabel*       LabelEffectName;
  //! եȥݡȥѥ᡼ǥɽ쥤ȡ
  QHBoxLayout*  LayoutEditor;
  //! եȥݡȥѥ᡼ǥ
  WEffectPortEditor* PortEditor;
  //! LADSPAץ饰Υѥ
  QString       strLadspaPath;
  //! ListViewAvailableΥݥåץåס
  QPopupMenu*   PopupAvailable;
  //! ListViewAppliedΥݥåץåס
  QPopupMenu*   PopupApplied;

  //! \brief ΥåȤ롣
  void setupWidgets();
  //! \brief ݥåץåץ˥塼ꤹ롣
  void setupPopupMenus();

public slots:
  //! \brief  LADSPAץ饰Υѥꤹ롣
  //! ʸ󤬻ꤵ줿硢ĶѿLADSPA_PATHȤ롣
  void slotSetLadspaPath(const QString& strPath="");

private slots:
  //! \brief strLadspaPathˤץ饰ɤ롣
  void slotLoadAvailableEffects();
  //! \brief  ListViewAvailable򤵤Ƥ륢ƥ
  //! ListViewApplyزä뤿Υåȡ
  void slotAdd(/*//!!*/);
  //! \brief  ListViewApply򤵤Ƥ륢ƥ
  //! 뤿Υåȡ
  void slotRemove(/*//!!*/);
  //! \brief  ListViewApply򤵤Ƥ륢ƥΥݡȥѥ᡼
  //! ԽåȤɽ뤿Υåȡ
  void slotShowParamEditor();
  //! \brief  ListViewAvailableΥݥåץåפ򳫤
  void slotPopupAvailable();
  //! \brief  ListViewApplyΥݥåץåפ򳫤
  void slotPopupApplied();
};

#endif
