/***************************************************************************
                          main.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  16:06:12 JST
    copyright            : (C) 2004 by Tomoaki Murakami
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <kapplication.h>
#include <kaboutdata.h>
#include <kcmdlineargs.h>
#include <kimageio.h>
#include <klocale.h>
#include "wvoxstorm.h"

/////////////////////////////////////////////////////////////////////////////

static const char description[] =
  I18N_NOOP("A KDE KPart Application");

static const char version[] = "0.1";

static KCmdLineOptions options[] =
{
//  { "+[URL]", I18N_NOOP( "Document to open." ), 0 },
  KCmdLineLastOption
};

/////////////////////////////////////////////////////////////////////////////

int main(int argc, char **argv)
{
  KAboutData about("voxstorm",
                   I18N_NOOP("VoxStorm"),
                   version, 
                   description,
                   KAboutData::License_GPL, 
                   "(C) 2004 Tomoaki Murakami", 
                   0, 
                   0, 
                   "solarisphere@yahoo.co.jp");

  about.addAuthor( "Tomoaki Murakami", 0, "solarisphere@yahoo.co.jp" );
  KCmdLineArgs::init(argc, argv, &about);
  KCmdLineArgs::addCmdLineOptions( options );

  KApplication Application;
  WVoxStorm*   VoxStorm = NULL;

  if ( Application.isRestored() ) {
    RESTORE(WVoxStorm);
  } else {
    // no session.. just start up normally
    KCmdLineArgs *args = KCmdLineArgs::parsedArgs();

    /// @todo do something with the command line args here

    VoxStorm = new WVoxStorm();
    Application.setMainWidget(VoxStorm);
    VoxStorm->show();

    args->clear();
  }

  // mainWin has WDestructiveClose flag by default, so it will delete itself.
  return Application.exec();
}
