/***************************************************************************
                          cvoxstormglobal.cpp  -  description
                             -------------------
    begin                : 2004ǯ  5  4  17:08:12 JST
    copyright            : (C) 2003 by Black Sabbath
    email                : solarisphere@yahoo.co.jp
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qfileinfo.h>
#include <qregexp.h>
#include "cvoxstormglobal.h"

/////////////////////////////////////////////////////////////////////////////

const QString CVoxStormGlobal::ValidCharsTrack("0123456789"
                          "abcdefghijklmnopqrstuvwxyz"
                          "ABCDEFGHIJKLMNOPQRSTUVWXYZ"
                          "_");

const QString CVoxStormGlobal::ReservedString1("all");
const QString CVoxStormGlobal::ReservedString2("alsa");
const QString CVoxStormGlobal::ReservedString3("alsahw");
const QString CVoxStormGlobal::ReservedString4("alsaplugin");
const QString CVoxStormGlobal::ReservedString5("alsaplugin");
const QString CVoxStormGlobal::ReservedString6("jack");
const QString CVoxStormGlobal::ReservedString7("jack_alsa");
const QString CVoxStormGlobal::ReservedString8("jack_auto");
const QString CVoxStormGlobal::ReservedString9("jack_generic");
QStringList   CVoxStormGlobal::ReservedStringList;

/////////////////////////////////////////////////////////////////////////////

QString
CVoxStormGlobal::replaceQuartedToSlash(const QString& strSrc, 
                                  QStringList* pstrlOrg)
{
  //   strSrcʲʸä硢
  //  "abcde"  abc'de' \"abcde\" "ab'c'de"
  //  ʲΤ褦Ѵ롣
  //  //0// abc//1// "abcde" //2//

  QString strReturn;  // ̤ʸ
  QString strTmp;     // ִʸΰǼΰ
  QString strSlash;   // "//n"ʸ˻Ѥ
  int     i;
  int     nLoop;
  char    cObject;    // Ĵоݤʸ

  // ϥ󥰥륯Ȥȯơλ󥰥륯Ȥ
  // ȯޤǤδtrue
  bool    bOpenedSQ = false;
  // ϥ֥륯Ȥȯơλ֥륯Ȥ
  // ȯޤǤδtrue
  bool    bOpenedDQ = false;
  // bOpenedSQbOpenedDQƱtrueˤʤ뤳ȤϤʤ

  // ִ줿ʸι
  int nReplace = 0;

  if ( pstrlOrg != NULL ) {
    pstrlOrg->clear();
  }

  nLoop = strSrc.length();
  for ( i = 0; i < nLoop; i++ ) {
    cObject = (strSrc.ascii())[i];  // ĴоݤʸcObject

    if ( cObject == '\\' ) {   // ץ
      if ( i < (nLoop - 1) ) { // ܤƤʸǸʸǤʤ
        // Τޤ޷ʸɲ
        strReturn += cObject;               // Хåå
        strReturn += (strSrc.ascii())[i + 1]; // פ줿ʸ
      } else {                 // ܤƤʸǸʸä
        // Τޤ޷ʸɲ
        strReturn += cObject;
      }

      i++;
      continue;
    }

    // פƤʤơĴ
    if ( cObject == '\"' ) {        // ֥륯ơ
      // 󥰥륯ơ˰Ϥޤ줿֥륯ơ
      // ä硢⤷ʤ[ʤǤʤʸ]
      if ( bOpenedSQ ) {
        ;
      } else {
        if ( bOpenedDQ ) {  // ϥơȯƤ
          if ( pstrlOrg != NULL ) {
            pstrlOrg->append(strTmp);
          }
          strReturn += strSlash.sprintf("%s%d%s",
                          QString("//").ascii(), nReplace, QString("//").ascii());
          nReplace++;
          bOpenedDQ = false;
        } else {            // ϥơȯƤʤä
          bOpenedDQ = true;
          strTmp = "";      // ִʸΰ
        }
        continue;
      }
    } else if ( cObject == '\'' ) { // 󥰥륯ơ
      // ֥륯ơ˰Ϥޤ줿󥰥륯ơ
      // ä硢⤷ʤ[ʤǤʤʸ]
      if ( bOpenedDQ ) {
       ;
      } else {
        if ( bOpenedSQ ) {  // ϥơȯƤ
          if ( pstrlOrg != NULL ) {
            pstrlOrg->append(strTmp);
          }
          strReturn += strSlash.sprintf("%s%d%s",
                          QString("//").ascii(), nReplace, QString("//").ascii());
          nReplace++;
          bOpenedSQ = false;
        } else {            // ϥơȯƤʤä
          bOpenedSQ = true;
          strTmp = "";      // ִʸΰ
        }
        continue;
      }
    }

    // ʤǤʤʸ
    if ( bOpenedDQ || bOpenedSQ) {  // ϥơȯƤ
      strTmp += cObject;    // ִʸΰɲ
    } else {                        // ơ˰ϤޤƤʤʸ
      strReturn += cObject; // ʸɲ
    }
  }

  return strReturn;
}

/////////////////////////////////////////////////////////////////////////////

int
CVoxStormGlobal::findStringFromList(const QString& strSrc,
                               const QStringList& strlList)
{
  int i = 0;
  QStringList::ConstIterator it = strlList.constBegin();

  while ( it != strlList.constEnd() ) {
    if ( (*it) == strSrc ) {
      return i;
    }

    it++;
    i++;
  }

  return -1;
}

/////////////////////////////////////////////////////////////////////////////

QString
CVoxStormGlobal::fenceString(const QString& strSrc)
{
  if ( strSrc.find(QChar(' ')) != -1 ) {
    return "\"" + strSrc + "\"";
  } else {
    return strSrc;
  }
}

/////////////////////////////////////////////////////////////////////////////

bool 
CVoxStormGlobal::isSupportedFileType(const QString& strFileName)
{
  QFileInfo FileInfo(strFileName);
  QString   strExt = (FileInfo.extension(false)).lower();
  if ( strExt == "wav" ) {
    return true;
  }
  if ( strExt == "mp3" ) {
    return true;
  }

  return false;
}

/////////////////////////////////////////////////////////////////////////////

bool 
CVoxStormGlobal::isValidTrackName(const QString& strTrackName)
{
  setupReservedStringList();

  if ( strTrackName.length() > 64 ) {
    return false;
  }

  if ( strTrackName.contains(QRegExp("[^a-zA-Z0-9_]")) ) {
    return false;
  }
  
  QStringList::ConstIterator it = ReservedStringList.constBegin();

  while ( it != ReservedStringList.constEnd() ) {
    if ( strTrackName == *it ) {
      return false;
    }
    it++;
  }

  return true;
}

/////////////////////////////////////////////////////////////////////////////

void 
CVoxStormGlobal::setupReservedStringList()
{
  if ( ReservedStringList.size() == 0 ) {
    ReservedStringList.append(ReservedString1);
    ReservedStringList.append(ReservedString2);
    ReservedStringList.append(ReservedString3);
    ReservedStringList.append(ReservedString4);
    ReservedStringList.append(ReservedString5);
    ReservedStringList.append(ReservedString6);
    ReservedStringList.append(ReservedString7);
    ReservedStringList.append(ReservedString8);
    ReservedStringList.append(ReservedString9);
  }
}

/////////////////////////////////////////////////////////////////////////////
