/***************************************************************************/
/*! \file   wsoundlocator.h
    \brief  饹WSoundLocatorΥإåե롣
    \author Tomoaki Murakami
    \date   2004ǯ  5 30  02:10:12 JST
*/
/***************************************************************************/

/***************************************************************************
 *   Copyright (C) 2004 by Tomoaki Murakami                                *
 *   solarisphrere@yahoo.co.jp                                             *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#ifndef WSOUNDLOCATOR_H
#define WSOUNDLOCATOR_H

#include <qscrollview.h>
#include <qdatetime.h>
#include "wganttitem.h"

/*-------------------------------------------------------------------------*/
/*! \class  WSoundLocator
    \brief  ֤ԤΥåȡ
*/
/*-------------------------------------------------------------------------*/
class WSoundLocator : public QScrollView
{
  Q_OBJECT

public:
  //! brief 󥹥ȥ饯
  WSoundLocator(QWidget *WidgetParent = 0, 
                const char *cName = 0);
  //! brief ǥȥ饯
  virtual ~WSoundLocator();

  //! ()
  void setBaseColor(const QColor& color);
  //! (ƥɽ)
  void setItemFaceColor(const QColor& color);
  //! (ƥ२å)
  void setItemEdgeColor(const QColor& color);

  //! եȴϢդ롣
  //! strFileName ե̾Ρ
  void bind(const QString& strFileName);
  //! եȤδϢդä롣
  void releaseBinding();
  //! եĹ֤
  QTime sourceLength() const;

  //! եκ֤֤
  QTime startPosition() const;
  //! եΥեåȤ֤
  QTime offset() const;
  //! եκĹ֤
  QTime length() const;

private:
  //! (Хå饦)
  QWidget    *WidgetBase;
  //! ȥ㡼ǡ
  WGanttItem *GanttItem;
  //! ե̾Ρ
  QString     strSrcFileName;

public slots:
  //! \brief κϰ֤ꤹ롣
  void slotSetStartPosition(const QTime& time);
  //! \brief ΥեåȤꤹ롣
  void slotSetOffset(const QTime& time);
  //! \brief κĹꤹ롣
  void slotSetLength(const QTime& time);

private slots:
  //! \brief κϰ֤ѹ줿Υåȡ
  //! nSecondQTimeѴƥʥȯ롣
  //! \param nSecond ÿ
  void slotChangedStartPosition(int nSecond);
  //! \brief ΥեåȤѹ줿Υåȡ
  //! nSecondQTimeѴƥʥȯ롣
  //! \param nSecond ÿ
  void slotChangedOffset(int nSecond);
  //! \brief κĹѹ줿Υåȡ
  //! nSecondQTimeѴƥʥȯ롣
  //! \param nSecond ÿ
  void slotChangedLength(int nSecond);

signals:
  //! κϰ֤ѹ줿ȯ륷ʥ롣
  void startPositionChanged(const QTime&);
  //! ΥեåȤѹ줿ȯ륷ʥ롣
  void offsetChanged(const QTime&);
  //! κĹѹ줿ȯ륷ʥ롣
  void lengthChanged(const QTime&);
};

#endif
