/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.text;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jp.coppermine.voyager.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSVProcessor
implements Iterable<String> {
    private List<String> fields = new ArrayList<String>();

    public CSVProcessor() {
    }

    public CSVProcessor(Reader reader) throws IOException {
        this();
        String chunk;
        BufferedReader buffer = reader instanceof BufferedReader ? (BufferedReader)reader : new BufferedReader(reader);
        StringBuilder field = new StringBuilder();
        while ((chunk = buffer.readLine()) != null) {
            field.append(chunk).append("\n");
            if (Strings.countOf((CharSequence)field, 34) % 2 != 0) continue;
            field.deleteCharAt(field.length() - 1);
            this.fields.add(field.toString());
            field.setLength(0);
        }
    }

    public CSVProcessor(File file) throws IOException {
        this(new FileReader(file));
    }

    public CSVProcessor(File file, Charset charset) throws IOException {
        this(new InputStreamReader((InputStream)new FileInputStream(file), charset));
    }

    @Override
    public Iterator<String> iterator() {
        return this.fields.iterator();
    }

    public String read(int index) {
        return this.fields.get(index);
    }

    public void insert(int index, CharSequence field) {
        this.fields.add(index, field.toString());
    }

    public void update(int index, CharSequence field) {
        this.fields.set(index, field.toString());
    }

    public void delete(int index) {
        this.fields.remove(index);
    }

    public String toString() {
        return Strings.join(Strings.Delimiter.NEWLINE, (CharSequence[])this.fields.toArray(new String[this.fields.size()]));
    }

    public static class Codec {
        private static final String REGEX = "\\G(?:^|,) \n(?: \n   # a field enclosed double-quotes ... \n   \" # an open quote of a field  \n    ( (?: [^\"]++ | \"\" | \n )*+ ) \n   \" # a close quote of a field \n | # ... or ... \n      # ... a plain text not use quotes and commas \n   ( [^\",]*) \n ) \n";

        public static final String[] decode(CharSequence field) {
            if (field.length() == 0 || field.toString().length() == 0) {
                return Strings.ZERO;
            }
            Matcher mMain = Pattern.compile(REGEX, 4).matcher(Strings.EMPTY);
            Matcher mQuote = Pattern.compile("\"\"").matcher(Strings.EMPTY);
            ArrayList<String> entries = new ArrayList<String>();
            mMain.reset(field);
            while (mMain.find()) {
                String entry = mMain.start(2) >= 0 ? mMain.group(2).trim() : mQuote.reset(mMain.group(1)).replaceAll("\"");
                entries.add(entry);
            }
            return entries.toArray(new String[entries.size()]);
        }

        public static final String encode(CharSequence ... entries) {
            ArrayList<String> entryList = new ArrayList<String>(entries.length);
            Matcher mUnescape = Pattern.compile("^(?=\\S)[^\"\n,]+(?<=\\S)$").matcher(Strings.EMPTY);
            Matcher mQuote = Pattern.compile("\"").matcher(Strings.EMPTY);
            CharSequence[] charSequenceArray = entries;
            int n = entries.length;
            int n2 = 0;
            while (n2 < n) {
                CharSequence entry = charSequenceArray[n2];
                mUnescape.reset(entry);
                if (mUnescape.matches()) {
                    entryList.add(entry.toString());
                } else {
                    entryList.add("\"" + mQuote.reset(entry).replaceAll("\"\"") + "\"");
                }
                ++n2;
            }
            return Strings.join(Strings.Delimiter.COMMA, (CharSequence[])entryList.toArray(new String[entryList.size()]));
        }
    }
}

