/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.filter;

import java.lang.annotation.Annotation;
import jp.coppermine.voyager.beans.collection.ReadableProperty;
import jp.coppermine.voyager.beans.collection.WritableProperty;
import jp.coppermine.voyager.beans.filter.InputFilter;
import jp.coppermine.voyager.beans.filter.OutputFilter;
import jp.coppermine.voyager.xlsmaker.annotations.Cell;
import jp.coppermine.voyager.xlsmaker.annotations.Replace;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.coord.ColumnProvider;
import jp.coppermine.voyager.xlsmaker.coord.ColumnUnit;
import jp.coppermine.voyager.xlsmaker.coord.RowProvider;
import jp.coppermine.voyager.xlsmaker.coord.RowUnit;
import jp.coppermine.voyager.xlsmaker.model.XCell;
import jp.coppermine.voyager.xlsmaker.model.XSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellFilter
implements OutputFilter,
InputFilter {
    private XSheet xSheet;
    private RowUnit rowOffset;
    private ColumnUnit columnOffset;

    public CellFilter(XSheet xSheet, RowProvider rowOffset, ColumnProvider columnOffset) {
        this.xSheet = xSheet;
        this.rowOffset = RowUnit.from(rowOffset);
        this.columnOffset = ColumnUnit.from(columnOffset);
    }

    public Class<? extends Annotation> getAnnotation() {
        return Cell.class;
    }

    public Object setValue(WritableProperty property, Object value) {
        return value;
    }

    public Object getValue(ReadableProperty property, Object value) {
        Cell annotation = (Cell)property.getReadAnnotation(Cell.class);
        CellUnit cellUnit = annotation.value().length() == 0 ? CellUnit.at(annotation.row(), annotation.column()) : CellUnit.of(annotation.value());
        XCell xCell = this.xSheet.getCell(cellUnit.shift(this.rowOffset, this.columnOffset));
        if (property.isReadAnnotationPresent(Replace.class)) {
            Replace replace = (Replace)property.getReadAnnotation(Replace.class);
            String s = xCell.getStringValue();
            String replacement = replace.replacement().replace("{value}", value.toString());
            xCell.setValue(s.replaceFirst(replace.pattern(), replacement));
            return value;
        }
        xCell.setValue(value);
        return value;
    }
}

