/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.filter;

import java.lang.annotation.Annotation;
import jp.coppermine.voyager.beans.filter.ConstructionFilter;
import jp.coppermine.voyager.xlsmaker.annotations.Grid;
import jp.coppermine.voyager.xlsmaker.annotations.Row;
import jp.coppermine.voyager.xlsmaker.coord.ColumnUnit;
import jp.coppermine.voyager.xlsmaker.coord.RowUnit;
import jp.coppermine.voyager.xlsmaker.model.XSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridFilter
implements ConstructionFilter {
    private RowUnit rowOffset;
    private ColumnUnit columnOffset;
    private XSheet xSheet;

    public GridFilter(XSheet xSheet, RowUnit rowOffset, ColumnUnit columnOffset) {
        this.xSheet = xSheet;
        this.rowOffset = rowOffset;
        this.columnOffset = columnOffset;
    }

    public Class<? extends Annotation> getAnnotation() {
        return Grid.class;
    }

    public void execute(Class<?> type, Object obj) {
        Grid grid = type.getAnnotation(Grid.class);
        if (grid != null) {
            int index;
            int n;
            int n2;
            Object[] objectArray;
            Annotation[] annotationArray = grid.rows();
            int n3 = annotationArray.length;
            int n4 = 0;
            while (n4 < n3) {
                Row rows = annotationArray[n4];
                objectArray = rows.index();
                n2 = objectArray.length;
                n = 0;
                while (n < n2) {
                    index = objectArray[n];
                    RowUnit rowUnit = RowUnit.at(index).shift(this.rowOffset);
                    this.xSheet.setRowHeight(rowUnit, rows.height());
                    ++n;
                }
                ++n4;
            }
            annotationArray = grid.columns();
            n3 = annotationArray.length;
            n4 = 0;
            while (n4 < n3) {
                ColumnUnit columnUnit;
                Annotation columns = annotationArray[n4];
                if (columns.address().length == 0) {
                    objectArray = columns.index();
                    n2 = objectArray.length;
                    n = 0;
                    while (n < n2) {
                        index = objectArray[n];
                        columnUnit = ColumnUnit.at(index).shift(this.columnOffset);
                        this.xSheet.setColumnWidth(columnUnit, columns.width());
                        ++n;
                    }
                } else {
                    String[] stringArray = columns.address();
                    objectArray = stringArray;
                    n2 = stringArray.length;
                    n = 0;
                    while (n < n2) {
                        int address = objectArray[n];
                        columnUnit = ColumnUnit.of((String)address).shift(this.columnOffset);
                        this.xSheet.setColumnWidth(columnUnit, columns.width());
                        ++n;
                    }
                }
                ++n4;
            }
        }
    }
}

