/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.filter;

import java.lang.annotation.Annotation;
import jp.coppermine.voyager.beans.filter.ConstructionFilter;
import jp.coppermine.voyager.xlsmaker.annotations.Range;
import jp.coppermine.voyager.xlsmaker.annotations.Ranges;
import jp.coppermine.voyager.xlsmaker.annotations.Style;
import jp.coppermine.voyager.xlsmaker.annotations.style.Font;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.coord.ColumnUnit;
import jp.coppermine.voyager.xlsmaker.coord.RangeUnit;
import jp.coppermine.voyager.xlsmaker.coord.RowUnit;
import jp.coppermine.voyager.xlsmaker.model.XFont;
import jp.coppermine.voyager.xlsmaker.model.XRange;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangesFilter
implements ConstructionFilter {
    private XSheet xSheet;
    private RowUnit rowOffset;
    private ColumnUnit columnOffset;

    public RangesFilter(XSheet xSheet, RowUnit rowOffset, ColumnUnit columnOffset) {
        this.xSheet = xSheet;
        this.rowOffset = rowOffset;
        this.columnOffset = columnOffset;
    }

    public Class<? extends Annotation> getAnnotation() {
        return Ranges.class;
    }

    public void execute(Class<?> type, Object obj) {
        Ranges ranges = type.getAnnotation(Ranges.class);
        if (ranges != null) {
            Range[] rangeArray = ranges.value();
            int n = rangeArray.length;
            int n2 = 0;
            while (n2 < n) {
                Range range = rangeArray[n2];
                CellUnit firstCellUnit = range.first().value().length() == 0 ? CellUnit.at(range.first().row(), range.first().column()) : CellUnit.of(range.first().value());
                CellUnit lastCellunit = range.last().value().length() == 0 ? CellUnit.at(range.last().row(), range.last().column()) : CellUnit.of(range.last().value());
                XRange xRange = this.xSheet.getRange(RangeUnit.from(firstCellUnit, lastCellunit).shift(this.rowOffset, this.columnOffset));
                xRange.setMerged(range.merge());
                Style style = range.style();
                Font font = style.font();
                XFont xFont = XFont.builder().name(font.name()).size(font.size()).color(font.color()).boldweight(font.weight()).italic(font.italic()).strikeout(font.strikeout()).typeOffset(font.typeOffset()).underline(font.underline()).build();
                XStyle xStyle = XStyle.builder().dataFormat(style.format().index()).dataFormat(style.format().value()).alignment(style.layout().horizontal()).verticalAlignment(style.layout().vertical()).wrapText(style.layout().wrapText()).font(xFont).borderTop(style.border().top(), style.border().topColor()).borderBottom(style.border().bottom(), style.border().bottomColor()).borderLeft(style.border().left(), style.border().leftColor()).borderRight(style.border().right(), style.border().rightColor()).foreground(style.pattern().foregroundColor()).background(style.pattern().backgroundColor()).pattern(style.pattern().fillPattern()).build();
                xRange.setStyle(xStyle);
                ++n2;
            }
        }
    }
}

