/*
 * Decompiled with CFR 0.152.
 */
package jp.coppermine.voyager.xlsmaker.filter;

import java.lang.annotation.Annotation;
import jp.coppermine.voyager.beans.collection.ReadableProperty;
import jp.coppermine.voyager.beans.collection.WritableProperty;
import jp.coppermine.voyager.beans.filter.InputFilter;
import jp.coppermine.voyager.beans.filter.OutputFilter;
import jp.coppermine.voyager.xlsmaker.annotations.Cell;
import jp.coppermine.voyager.xlsmaker.annotations.Range;
import jp.coppermine.voyager.xlsmaker.annotations.Style;
import jp.coppermine.voyager.xlsmaker.annotations.style.Font;
import jp.coppermine.voyager.xlsmaker.coord.CellUnit;
import jp.coppermine.voyager.xlsmaker.coord.ColumnProvider;
import jp.coppermine.voyager.xlsmaker.coord.ColumnUnit;
import jp.coppermine.voyager.xlsmaker.coord.RangeUnit;
import jp.coppermine.voyager.xlsmaker.coord.RowProvider;
import jp.coppermine.voyager.xlsmaker.coord.RowUnit;
import jp.coppermine.voyager.xlsmaker.model.XCell;
import jp.coppermine.voyager.xlsmaker.model.XFont;
import jp.coppermine.voyager.xlsmaker.model.XRange;
import jp.coppermine.voyager.xlsmaker.model.XSheet;
import jp.coppermine.voyager.xlsmaker.model.XStyle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleFilter
implements OutputFilter,
InputFilter {
    private XSheet xSheet;
    private RowUnit rowOffset;
    private ColumnUnit columnOffset;

    public StyleFilter(XSheet wSheet, RowProvider rowOffset, ColumnProvider columnOffset) {
        this.xSheet = wSheet;
        this.rowOffset = RowUnit.from(rowOffset);
        this.columnOffset = ColumnUnit.from(columnOffset);
    }

    public Class<? extends Annotation> getAnnotation() {
        return Style.class;
    }

    public Object setValue(WritableProperty property, Object value) {
        return value;
    }

    public Object getValue(ReadableProperty property, Object value) {
        Style style = (Style)property.getReadAnnotation(Style.class);
        Font font = style.font();
        XFont xFont = XFont.builder().name(font.name()).size(font.size()).color(font.color()).boldweight(font.weight()).italic(font.italic()).strikeout(font.strikeout()).typeOffset(font.typeOffset()).underline(font.underline()).build();
        XStyle xStyle = XStyle.builder().dataFormat(style.format().index()).dataFormat(style.format().value()).alignment(style.layout().horizontal()).verticalAlignment(style.layout().vertical()).wrapText(style.layout().wrapText()).font(xFont).borderTop(style.border().top(), style.border().topColor()).borderBottom(style.border().bottom(), style.border().bottomColor()).borderLeft(style.border().left(), style.border().leftColor()).borderRight(style.border().right(), style.border().rightColor()).foreground(style.pattern().foregroundColor()).background(style.pattern().backgroundColor()).pattern(style.pattern().fillPattern()).build();
        Range range = (Range)property.getReadAnnotation(Range.class);
        if (range != null) {
            CellUnit firstCellUnit = range.first().value().length() == 0 ? CellUnit.at(range.first().row(), range.first().column()) : CellUnit.of(range.first().value());
            CellUnit lastCellUnit = range.last().value().length() == 0 ? CellUnit.at(range.last().row(), range.last().column()) : CellUnit.of(range.last().value());
            XRange xRange = this.xSheet.getRange(RangeUnit.from(firstCellUnit, lastCellUnit).shift(this.rowOffset, this.columnOffset));
            xRange.setMerged(range.merge());
            xRange.setStyle(xStyle);
            return value;
        }
        Cell cell = (Cell)property.getReadAnnotation(Cell.class);
        if (cell != null) {
            CellUnit cellUnit = cell.value().length() == 0 ? CellUnit.at(cell.row(), cell.column()) : CellUnit.of(cell.value());
            XCell xCell = this.xSheet.getCell(cellUnit.shift(this.rowOffset, this.columnOffset));
            xCell.setStyle(xStyle);
            return value;
        }
        return value;
    }
}

