#!/usr/bin/perl

use strict;


my $lines="";
my $path='/etc/openvpn/server.conf';


open(FH,"<$path");
read(FH,$lines,-s $path);
close(FH);

my @line=split(/\n/,$lines);
$lines="";
my $flag=0;
foreach(@line){

	if(/^\;tls-auth ta\.key 0/){
		$lines.=qq{tls-auth ta.key 0 # This file is secret\n};
	}elsif(/^port 1194/){
		$lines.=qq{port 443\n};
	}elsif(/^\;proto tcp/){
		$lines.=qq{proto tcp\n};
	}elsif(/^proto udp/){
		$lines.=qq{;proto udp\n};
	}elsif(/^\;user nobody/){
		$lines.=qq{user nobody\n};
	}elsif(/^\;group nobody/){
		$lines.=qq{group nobody\n};
	}elsif(/^\;log-append/){
		$lines.=qq{log-append /var/log/openvpn.log\n};
	}elsif(/^\;client-to-client/){
		$lines.=qq{client-to-client\n};
	}else{
		$lines.="$_\n";
	}
}

if($lines =~ /management localhost 7505/){

}else{
	$lines.=qq{management localhost 7505\n};
	$lines.=qq{crl-verify crl.pem\n};
	$lines.=qq{tun-mtu 1438\n};
	$lines.=qq{mssfix 1398\n};
	$lines.=qq{#fragment 1410\n};
}


open(FH,">$path");
print FH $lines;
close(FH);
		
print "Complete!\n";

exit();





