/*
    Copyright 2016-2018 SOFT-ERG, Przemek Kuczmierczyk (www.softerg.com)
    All rights reserved.

    Redistribution and use in source and binary forms, with or without modification,
    are permitted provided that the following conditions are met:

    1. Redistributions of source code must retain the above copyright notice,
       this list of conditions and the following disclaimer.

    2. Redistributions in binary form must reproduce the above copyright notice,
       this list of conditions and the following disclaimer in the documentation
       and/or other materials provided with the distribution.

    THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
    AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
    THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
    ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
    FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
    (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
    LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
    ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
    NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
    EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

// -----------------------------------------------------------------------------

#include "ph.hpp"
#include "../include/vppFormats.hpp"

// -----------------------------------------------------------------------------
namespace vpp {
// -----------------------------------------------------------------------------

const std::uint32_t float16_t :: s_mantissaTable [ 2048 ] =
{
    0x0u, 0x33800000u, 0x34000000u, 0x34400000u, 0x34800000u, 0x34a00000u, 0x34c00000u, 0x34e00000u, 
    0x35000000u, 0x35100000u, 0x35200000u, 0x35300000u, 0x35400000u, 0x35500000u, 0x35600000u, 0x35700000u, 
    0x35800000u, 0x35880000u, 0x35900000u, 0x35980000u, 0x35a00000u, 0x35a80000u, 0x35b00000u, 0x35b80000u, 
    0x35c00000u, 0x35c80000u, 0x35d00000u, 0x35d80000u, 0x35e00000u, 0x35e80000u, 0x35f00000u, 0x35f80000u, 
    0x36000000u, 0x36040000u, 0x36080000u, 0x360c0000u, 0x36100000u, 0x36140000u, 0x36180000u, 0x361c0000u, 
    0x36200000u, 0x36240000u, 0x36280000u, 0x362c0000u, 0x36300000u, 0x36340000u, 0x36380000u, 0x363c0000u, 
    0x36400000u, 0x36440000u, 0x36480000u, 0x364c0000u, 0x36500000u, 0x36540000u, 0x36580000u, 0x365c0000u, 
    0x36600000u, 0x36640000u, 0x36680000u, 0x366c0000u, 0x36700000u, 0x36740000u, 0x36780000u, 0x367c0000u, 
    0x36800000u, 0x36820000u, 0x36840000u, 0x36860000u, 0x36880000u, 0x368a0000u, 0x368c0000u, 0x368e0000u, 
    0x36900000u, 0x36920000u, 0x36940000u, 0x36960000u, 0x36980000u, 0x369a0000u, 0x369c0000u, 0x369e0000u, 
    0x36a00000u, 0x36a20000u, 0x36a40000u, 0x36a60000u, 0x36a80000u, 0x36aa0000u, 0x36ac0000u, 0x36ae0000u, 
    0x36b00000u, 0x36b20000u, 0x36b40000u, 0x36b60000u, 0x36b80000u, 0x36ba0000u, 0x36bc0000u, 0x36be0000u, 
    0x36c00000u, 0x36c20000u, 0x36c40000u, 0x36c60000u, 0x36c80000u, 0x36ca0000u, 0x36cc0000u, 0x36ce0000u, 
    0x36d00000u, 0x36d20000u, 0x36d40000u, 0x36d60000u, 0x36d80000u, 0x36da0000u, 0x36dc0000u, 0x36de0000u, 
    0x36e00000u, 0x36e20000u, 0x36e40000u, 0x36e60000u, 0x36e80000u, 0x36ea0000u, 0x36ec0000u, 0x36ee0000u, 
    0x36f00000u, 0x36f20000u, 0x36f40000u, 0x36f60000u, 0x36f80000u, 0x36fa0000u, 0x36fc0000u, 0x36fe0000u, 
    0x37000000u, 0x37010000u, 0x37020000u, 0x37030000u, 0x37040000u, 0x37050000u, 0x37060000u, 0x37070000u, 
    0x37080000u, 0x37090000u, 0x370a0000u, 0x370b0000u, 0x370c0000u, 0x370d0000u, 0x370e0000u, 0x370f0000u, 
    0x37100000u, 0x37110000u, 0x37120000u, 0x37130000u, 0x37140000u, 0x37150000u, 0x37160000u, 0x37170000u, 
    0x37180000u, 0x37190000u, 0x371a0000u, 0x371b0000u, 0x371c0000u, 0x371d0000u, 0x371e0000u, 0x371f0000u, 
    0x37200000u, 0x37210000u, 0x37220000u, 0x37230000u, 0x37240000u, 0x37250000u, 0x37260000u, 0x37270000u, 
    0x37280000u, 0x37290000u, 0x372a0000u, 0x372b0000u, 0x372c0000u, 0x372d0000u, 0x372e0000u, 0x372f0000u, 
    0x37300000u, 0x37310000u, 0x37320000u, 0x37330000u, 0x37340000u, 0x37350000u, 0x37360000u, 0x37370000u, 
    0x37380000u, 0x37390000u, 0x373a0000u, 0x373b0000u, 0x373c0000u, 0x373d0000u, 0x373e0000u, 0x373f0000u, 
    0x37400000u, 0x37410000u, 0x37420000u, 0x37430000u, 0x37440000u, 0x37450000u, 0x37460000u, 0x37470000u, 
    0x37480000u, 0x37490000u, 0x374a0000u, 0x374b0000u, 0x374c0000u, 0x374d0000u, 0x374e0000u, 0x374f0000u, 
    0x37500000u, 0x37510000u, 0x37520000u, 0x37530000u, 0x37540000u, 0x37550000u, 0x37560000u, 0x37570000u, 
    0x37580000u, 0x37590000u, 0x375a0000u, 0x375b0000u, 0x375c0000u, 0x375d0000u, 0x375e0000u, 0x375f0000u, 
    0x37600000u, 0x37610000u, 0x37620000u, 0x37630000u, 0x37640000u, 0x37650000u, 0x37660000u, 0x37670000u, 
    0x37680000u, 0x37690000u, 0x376a0000u, 0x376b0000u, 0x376c0000u, 0x376d0000u, 0x376e0000u, 0x376f0000u, 
    0x37700000u, 0x37710000u, 0x37720000u, 0x37730000u, 0x37740000u, 0x37750000u, 0x37760000u, 0x37770000u, 
    0x37780000u, 0x37790000u, 0x377a0000u, 0x377b0000u, 0x377c0000u, 0x377d0000u, 0x377e0000u, 0x377f0000u, 
    0x37800000u, 0x37808000u, 0x37810000u, 0x37818000u, 0x37820000u, 0x37828000u, 0x37830000u, 0x37838000u, 
    0x37840000u, 0x37848000u, 0x37850000u, 0x37858000u, 0x37860000u, 0x37868000u, 0x37870000u, 0x37878000u, 
    0x37880000u, 0x37888000u, 0x37890000u, 0x37898000u, 0x378a0000u, 0x378a8000u, 0x378b0000u, 0x378b8000u, 
    0x378c0000u, 0x378c8000u, 0x378d0000u, 0x378d8000u, 0x378e0000u, 0x378e8000u, 0x378f0000u, 0x378f8000u, 
    0x37900000u, 0x37908000u, 0x37910000u, 0x37918000u, 0x37920000u, 0x37928000u, 0x37930000u, 0x37938000u, 
    0x37940000u, 0x37948000u, 0x37950000u, 0x37958000u, 0x37960000u, 0x37968000u, 0x37970000u, 0x37978000u, 
    0x37980000u, 0x37988000u, 0x37990000u, 0x37998000u, 0x379a0000u, 0x379a8000u, 0x379b0000u, 0x379b8000u, 
    0x379c0000u, 0x379c8000u, 0x379d0000u, 0x379d8000u, 0x379e0000u, 0x379e8000u, 0x379f0000u, 0x379f8000u, 
    0x37a00000u, 0x37a08000u, 0x37a10000u, 0x37a18000u, 0x37a20000u, 0x37a28000u, 0x37a30000u, 0x37a38000u, 
    0x37a40000u, 0x37a48000u, 0x37a50000u, 0x37a58000u, 0x37a60000u, 0x37a68000u, 0x37a70000u, 0x37a78000u, 
    0x37a80000u, 0x37a88000u, 0x37a90000u, 0x37a98000u, 0x37aa0000u, 0x37aa8000u, 0x37ab0000u, 0x37ab8000u, 
    0x37ac0000u, 0x37ac8000u, 0x37ad0000u, 0x37ad8000u, 0x37ae0000u, 0x37ae8000u, 0x37af0000u, 0x37af8000u, 
    0x37b00000u, 0x37b08000u, 0x37b10000u, 0x37b18000u, 0x37b20000u, 0x37b28000u, 0x37b30000u, 0x37b38000u, 
    0x37b40000u, 0x37b48000u, 0x37b50000u, 0x37b58000u, 0x37b60000u, 0x37b68000u, 0x37b70000u, 0x37b78000u, 
    0x37b80000u, 0x37b88000u, 0x37b90000u, 0x37b98000u, 0x37ba0000u, 0x37ba8000u, 0x37bb0000u, 0x37bb8000u, 
    0x37bc0000u, 0x37bc8000u, 0x37bd0000u, 0x37bd8000u, 0x37be0000u, 0x37be8000u, 0x37bf0000u, 0x37bf8000u, 
    0x37c00000u, 0x37c08000u, 0x37c10000u, 0x37c18000u, 0x37c20000u, 0x37c28000u, 0x37c30000u, 0x37c38000u, 
    0x37c40000u, 0x37c48000u, 0x37c50000u, 0x37c58000u, 0x37c60000u, 0x37c68000u, 0x37c70000u, 0x37c78000u, 
    0x37c80000u, 0x37c88000u, 0x37c90000u, 0x37c98000u, 0x37ca0000u, 0x37ca8000u, 0x37cb0000u, 0x37cb8000u, 
    0x37cc0000u, 0x37cc8000u, 0x37cd0000u, 0x37cd8000u, 0x37ce0000u, 0x37ce8000u, 0x37cf0000u, 0x37cf8000u, 
    0x37d00000u, 0x37d08000u, 0x37d10000u, 0x37d18000u, 0x37d20000u, 0x37d28000u, 0x37d30000u, 0x37d38000u, 
    0x37d40000u, 0x37d48000u, 0x37d50000u, 0x37d58000u, 0x37d60000u, 0x37d68000u, 0x37d70000u, 0x37d78000u, 
    0x37d80000u, 0x37d88000u, 0x37d90000u, 0x37d98000u, 0x37da0000u, 0x37da8000u, 0x37db0000u, 0x37db8000u, 
    0x37dc0000u, 0x37dc8000u, 0x37dd0000u, 0x37dd8000u, 0x37de0000u, 0x37de8000u, 0x37df0000u, 0x37df8000u, 
    0x37e00000u, 0x37e08000u, 0x37e10000u, 0x37e18000u, 0x37e20000u, 0x37e28000u, 0x37e30000u, 0x37e38000u, 
    0x37e40000u, 0x37e48000u, 0x37e50000u, 0x37e58000u, 0x37e60000u, 0x37e68000u, 0x37e70000u, 0x37e78000u, 
    0x37e80000u, 0x37e88000u, 0x37e90000u, 0x37e98000u, 0x37ea0000u, 0x37ea8000u, 0x37eb0000u, 0x37eb8000u, 
    0x37ec0000u, 0x37ec8000u, 0x37ed0000u, 0x37ed8000u, 0x37ee0000u, 0x37ee8000u, 0x37ef0000u, 0x37ef8000u, 
    0x37f00000u, 0x37f08000u, 0x37f10000u, 0x37f18000u, 0x37f20000u, 0x37f28000u, 0x37f30000u, 0x37f38000u, 
    0x37f40000u, 0x37f48000u, 0x37f50000u, 0x37f58000u, 0x37f60000u, 0x37f68000u, 0x37f70000u, 0x37f78000u, 
    0x37f80000u, 0x37f88000u, 0x37f90000u, 0x37f98000u, 0x37fa0000u, 0x37fa8000u, 0x37fb0000u, 0x37fb8000u, 
    0x37fc0000u, 0x37fc8000u, 0x37fd0000u, 0x37fd8000u, 0x37fe0000u, 0x37fe8000u, 0x37ff0000u, 0x37ff8000u, 
    0x38000000u, 0x38004000u, 0x38008000u, 0x3800c000u, 0x38010000u, 0x38014000u, 0x38018000u, 0x3801c000u, 
    0x38020000u, 0x38024000u, 0x38028000u, 0x3802c000u, 0x38030000u, 0x38034000u, 0x38038000u, 0x3803c000u, 
    0x38040000u, 0x38044000u, 0x38048000u, 0x3804c000u, 0x38050000u, 0x38054000u, 0x38058000u, 0x3805c000u, 
    0x38060000u, 0x38064000u, 0x38068000u, 0x3806c000u, 0x38070000u, 0x38074000u, 0x38078000u, 0x3807c000u, 
    0x38080000u, 0x38084000u, 0x38088000u, 0x3808c000u, 0x38090000u, 0x38094000u, 0x38098000u, 0x3809c000u, 
    0x380a0000u, 0x380a4000u, 0x380a8000u, 0x380ac000u, 0x380b0000u, 0x380b4000u, 0x380b8000u, 0x380bc000u, 
    0x380c0000u, 0x380c4000u, 0x380c8000u, 0x380cc000u, 0x380d0000u, 0x380d4000u, 0x380d8000u, 0x380dc000u, 
    0x380e0000u, 0x380e4000u, 0x380e8000u, 0x380ec000u, 0x380f0000u, 0x380f4000u, 0x380f8000u, 0x380fc000u, 
    0x38100000u, 0x38104000u, 0x38108000u, 0x3810c000u, 0x38110000u, 0x38114000u, 0x38118000u, 0x3811c000u, 
    0x38120000u, 0x38124000u, 0x38128000u, 0x3812c000u, 0x38130000u, 0x38134000u, 0x38138000u, 0x3813c000u, 
    0x38140000u, 0x38144000u, 0x38148000u, 0x3814c000u, 0x38150000u, 0x38154000u, 0x38158000u, 0x3815c000u, 
    0x38160000u, 0x38164000u, 0x38168000u, 0x3816c000u, 0x38170000u, 0x38174000u, 0x38178000u, 0x3817c000u, 
    0x38180000u, 0x38184000u, 0x38188000u, 0x3818c000u, 0x38190000u, 0x38194000u, 0x38198000u, 0x3819c000u, 
    0x381a0000u, 0x381a4000u, 0x381a8000u, 0x381ac000u, 0x381b0000u, 0x381b4000u, 0x381b8000u, 0x381bc000u, 
    0x381c0000u, 0x381c4000u, 0x381c8000u, 0x381cc000u, 0x381d0000u, 0x381d4000u, 0x381d8000u, 0x381dc000u, 
    0x381e0000u, 0x381e4000u, 0x381e8000u, 0x381ec000u, 0x381f0000u, 0x381f4000u, 0x381f8000u, 0x381fc000u, 
    0x38200000u, 0x38204000u, 0x38208000u, 0x3820c000u, 0x38210000u, 0x38214000u, 0x38218000u, 0x3821c000u, 
    0x38220000u, 0x38224000u, 0x38228000u, 0x3822c000u, 0x38230000u, 0x38234000u, 0x38238000u, 0x3823c000u, 
    0x38240000u, 0x38244000u, 0x38248000u, 0x3824c000u, 0x38250000u, 0x38254000u, 0x38258000u, 0x3825c000u, 
    0x38260000u, 0x38264000u, 0x38268000u, 0x3826c000u, 0x38270000u, 0x38274000u, 0x38278000u, 0x3827c000u, 
    0x38280000u, 0x38284000u, 0x38288000u, 0x3828c000u, 0x38290000u, 0x38294000u, 0x38298000u, 0x3829c000u, 
    0x382a0000u, 0x382a4000u, 0x382a8000u, 0x382ac000u, 0x382b0000u, 0x382b4000u, 0x382b8000u, 0x382bc000u, 
    0x382c0000u, 0x382c4000u, 0x382c8000u, 0x382cc000u, 0x382d0000u, 0x382d4000u, 0x382d8000u, 0x382dc000u, 
    0x382e0000u, 0x382e4000u, 0x382e8000u, 0x382ec000u, 0x382f0000u, 0x382f4000u, 0x382f8000u, 0x382fc000u, 
    0x38300000u, 0x38304000u, 0x38308000u, 0x3830c000u, 0x38310000u, 0x38314000u, 0x38318000u, 0x3831c000u, 
    0x38320000u, 0x38324000u, 0x38328000u, 0x3832c000u, 0x38330000u, 0x38334000u, 0x38338000u, 0x3833c000u, 
    0x38340000u, 0x38344000u, 0x38348000u, 0x3834c000u, 0x38350000u, 0x38354000u, 0x38358000u, 0x3835c000u, 
    0x38360000u, 0x38364000u, 0x38368000u, 0x3836c000u, 0x38370000u, 0x38374000u, 0x38378000u, 0x3837c000u, 
    0x38380000u, 0x38384000u, 0x38388000u, 0x3838c000u, 0x38390000u, 0x38394000u, 0x38398000u, 0x3839c000u, 
    0x383a0000u, 0x383a4000u, 0x383a8000u, 0x383ac000u, 0x383b0000u, 0x383b4000u, 0x383b8000u, 0x383bc000u, 
    0x383c0000u, 0x383c4000u, 0x383c8000u, 0x383cc000u, 0x383d0000u, 0x383d4000u, 0x383d8000u, 0x383dc000u, 
    0x383e0000u, 0x383e4000u, 0x383e8000u, 0x383ec000u, 0x383f0000u, 0x383f4000u, 0x383f8000u, 0x383fc000u, 
    0x38400000u, 0x38404000u, 0x38408000u, 0x3840c000u, 0x38410000u, 0x38414000u, 0x38418000u, 0x3841c000u, 
    0x38420000u, 0x38424000u, 0x38428000u, 0x3842c000u, 0x38430000u, 0x38434000u, 0x38438000u, 0x3843c000u, 
    0x38440000u, 0x38444000u, 0x38448000u, 0x3844c000u, 0x38450000u, 0x38454000u, 0x38458000u, 0x3845c000u, 
    0x38460000u, 0x38464000u, 0x38468000u, 0x3846c000u, 0x38470000u, 0x38474000u, 0x38478000u, 0x3847c000u, 
    0x38480000u, 0x38484000u, 0x38488000u, 0x3848c000u, 0x38490000u, 0x38494000u, 0x38498000u, 0x3849c000u, 
    0x384a0000u, 0x384a4000u, 0x384a8000u, 0x384ac000u, 0x384b0000u, 0x384b4000u, 0x384b8000u, 0x384bc000u, 
    0x384c0000u, 0x384c4000u, 0x384c8000u, 0x384cc000u, 0x384d0000u, 0x384d4000u, 0x384d8000u, 0x384dc000u, 
    0x384e0000u, 0x384e4000u, 0x384e8000u, 0x384ec000u, 0x384f0000u, 0x384f4000u, 0x384f8000u, 0x384fc000u, 
    0x38500000u, 0x38504000u, 0x38508000u, 0x3850c000u, 0x38510000u, 0x38514000u, 0x38518000u, 0x3851c000u, 
    0x38520000u, 0x38524000u, 0x38528000u, 0x3852c000u, 0x38530000u, 0x38534000u, 0x38538000u, 0x3853c000u, 
    0x38540000u, 0x38544000u, 0x38548000u, 0x3854c000u, 0x38550000u, 0x38554000u, 0x38558000u, 0x3855c000u, 
    0x38560000u, 0x38564000u, 0x38568000u, 0x3856c000u, 0x38570000u, 0x38574000u, 0x38578000u, 0x3857c000u, 
    0x38580000u, 0x38584000u, 0x38588000u, 0x3858c000u, 0x38590000u, 0x38594000u, 0x38598000u, 0x3859c000u, 
    0x385a0000u, 0x385a4000u, 0x385a8000u, 0x385ac000u, 0x385b0000u, 0x385b4000u, 0x385b8000u, 0x385bc000u, 
    0x385c0000u, 0x385c4000u, 0x385c8000u, 0x385cc000u, 0x385d0000u, 0x385d4000u, 0x385d8000u, 0x385dc000u, 
    0x385e0000u, 0x385e4000u, 0x385e8000u, 0x385ec000u, 0x385f0000u, 0x385f4000u, 0x385f8000u, 0x385fc000u, 
    0x38600000u, 0x38604000u, 0x38608000u, 0x3860c000u, 0x38610000u, 0x38614000u, 0x38618000u, 0x3861c000u, 
    0x38620000u, 0x38624000u, 0x38628000u, 0x3862c000u, 0x38630000u, 0x38634000u, 0x38638000u, 0x3863c000u, 
    0x38640000u, 0x38644000u, 0x38648000u, 0x3864c000u, 0x38650000u, 0x38654000u, 0x38658000u, 0x3865c000u, 
    0x38660000u, 0x38664000u, 0x38668000u, 0x3866c000u, 0x38670000u, 0x38674000u, 0x38678000u, 0x3867c000u, 
    0x38680000u, 0x38684000u, 0x38688000u, 0x3868c000u, 0x38690000u, 0x38694000u, 0x38698000u, 0x3869c000u, 
    0x386a0000u, 0x386a4000u, 0x386a8000u, 0x386ac000u, 0x386b0000u, 0x386b4000u, 0x386b8000u, 0x386bc000u, 
    0x386c0000u, 0x386c4000u, 0x386c8000u, 0x386cc000u, 0x386d0000u, 0x386d4000u, 0x386d8000u, 0x386dc000u, 
    0x386e0000u, 0x386e4000u, 0x386e8000u, 0x386ec000u, 0x386f0000u, 0x386f4000u, 0x386f8000u, 0x386fc000u, 
    0x38700000u, 0x38704000u, 0x38708000u, 0x3870c000u, 0x38710000u, 0x38714000u, 0x38718000u, 0x3871c000u, 
    0x38720000u, 0x38724000u, 0x38728000u, 0x3872c000u, 0x38730000u, 0x38734000u, 0x38738000u, 0x3873c000u, 
    0x38740000u, 0x38744000u, 0x38748000u, 0x3874c000u, 0x38750000u, 0x38754000u, 0x38758000u, 0x3875c000u, 
    0x38760000u, 0x38764000u, 0x38768000u, 0x3876c000u, 0x38770000u, 0x38774000u, 0x38778000u, 0x3877c000u, 
    0x38780000u, 0x38784000u, 0x38788000u, 0x3878c000u, 0x38790000u, 0x38794000u, 0x38798000u, 0x3879c000u, 
    0x387a0000u, 0x387a4000u, 0x387a8000u, 0x387ac000u, 0x387b0000u, 0x387b4000u, 0x387b8000u, 0x387bc000u, 
    0x387c0000u, 0x387c4000u, 0x387c8000u, 0x387cc000u, 0x387d0000u, 0x387d4000u, 0x387d8000u, 0x387dc000u, 
    0x387e0000u, 0x387e4000u, 0x387e8000u, 0x387ec000u, 0x387f0000u, 0x387f4000u, 0x387f8000u, 0x387fc000u, 
    0x38000000u, 0x38002000u, 0x38004000u, 0x38006000u, 0x38008000u, 0x3800a000u, 0x3800c000u, 0x3800e000u, 
    0x38010000u, 0x38012000u, 0x38014000u, 0x38016000u, 0x38018000u, 0x3801a000u, 0x3801c000u, 0x3801e000u, 
    0x38020000u, 0x38022000u, 0x38024000u, 0x38026000u, 0x38028000u, 0x3802a000u, 0x3802c000u, 0x3802e000u, 
    0x38030000u, 0x38032000u, 0x38034000u, 0x38036000u, 0x38038000u, 0x3803a000u, 0x3803c000u, 0x3803e000u, 
    0x38040000u, 0x38042000u, 0x38044000u, 0x38046000u, 0x38048000u, 0x3804a000u, 0x3804c000u, 0x3804e000u, 
    0x38050000u, 0x38052000u, 0x38054000u, 0x38056000u, 0x38058000u, 0x3805a000u, 0x3805c000u, 0x3805e000u, 
    0x38060000u, 0x38062000u, 0x38064000u, 0x38066000u, 0x38068000u, 0x3806a000u, 0x3806c000u, 0x3806e000u, 
    0x38070000u, 0x38072000u, 0x38074000u, 0x38076000u, 0x38078000u, 0x3807a000u, 0x3807c000u, 0x3807e000u, 
    0x38080000u, 0x38082000u, 0x38084000u, 0x38086000u, 0x38088000u, 0x3808a000u, 0x3808c000u, 0x3808e000u, 
    0x38090000u, 0x38092000u, 0x38094000u, 0x38096000u, 0x38098000u, 0x3809a000u, 0x3809c000u, 0x3809e000u, 
    0x380a0000u, 0x380a2000u, 0x380a4000u, 0x380a6000u, 0x380a8000u, 0x380aa000u, 0x380ac000u, 0x380ae000u, 
    0x380b0000u, 0x380b2000u, 0x380b4000u, 0x380b6000u, 0x380b8000u, 0x380ba000u, 0x380bc000u, 0x380be000u, 
    0x380c0000u, 0x380c2000u, 0x380c4000u, 0x380c6000u, 0x380c8000u, 0x380ca000u, 0x380cc000u, 0x380ce000u, 
    0x380d0000u, 0x380d2000u, 0x380d4000u, 0x380d6000u, 0x380d8000u, 0x380da000u, 0x380dc000u, 0x380de000u, 
    0x380e0000u, 0x380e2000u, 0x380e4000u, 0x380e6000u, 0x380e8000u, 0x380ea000u, 0x380ec000u, 0x380ee000u, 
    0x380f0000u, 0x380f2000u, 0x380f4000u, 0x380f6000u, 0x380f8000u, 0x380fa000u, 0x380fc000u, 0x380fe000u, 
    0x38100000u, 0x38102000u, 0x38104000u, 0x38106000u, 0x38108000u, 0x3810a000u, 0x3810c000u, 0x3810e000u, 
    0x38110000u, 0x38112000u, 0x38114000u, 0x38116000u, 0x38118000u, 0x3811a000u, 0x3811c000u, 0x3811e000u, 
    0x38120000u, 0x38122000u, 0x38124000u, 0x38126000u, 0x38128000u, 0x3812a000u, 0x3812c000u, 0x3812e000u, 
    0x38130000u, 0x38132000u, 0x38134000u, 0x38136000u, 0x38138000u, 0x3813a000u, 0x3813c000u, 0x3813e000u, 
    0x38140000u, 0x38142000u, 0x38144000u, 0x38146000u, 0x38148000u, 0x3814a000u, 0x3814c000u, 0x3814e000u, 
    0x38150000u, 0x38152000u, 0x38154000u, 0x38156000u, 0x38158000u, 0x3815a000u, 0x3815c000u, 0x3815e000u, 
    0x38160000u, 0x38162000u, 0x38164000u, 0x38166000u, 0x38168000u, 0x3816a000u, 0x3816c000u, 0x3816e000u, 
    0x38170000u, 0x38172000u, 0x38174000u, 0x38176000u, 0x38178000u, 0x3817a000u, 0x3817c000u, 0x3817e000u, 
    0x38180000u, 0x38182000u, 0x38184000u, 0x38186000u, 0x38188000u, 0x3818a000u, 0x3818c000u, 0x3818e000u, 
    0x38190000u, 0x38192000u, 0x38194000u, 0x38196000u, 0x38198000u, 0x3819a000u, 0x3819c000u, 0x3819e000u, 
    0x381a0000u, 0x381a2000u, 0x381a4000u, 0x381a6000u, 0x381a8000u, 0x381aa000u, 0x381ac000u, 0x381ae000u, 
    0x381b0000u, 0x381b2000u, 0x381b4000u, 0x381b6000u, 0x381b8000u, 0x381ba000u, 0x381bc000u, 0x381be000u, 
    0x381c0000u, 0x381c2000u, 0x381c4000u, 0x381c6000u, 0x381c8000u, 0x381ca000u, 0x381cc000u, 0x381ce000u, 
    0x381d0000u, 0x381d2000u, 0x381d4000u, 0x381d6000u, 0x381d8000u, 0x381da000u, 0x381dc000u, 0x381de000u, 
    0x381e0000u, 0x381e2000u, 0x381e4000u, 0x381e6000u, 0x381e8000u, 0x381ea000u, 0x381ec000u, 0x381ee000u, 
    0x381f0000u, 0x381f2000u, 0x381f4000u, 0x381f6000u, 0x381f8000u, 0x381fa000u, 0x381fc000u, 0x381fe000u, 
    0x38200000u, 0x38202000u, 0x38204000u, 0x38206000u, 0x38208000u, 0x3820a000u, 0x3820c000u, 0x3820e000u, 
    0x38210000u, 0x38212000u, 0x38214000u, 0x38216000u, 0x38218000u, 0x3821a000u, 0x3821c000u, 0x3821e000u, 
    0x38220000u, 0x38222000u, 0x38224000u, 0x38226000u, 0x38228000u, 0x3822a000u, 0x3822c000u, 0x3822e000u, 
    0x38230000u, 0x38232000u, 0x38234000u, 0x38236000u, 0x38238000u, 0x3823a000u, 0x3823c000u, 0x3823e000u, 
    0x38240000u, 0x38242000u, 0x38244000u, 0x38246000u, 0x38248000u, 0x3824a000u, 0x3824c000u, 0x3824e000u, 
    0x38250000u, 0x38252000u, 0x38254000u, 0x38256000u, 0x38258000u, 0x3825a000u, 0x3825c000u, 0x3825e000u, 
    0x38260000u, 0x38262000u, 0x38264000u, 0x38266000u, 0x38268000u, 0x3826a000u, 0x3826c000u, 0x3826e000u, 
    0x38270000u, 0x38272000u, 0x38274000u, 0x38276000u, 0x38278000u, 0x3827a000u, 0x3827c000u, 0x3827e000u, 
    0x38280000u, 0x38282000u, 0x38284000u, 0x38286000u, 0x38288000u, 0x3828a000u, 0x3828c000u, 0x3828e000u, 
    0x38290000u, 0x38292000u, 0x38294000u, 0x38296000u, 0x38298000u, 0x3829a000u, 0x3829c000u, 0x3829e000u, 
    0x382a0000u, 0x382a2000u, 0x382a4000u, 0x382a6000u, 0x382a8000u, 0x382aa000u, 0x382ac000u, 0x382ae000u, 
    0x382b0000u, 0x382b2000u, 0x382b4000u, 0x382b6000u, 0x382b8000u, 0x382ba000u, 0x382bc000u, 0x382be000u, 
    0x382c0000u, 0x382c2000u, 0x382c4000u, 0x382c6000u, 0x382c8000u, 0x382ca000u, 0x382cc000u, 0x382ce000u, 
    0x382d0000u, 0x382d2000u, 0x382d4000u, 0x382d6000u, 0x382d8000u, 0x382da000u, 0x382dc000u, 0x382de000u, 
    0x382e0000u, 0x382e2000u, 0x382e4000u, 0x382e6000u, 0x382e8000u, 0x382ea000u, 0x382ec000u, 0x382ee000u, 
    0x382f0000u, 0x382f2000u, 0x382f4000u, 0x382f6000u, 0x382f8000u, 0x382fa000u, 0x382fc000u, 0x382fe000u, 
    0x38300000u, 0x38302000u, 0x38304000u, 0x38306000u, 0x38308000u, 0x3830a000u, 0x3830c000u, 0x3830e000u, 
    0x38310000u, 0x38312000u, 0x38314000u, 0x38316000u, 0x38318000u, 0x3831a000u, 0x3831c000u, 0x3831e000u, 
    0x38320000u, 0x38322000u, 0x38324000u, 0x38326000u, 0x38328000u, 0x3832a000u, 0x3832c000u, 0x3832e000u, 
    0x38330000u, 0x38332000u, 0x38334000u, 0x38336000u, 0x38338000u, 0x3833a000u, 0x3833c000u, 0x3833e000u, 
    0x38340000u, 0x38342000u, 0x38344000u, 0x38346000u, 0x38348000u, 0x3834a000u, 0x3834c000u, 0x3834e000u, 
    0x38350000u, 0x38352000u, 0x38354000u, 0x38356000u, 0x38358000u, 0x3835a000u, 0x3835c000u, 0x3835e000u, 
    0x38360000u, 0x38362000u, 0x38364000u, 0x38366000u, 0x38368000u, 0x3836a000u, 0x3836c000u, 0x3836e000u, 
    0x38370000u, 0x38372000u, 0x38374000u, 0x38376000u, 0x38378000u, 0x3837a000u, 0x3837c000u, 0x3837e000u, 
    0x38380000u, 0x38382000u, 0x38384000u, 0x38386000u, 0x38388000u, 0x3838a000u, 0x3838c000u, 0x3838e000u, 
    0x38390000u, 0x38392000u, 0x38394000u, 0x38396000u, 0x38398000u, 0x3839a000u, 0x3839c000u, 0x3839e000u, 
    0x383a0000u, 0x383a2000u, 0x383a4000u, 0x383a6000u, 0x383a8000u, 0x383aa000u, 0x383ac000u, 0x383ae000u, 
    0x383b0000u, 0x383b2000u, 0x383b4000u, 0x383b6000u, 0x383b8000u, 0x383ba000u, 0x383bc000u, 0x383be000u, 
    0x383c0000u, 0x383c2000u, 0x383c4000u, 0x383c6000u, 0x383c8000u, 0x383ca000u, 0x383cc000u, 0x383ce000u, 
    0x383d0000u, 0x383d2000u, 0x383d4000u, 0x383d6000u, 0x383d8000u, 0x383da000u, 0x383dc000u, 0x383de000u, 
    0x383e0000u, 0x383e2000u, 0x383e4000u, 0x383e6000u, 0x383e8000u, 0x383ea000u, 0x383ec000u, 0x383ee000u, 
    0x383f0000u, 0x383f2000u, 0x383f4000u, 0x383f6000u, 0x383f8000u, 0x383fa000u, 0x383fc000u, 0x383fe000u, 
    0x38400000u, 0x38402000u, 0x38404000u, 0x38406000u, 0x38408000u, 0x3840a000u, 0x3840c000u, 0x3840e000u, 
    0x38410000u, 0x38412000u, 0x38414000u, 0x38416000u, 0x38418000u, 0x3841a000u, 0x3841c000u, 0x3841e000u, 
    0x38420000u, 0x38422000u, 0x38424000u, 0x38426000u, 0x38428000u, 0x3842a000u, 0x3842c000u, 0x3842e000u, 
    0x38430000u, 0x38432000u, 0x38434000u, 0x38436000u, 0x38438000u, 0x3843a000u, 0x3843c000u, 0x3843e000u, 
    0x38440000u, 0x38442000u, 0x38444000u, 0x38446000u, 0x38448000u, 0x3844a000u, 0x3844c000u, 0x3844e000u, 
    0x38450000u, 0x38452000u, 0x38454000u, 0x38456000u, 0x38458000u, 0x3845a000u, 0x3845c000u, 0x3845e000u, 
    0x38460000u, 0x38462000u, 0x38464000u, 0x38466000u, 0x38468000u, 0x3846a000u, 0x3846c000u, 0x3846e000u, 
    0x38470000u, 0x38472000u, 0x38474000u, 0x38476000u, 0x38478000u, 0x3847a000u, 0x3847c000u, 0x3847e000u, 
    0x38480000u, 0x38482000u, 0x38484000u, 0x38486000u, 0x38488000u, 0x3848a000u, 0x3848c000u, 0x3848e000u, 
    0x38490000u, 0x38492000u, 0x38494000u, 0x38496000u, 0x38498000u, 0x3849a000u, 0x3849c000u, 0x3849e000u, 
    0x384a0000u, 0x384a2000u, 0x384a4000u, 0x384a6000u, 0x384a8000u, 0x384aa000u, 0x384ac000u, 0x384ae000u, 
    0x384b0000u, 0x384b2000u, 0x384b4000u, 0x384b6000u, 0x384b8000u, 0x384ba000u, 0x384bc000u, 0x384be000u, 
    0x384c0000u, 0x384c2000u, 0x384c4000u, 0x384c6000u, 0x384c8000u, 0x384ca000u, 0x384cc000u, 0x384ce000u, 
    0x384d0000u, 0x384d2000u, 0x384d4000u, 0x384d6000u, 0x384d8000u, 0x384da000u, 0x384dc000u, 0x384de000u, 
    0x384e0000u, 0x384e2000u, 0x384e4000u, 0x384e6000u, 0x384e8000u, 0x384ea000u, 0x384ec000u, 0x384ee000u, 
    0x384f0000u, 0x384f2000u, 0x384f4000u, 0x384f6000u, 0x384f8000u, 0x384fa000u, 0x384fc000u, 0x384fe000u, 
    0x38500000u, 0x38502000u, 0x38504000u, 0x38506000u, 0x38508000u, 0x3850a000u, 0x3850c000u, 0x3850e000u, 
    0x38510000u, 0x38512000u, 0x38514000u, 0x38516000u, 0x38518000u, 0x3851a000u, 0x3851c000u, 0x3851e000u, 
    0x38520000u, 0x38522000u, 0x38524000u, 0x38526000u, 0x38528000u, 0x3852a000u, 0x3852c000u, 0x3852e000u, 
    0x38530000u, 0x38532000u, 0x38534000u, 0x38536000u, 0x38538000u, 0x3853a000u, 0x3853c000u, 0x3853e000u, 
    0x38540000u, 0x38542000u, 0x38544000u, 0x38546000u, 0x38548000u, 0x3854a000u, 0x3854c000u, 0x3854e000u, 
    0x38550000u, 0x38552000u, 0x38554000u, 0x38556000u, 0x38558000u, 0x3855a000u, 0x3855c000u, 0x3855e000u, 
    0x38560000u, 0x38562000u, 0x38564000u, 0x38566000u, 0x38568000u, 0x3856a000u, 0x3856c000u, 0x3856e000u, 
    0x38570000u, 0x38572000u, 0x38574000u, 0x38576000u, 0x38578000u, 0x3857a000u, 0x3857c000u, 0x3857e000u, 
    0x38580000u, 0x38582000u, 0x38584000u, 0x38586000u, 0x38588000u, 0x3858a000u, 0x3858c000u, 0x3858e000u, 
    0x38590000u, 0x38592000u, 0x38594000u, 0x38596000u, 0x38598000u, 0x3859a000u, 0x3859c000u, 0x3859e000u, 
    0x385a0000u, 0x385a2000u, 0x385a4000u, 0x385a6000u, 0x385a8000u, 0x385aa000u, 0x385ac000u, 0x385ae000u, 
    0x385b0000u, 0x385b2000u, 0x385b4000u, 0x385b6000u, 0x385b8000u, 0x385ba000u, 0x385bc000u, 0x385be000u, 
    0x385c0000u, 0x385c2000u, 0x385c4000u, 0x385c6000u, 0x385c8000u, 0x385ca000u, 0x385cc000u, 0x385ce000u, 
    0x385d0000u, 0x385d2000u, 0x385d4000u, 0x385d6000u, 0x385d8000u, 0x385da000u, 0x385dc000u, 0x385de000u, 
    0x385e0000u, 0x385e2000u, 0x385e4000u, 0x385e6000u, 0x385e8000u, 0x385ea000u, 0x385ec000u, 0x385ee000u, 
    0x385f0000u, 0x385f2000u, 0x385f4000u, 0x385f6000u, 0x385f8000u, 0x385fa000u, 0x385fc000u, 0x385fe000u, 
    0x38600000u, 0x38602000u, 0x38604000u, 0x38606000u, 0x38608000u, 0x3860a000u, 0x3860c000u, 0x3860e000u, 
    0x38610000u, 0x38612000u, 0x38614000u, 0x38616000u, 0x38618000u, 0x3861a000u, 0x3861c000u, 0x3861e000u, 
    0x38620000u, 0x38622000u, 0x38624000u, 0x38626000u, 0x38628000u, 0x3862a000u, 0x3862c000u, 0x3862e000u, 
    0x38630000u, 0x38632000u, 0x38634000u, 0x38636000u, 0x38638000u, 0x3863a000u, 0x3863c000u, 0x3863e000u, 
    0x38640000u, 0x38642000u, 0x38644000u, 0x38646000u, 0x38648000u, 0x3864a000u, 0x3864c000u, 0x3864e000u, 
    0x38650000u, 0x38652000u, 0x38654000u, 0x38656000u, 0x38658000u, 0x3865a000u, 0x3865c000u, 0x3865e000u, 
    0x38660000u, 0x38662000u, 0x38664000u, 0x38666000u, 0x38668000u, 0x3866a000u, 0x3866c000u, 0x3866e000u, 
    0x38670000u, 0x38672000u, 0x38674000u, 0x38676000u, 0x38678000u, 0x3867a000u, 0x3867c000u, 0x3867e000u, 
    0x38680000u, 0x38682000u, 0x38684000u, 0x38686000u, 0x38688000u, 0x3868a000u, 0x3868c000u, 0x3868e000u, 
    0x38690000u, 0x38692000u, 0x38694000u, 0x38696000u, 0x38698000u, 0x3869a000u, 0x3869c000u, 0x3869e000u, 
    0x386a0000u, 0x386a2000u, 0x386a4000u, 0x386a6000u, 0x386a8000u, 0x386aa000u, 0x386ac000u, 0x386ae000u, 
    0x386b0000u, 0x386b2000u, 0x386b4000u, 0x386b6000u, 0x386b8000u, 0x386ba000u, 0x386bc000u, 0x386be000u, 
    0x386c0000u, 0x386c2000u, 0x386c4000u, 0x386c6000u, 0x386c8000u, 0x386ca000u, 0x386cc000u, 0x386ce000u, 
    0x386d0000u, 0x386d2000u, 0x386d4000u, 0x386d6000u, 0x386d8000u, 0x386da000u, 0x386dc000u, 0x386de000u, 
    0x386e0000u, 0x386e2000u, 0x386e4000u, 0x386e6000u, 0x386e8000u, 0x386ea000u, 0x386ec000u, 0x386ee000u, 
    0x386f0000u, 0x386f2000u, 0x386f4000u, 0x386f6000u, 0x386f8000u, 0x386fa000u, 0x386fc000u, 0x386fe000u, 
    0x38700000u, 0x38702000u, 0x38704000u, 0x38706000u, 0x38708000u, 0x3870a000u, 0x3870c000u, 0x3870e000u, 
    0x38710000u, 0x38712000u, 0x38714000u, 0x38716000u, 0x38718000u, 0x3871a000u, 0x3871c000u, 0x3871e000u, 
    0x38720000u, 0x38722000u, 0x38724000u, 0x38726000u, 0x38728000u, 0x3872a000u, 0x3872c000u, 0x3872e000u, 
    0x38730000u, 0x38732000u, 0x38734000u, 0x38736000u, 0x38738000u, 0x3873a000u, 0x3873c000u, 0x3873e000u, 
    0x38740000u, 0x38742000u, 0x38744000u, 0x38746000u, 0x38748000u, 0x3874a000u, 0x3874c000u, 0x3874e000u, 
    0x38750000u, 0x38752000u, 0x38754000u, 0x38756000u, 0x38758000u, 0x3875a000u, 0x3875c000u, 0x3875e000u, 
    0x38760000u, 0x38762000u, 0x38764000u, 0x38766000u, 0x38768000u, 0x3876a000u, 0x3876c000u, 0x3876e000u, 
    0x38770000u, 0x38772000u, 0x38774000u, 0x38776000u, 0x38778000u, 0x3877a000u, 0x3877c000u, 0x3877e000u, 
    0x38780000u, 0x38782000u, 0x38784000u, 0x38786000u, 0x38788000u, 0x3878a000u, 0x3878c000u, 0x3878e000u, 
    0x38790000u, 0x38792000u, 0x38794000u, 0x38796000u, 0x38798000u, 0x3879a000u, 0x3879c000u, 0x3879e000u, 
    0x387a0000u, 0x387a2000u, 0x387a4000u, 0x387a6000u, 0x387a8000u, 0x387aa000u, 0x387ac000u, 0x387ae000u, 
    0x387b0000u, 0x387b2000u, 0x387b4000u, 0x387b6000u, 0x387b8000u, 0x387ba000u, 0x387bc000u, 0x387be000u, 
    0x387c0000u, 0x387c2000u, 0x387c4000u, 0x387c6000u, 0x387c8000u, 0x387ca000u, 0x387cc000u, 0x387ce000u, 
    0x387d0000u, 0x387d2000u, 0x387d4000u, 0x387d6000u, 0x387d8000u, 0x387da000u, 0x387dc000u, 0x387de000u, 
    0x387e0000u, 0x387e2000u, 0x387e4000u, 0x387e6000u, 0x387e8000u, 0x387ea000u, 0x387ec000u, 0x387ee000u, 
    0x387f0000u, 0x387f2000u, 0x387f4000u, 0x387f6000u, 0x387f8000u, 0x387fa000u, 0x387fc000u, 0x387fe000u
};

// -----------------------------------------------------------------------------

const std::uint32_t float16_t :: s_exponentTable [ 64 ] =
{
    0x0u, 0x800000u, 0x1000000u, 0x1800000u, 0x2000000u, 0x2800000u, 0x3000000u, 0x3800000u, 
    0x4000000u, 0x4800000u, 0x5000000u, 0x5800000u, 0x6000000u, 0x6800000u, 0x7000000u, 0x7800000u, 
    0x8000000u, 0x8800000u, 0x9000000u, 0x9800000u, 0xa000000u, 0xa800000u, 0xb000000u, 0xb800000u, 
    0xc000000u, 0xc800000u, 0xd000000u, 0xd800000u, 0xe000000u, 0xe800000u, 0xf000000u, 0x47800000u, 
    0x80000000u, 0x80800000u, 0x81000000u, 0x81800000u, 0x82000000u, 0x82800000u, 0x83000000u, 0x83800000u, 
    0x84000000u, 0x84800000u, 0x85000000u, 0x85800000u, 0x86000000u, 0x86800000u, 0x87000000u, 0x87800000u, 
    0x88000000u, 0x88800000u, 0x89000000u, 0x89800000u, 0x8a000000u, 0x8a800000u, 0x8b000000u, 0x8b800000u, 
    0x8c000000u, 0x8c800000u, 0x8d000000u, 0x8d800000u, 0x8e000000u, 0x8e800000u, 0x8f000000u, 0xc7800000u
};

// -----------------------------------------------------------------------------

const std::uint16_t float16_t :: s_offsetTable [ 64 ] =
{
    0x0u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 
    0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 
    0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 
    0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 
    0x0u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 
    0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 
    0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 
    0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u, 0x400u
};

// -----------------------------------------------------------------------------

const std::uint16_t float16_t :: s_baseTable [ 512 ] =
{
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 
    0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x0u, 0x1u, 
    0x2u, 0x4u, 0x8u, 0x10u, 0x20u, 0x40u, 0x80u, 0x100u, 
    0x200u, 0x400u, 0x800u, 0xc00u, 0x1000u, 0x1400u, 0x1800u, 0x1c00u, 
    0x2000u, 0x2400u, 0x2800u, 0x2c00u, 0x3000u, 0x3400u, 0x3800u, 0x3c00u, 
    0x4000u, 0x4400u, 0x4800u, 0x4c00u, 0x5000u, 0x5400u, 0x5800u, 0x5c00u, 
    0x6000u, 0x6400u, 0x6800u, 0x6c00u, 0x7000u, 0x7400u, 0x7800u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 0x7c00u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 
    0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8000u, 0x8001u, 
    0x8002u, 0x8004u, 0x8008u, 0x8010u, 0x8020u, 0x8040u, 0x8080u, 0x8100u, 
    0x8200u, 0x8400u, 0x8800u, 0x8c00u, 0x9000u, 0x9400u, 0x9800u, 0x9c00u, 
    0xa000u, 0xa400u, 0xa800u, 0xac00u, 0xb000u, 0xb400u, 0xb800u, 0xbc00u, 
    0xc000u, 0xc400u, 0xc800u, 0xcc00u, 0xd000u, 0xd400u, 0xd800u, 0xdc00u, 
    0xe000u, 0xe400u, 0xe800u, 0xec00u, 0xf000u, 0xf400u, 0xf800u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
    0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 0xfc00u, 
};

// -----------------------------------------------------------------------------

const std::uint8_t float16_t :: s_shiftTable [ 512 ] =
{
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x17u, 
    0x16u, 0x15u, 0x14u, 0x13u, 0x12u, 0x11u, 0x10u, 0xfu, 
    0xeu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 
    0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 
    0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 
    0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0xdu, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x17u, 
    0x16u, 0x15u, 0x14u, 0x13u, 0x12u, 0x11u, 0x10u, 0xfu, 
    0xeu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 
    0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 
    0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 
    0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0xdu, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 
    0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0x18u, 0xdu
};

// -----------------------------------------------------------------------------
} // namespace vpp
// -----------------------------------------------------------------------------
