/*
 * Piano.cpp
 *
 *  Created on: 2008/08/05
 *      Author: syn
 */

#include <iostream>
#include <GL/gl.h>
#include <lo/lo.h>
#include "SynthController.h"
#include "Piano.h"

struct Key{
	int midiNote;
	int left, top, right, bottom;
	int color;	// wite: 0, black: 1
};

Piano::Piano()
:Controller(){
	mCurNote = -1;
	mMousePressed = false;
	mKeySet = new Key[12*5];

	int bn = 0;
	int wn = 0;
	int noteOffset = 36;
	for(int i = 0; i < 12*5; i++){
		int n = i%12;
		if(n == 1 || n == 3 || n == 6 || n == 8 || n == 10){
			mKeySet[i].midiNote = i+noteOffset;
			mKeySet[i].color = 1;
			mKeySet[i].left = bn*10+7;
			mKeySet[i].top = 0;
			mKeySet[i].right = bn*10+14;
			mKeySet[i].bottom = 16;
			if(n == 3 || n == 10){
				bn += 2;
			}else{
				bn++;
			}
		}else{
			mKeySet[i].midiNote = i+noteOffset;
			mKeySet[i].color = 0;
			mKeySet[i].left = wn*10;
			mKeySet[i].top = 0;
			mKeySet[i].right = wn*10 +10;
			mKeySet[i].bottom = 32;
			wn += 1;
		}
	}
}

Piano::~Piano() {
	delete[] mKeySet;
}

void Piano::render(){
	glPushMatrix();
	glLoadIdentity();
	glTranslatef(mLocX, mLocY, 0);

	glColor3f(1, 1, 1);
	for(int i = 0; i < 12*5; i++){
		if(mKeySet[i].color == 0){
			if(mKeySet[i].midiNote == mCurNote){
				glColor3f(1, 0.7, 0);
				glBegin(GL_POLYGON);
				glVertex3f(mKeySet[i].left, mKeySet[i].top, -0.5);
				glVertex3f(mKeySet[i].left, mKeySet[i].bottom, -0.5);
				glVertex3f(mKeySet[i].right, mKeySet[i].bottom, -0.5);
				glVertex3f(mKeySet[i].right, mKeySet[i].top, -0.5);
				glEnd();
			}
			glColor3f(1, 1, 1);
			glBegin(GL_LINE_STRIP);
			glVertex3f(mKeySet[i].left, mKeySet[i].top, 0);
			glVertex3f(mKeySet[i].left, mKeySet[i].bottom, 0);
			glVertex3f(mKeySet[i].right, mKeySet[i].bottom, 0);
			glVertex3f(mKeySet[i].right, mKeySet[i].top, 0);
			glVertex3f(mKeySet[i].left, mKeySet[i].top, 0);
			glEnd();
		}else{
			if(mKeySet[i].midiNote == mCurNote){
				glColor3f(1, 0.7, 0);
				glBegin(GL_POLYGON);
				glVertex3f(mKeySet[i].left, mKeySet[i].top, +0.5);
				glVertex3f(mKeySet[i].left, mKeySet[i].bottom, +0.5);
				glVertex3f(mKeySet[i].right, mKeySet[i].bottom, +0.5);
				glVertex3f(mKeySet[i].right, mKeySet[i].top, +0.5);
				glEnd();
			}else{
				glColor3f(1, 1, 1);
				glBegin(GL_POLYGON);
				glVertex3f(mKeySet[i].left, mKeySet[i].top, 0);
				glVertex3f(mKeySet[i].left, mKeySet[i].bottom, 0);
				glVertex3f(mKeySet[i].right, mKeySet[i].bottom, 0);
				glVertex3f(mKeySet[i].right, mKeySet[i].top, 0);
				glEnd();
			}
		}
	}

	// Frame
	glPopMatrix();
}

void Piano::handleMouseButtonDown(const int x, const int y){
	int midiNote = locateToMIDINote(x, y);
	if(midiNote == -1){
		return;
	}

	mMousePressed = true;
	//std::cout << midiNote << std::endl;
	if(midiNote != mCurNote){
		lo_address t = SynthController::getInstance()->getSynthAddress();
		lo_send(t, "/NOTE_ON", "i", midiNote);
		mCurNote = midiNote;
	}
}

void Piano::handleMouseButtonUp(const int x, const int y){
	mMousePressed = false;
	mCurNote = -1;
}

void Piano::handleMouseMotion(const int btn, const int x, const int y){
	if(!mMousePressed){
		return;
	}

	int midiNote = locateToMIDINote(x, y);
	if(midiNote == -1){
		return;
	}

	//std::cout << midiNote << std::endl;
	if(midiNote != mCurNote){
		lo_address t = SynthController::getInstance()->getSynthAddress();
		lo_send(t, "/NOTE_ON", "i", midiNote);
		mCurNote = midiNote;
	}
}

/**
 *  マウスの位置から MIDI-Noteへの変換
 *  @return MIDINote (-1: 範囲外)
 */
int Piano::locateToMIDINote(const int x, const int y){
	for(int i = 0; i < 12*5; i++){
		if(mKeySet[i].color == 0){
			continue;
		}
		if(x >= mKeySet[i].left && x <= mKeySet[i].right){
			if(y >= mKeySet[i].top && y <= mKeySet[i].bottom){
				return mKeySet[i].midiNote;
			}
		}
	}

	for(int i = 0; i < 12*5; i++){
		if(mKeySet[i].color == 1){
			continue;
		}
		if(x >= mKeySet[i].left && x <= mKeySet[i].right){
			if(y >= mKeySet[i].top && y <= mKeySet[i].bottom){
				return mKeySet[i].midiNote;
			}
		}
	}

	return -1;
}
