#include <unistd.h>
#include "timer.h"

Timer::Timer(int msec, void (*cb)(void* p), void* p, bool oneShot)
:Thread(){
	mInterval = msec;
	mOneShot = oneShot;
	mCallBack = cb;
	mUserPtr = p;
}

Timer::~Timer(){
}

void* Timer::run(){
	while(true){
		usleep(mInterval*1000);
		mCallBack(mUserPtr);
		if(mOneShot){
			break;
		}
	}

	return 0;
}
