/*
  l{bgȂ瑀
  Satofumi KAMIMURA
  $Id$
*/

#include "mRunCtrl.h"
#include "mURGCtrl.h"
#include "vutils.h"
#include "joystickCtrl.h"
#include "inputHandle.h"
#include <stdlib.h>


int main(int argc, char *argv[]) {
  try {
    mRunCtrl run;
    mURGCtrl urg;
    if ((initConnection(&run, argc, argv) < 0) ||
	(initConnection(&urg, argc, argv) < 0)) {
      exit(1);
    }
    urg.setOwnCrdToObject(&run);
    run.adjustSubTreeTicks(0);

    vmonitor::show();

    // Joystick Ώ
    JoystickCtrl js;
    if (js.size() > 0) {
      js.activate();
    }

    // C̐䃋[v
    UserInput::userInput_t ui;
    int pre_times = -1;
    do {
      ui = UserInput::getInputed();
      robotInput_t ri = inputHandle(js, ui);
      drawJetMode(ri);
      robotCtrl(run, ri);

      // ̎擾
      int times = urg.capture();
      if (times != pre_times) {
	drawCaptures(urg, run);
      }
      VXV::Delay(1);
    } while (!ui.quit);
  } catch (std::exception& e) {
    printf("exception: %s\n", e.what());
  }
  return 0;
}
