#ifndef ANIMATION_SURFACE_H
#define ANIMATION_SURFACE_H

/*!
  \file
  \brief Aj[VT[tF[X̕`NX
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "drawSurface.h"


/*!
  \brief Aj[VT[tFX̕`NX

  T[tFX̑傫(w, h)́Ao^ĂT[tFXňԑ傫ȒlɂȂ
  
*/
class AnimationSurface : public SurfaceInterface {
public:
  /*!
    \brief Aj[ṼZ̊i[NX
  */
  class CellInformation {
    CellInformation(void);

  public:
    /*!
      \brief Zw肵ăIuWFNg𐶐

      \param index [i] `ɎgpCfbNXԍ
      \param ticks [i] `掞
      \param align [i] Z̃Aj[VT[tFXɂ`ꏊw
    */
    CellInformation(int index, unsigned long ticks, char align = 0)
      : index(index), ticks(ticks), align(align) {}
    ~CellInformation(void) {}
    int index;			/*!< \̃Zԍ */
    unsigned long ticks;	/*!<  */
    char align;			/*!< ʒu */

    VXV::Grid offset;		/*!< ItZbg */
  };

private:
  std::vector<DrawSurface*> cells;
  std::vector<CellInformation> cell_info;
  unsigned long ticks_msec;
  unsigned long cycle;
  void sizeUpdate(DrawSurface* surface);

public:
  AnimationSurface(void);
  ~AnimationSurface(void);
  bool draw(const VXV::Rect& size,
	    const VXV::Grid& pos, unsigned long ticks);

  /*!
    \brief T[tFXo^

    Aj[VɗpT[tFXo^

    \param bmpFile [i] ǂݍ BMPt@C
    \param transparent [i] ̓_𓧉ߐFɕύXꍇ true

    \return o^T[tFX̃CfbNXԍ
  */
  int addCell(const char* bmpFile, bool transparent = false);

  /*!
    \overload

    \param sdlSurface [i] o^ SDLT[tFX
    \param transparent [i] ̓_𓧉ߐFɕύXꍇ true

    \return o^T[tFX̃CfbNXԍ
  */
  int addCell(SDL_Surface* sdlSurface, bool transparent = false);

  /*!
    \brief Aj[V̒ǉ

    Aj[ṼZǉBAj[V́A\ɒǉ邱

    \param info [i] Z̏
  */
  void addCellInformation(const CellInformation& info);

  /*!
    \brief Aj[V̒PʎԂݒ

    CellInformation::ticks  1ticks  msec Ԃݒ肵Aɓo^Ă CellInformation ̏]B

    \attention ̃\bh́AZT[tFXƃZ񂪑Sēo^ꂽɌĂяoȂ΂Ȃ炢B
    
    \param msec [i] CellInformation::ticks ̎ [msec]
  */
  void setTicksMsec(unsigned long msec);
};

#endif /* !ANIMATION_SURFACE_H */
