/*
  hԂT[tFX
  Satofumi KAMIMURA
  $Id$
*/

#include "fillSurface.h"
#include "sdlVideo.h"


FillSurface::  FillSurface(const VXV::Rect& size, unsigned long color)
  : draw_size(size), draw_color(color), draw_surface(NULL) {
  w = size.w;
  h = size.h;
}


FillSurface:: FillSurface(const VXV::Rect& size, SurfaceInterface* surface)
  : draw_size(size), draw_surface(surface) {
  w = size.w;
  h = size.h;
}


FillSurface::~FillSurface(void) {
}


bool FillSurface::draw(const VXV::Rect& size, const VXV::Grid& pos,
		       unsigned long ticks) {
  draw_size.x = pos.x;
  draw_size.y = pos.y;
  if (!draw_surface) {
    SDL_Video::fillRect(draw_size, draw_color);

  } else {
    VXV::Rect surface_pos, surface_size;
    for (int y_offset = 0; y_offset < size.h; y_offset += draw_surface->h) {
      for (int x_offset = 0; x_offset < size.w; x_offset += draw_surface->w) {
	surface_pos.x = pos.x + x_offset;
	surface_pos.y = pos.y + y_offset;
	surface_size.w = (x_offset + draw_surface->w > size.w) ?
	  size.w - x_offset : draw_surface->w;
	surface_size.h = (y_offset + draw_surface->h > size.h) ?
	  size.h - y_offset : draw_surface->h;
	draw_surface->draw(surface_size, surface_pos, ticks);
      }
    }
  }
  return true;
}
