/*
  x\̃R|[lg
  Satofumi KAMIMURA
  $Id$
*/

#include "labelComponent.h"


LabelComponent::LabelComponent(SurfaceInterface* obj) : surface(obj) {
  if (surface) {
    w = surface->w;
    h = surface->h;
  } else {
    w = 0;
    h = 0;
  }
  position = VXV::Grid(0, 0);
}


bool LabelComponent::draw(unsigned long ticks, const UserInput& ui) {
  if (!surface) {
    return false;

  } else {
    surface->draw(VXV::Rect(surface->w, surface->h), position, ticks);
    return true;
  }
}


bool LabelComponent::draw(const VXV::Grid& view_pos,
			  const VXV::Rect& view_range, double view_magnify,
			  const VXV::Grid& draw_pos, bool pined) {
  VXV::Grid pos;
  if (pined) {
    // ʒuvZ
    pos.x = static_cast<int>(rint((draw_pos.x - view_range.x) * view_magnify))
      + view_pos.x;
    pos.y = static_cast<int>(rint((-draw_pos.y - view_range.y) * view_magnify))
      + view_pos.y;
  } else {
    pos = draw_pos;
  }
  pos += view_pos;

  // ͈͌vZ
  VXV::Rect draw_range;
  draw_range.x = view_pos.x;
  draw_range.y = view_pos.y;
  draw_range.w = draw_range.x + view_range.w;
  draw_range.h = draw_range.y + view_range.h;

  if ((pos.x > draw_range.w) || (pos.x + surface->w < draw_range.x) ||
      (pos.y > draw_range.h) || (pos.y + surface->h < draw_range.y)) {
    return true;
  }

  VXV::Rect draw_rect = VXV::Rect(0, 0, surface->w, surface->h);
  if (pos.x < draw_range.x) {
    draw_rect.x = draw_range.x - pos.x;
  }
  if (pos.y < draw_range.y) {
    draw_rect.y = draw_range.y - pos.y;
  }
  if (pos.x + surface->w > draw_range.w) {
    draw_rect.w -= pos.x + surface->w - draw_range.w;
  }
  if (pos.y + surface->h > draw_range.h) {
    draw_rect.h -= pos.y + surface->h - draw_range.h;
  }
  surface->draw(draw_rect, pos, 0);
  return true;
}
