/*
  j[\̃R|[lg
  Satofumi KAMIMURA
  $Id$
*/

#include "menuComponent.h"
#include "deleteObjects.h"


MenuComponent::MenuComponent(void)
  : button_offset(VXV::Rect(0, 0)), icon_offset(VXV::Rect(0, 0)), icon(NULL),
    activated(false), draw_hide(false), ctrl_disable(false),
    initialized(false), decided(false), no_default(true), now_index(0) {
  w = 0;
  h = 0;
  position = VXV::Grid(0, 0);
  changeKeySettings(true);
}


MenuComponent::~MenuComponent(void) {
  delete icon;
  for_each(items.begin(), items.end(), DeleteObjects());
}


MenuComponent::item_t::item_t(void) : button(NULL), select_enable(true) {
}


MenuComponent::item_t::~item_t(void) {
  delete button;
}


void MenuComponent::changeKeySettings(bool set_default) {
  if (set_default) {
    code_down = SDLK_DOWN;
    code_n = SDLK_n;
    code_up = SDLK_UP;
    code_p = SDLK_p;
    code_first = SDLK_LEFT;
    code_last = SDLK_RIGHT;
  } else {
    code_down = SDLK_RIGHT;
    code_n = SDLK_f;
    code_up = SDLK_LEFT;
    code_p = SDLK_b;
    code_first = SDLK_UP;
    code_last = SDLK_DOWN;
  }
}


bool MenuComponent::draw(unsigned long ticks, const UserInput& ui) {
  if (!activated) {
    return false;
  }
  if (draw_hide) {
    return true;
  }

  // Iڂ̌
  if (ctrl_disable) {
    decided = false;
  }

  int index = 0;
  if (!decided && !ctrl_disable) {
    int items_size = items.size();
    for (UserInput::sdl_keys_t::const_iterator it = ui.sdl_keys_sys.begin();
	 it != ui.sdl_keys_sys.end(); ++it, ++index) {
      int key_moved = 0;

      if ((*it == SDLK_RETURN) ||
	  ((ui.sdl_mods_sys[index] & KMOD_CTRL) &&
	   ((*it == SDLK_j) || (*it == SDLK_m)))) {
	decided = true;
      }

      // Iڂ̕ύXA`
      if ((*it == code_down) ||
	  ((ui.sdl_mods_sys[index] & KMOD_CTRL) && (*it == code_n))) {
	++key_moved;
      }
      if ((*it == code_up) ||
	  ((ui.sdl_mods_sys[index] & KMOD_CTRL) && (*it == code_p))) {
	--key_moved;
      }
      if (*it == code_last) {
	key_moved = static_cast<int>(items.size()-1 - now_index);
      } else if (*it == code_first) {
	key_moved = -now_index;
      }

      // IłȂڂɃACRZbgȂ
      while ((key_moved != 0) &&
	     (now_index + key_moved < items_size) &&
	     (now_index + key_moved >= 0) &&
	     (!items[now_index + key_moved]->select_enable)) {
	if (key_moved > 0) {
	  ++key_moved;
	} else {
	  --key_moved;
	}
      }

      // ڂɃACRړł邩̔
      int next_index = now_index + key_moved;
      if ((next_index >= 0) && (next_index < items_size)) {
	now_index += key_moved;
      }
    }
  }

  VXV::Grid button_pos;
  index = 0;
  int next_index = now_index;
  if (!no_default && ui.state.mouse_moved) {
    next_index = -1;
  }
  for (std::vector<item_t*>::iterator it = items.begin();
       it != items.end(); ++it, ++index) {
    (*it)->button->setPosition(position + button_pos);

    (*it)->button->setDrawSurface((index == now_index) ?
				  ButtonComponent::Focused :
				  ButtonComponent::Normal);
    (*it)->button->draw(ticks, ui);
    if ((*it)->button->isPressed() && (*it)->select_enable) {
      decided = true;
    }
    if ((*it)->button->isFocused() &&
	ui.state.mouse_moved && !decided && !ctrl_disable &&
	(*it)->select_enable) {
      next_index = index;
    }
    button_pos.x += button_offset.w;
    button_pos.y += button_offset.h;
  }
  now_index = next_index;
  if (icon && (now_index >= 0)) {
    VXV::Grid icon_pos = position
      + VXV::Grid(icon_offset.w, icon_offset.h)
      + VXV::Grid(button_offset.w * now_index, button_offset.h * now_index);
    icon->setPosition(icon_pos);
    icon->draw(ticks, ui);
  }
  return initialized;
}


void MenuComponent::add(ButtonComponent* button) {
  item_t* add = new item_t;
  add->button = button;
  items.push_back(add);
  if (button->h > button_offset.h) {
    button_offset.h = button->h;
  }
}


void MenuComponent::addIcon(LabelComponent* label) {
  icon = label;
}


void MenuComponent::setOffset(const VXV::Rect& offset) {
  button_offset = offset;
}


void MenuComponent::setIconOffset(const VXV::Rect& offset) {
  icon_offset = offset;
}


void MenuComponent::setSelectedIndex(int index) {
  // !!! 
}


// ́Ao^{^͂ރTCYƂȂAACR͍lȂ
// ʒúAŏɓo^{^̍Wɕ`n߂
void MenuComponent::activate(bool on) {
  w = 0; h = 0;
  int w_max = 0, h_max = 0;
  for (std::vector<item_t*>::iterator it = items.begin();
       it != items.end(); ++it) {
    if (w + (*it)->button->w > w_max) {
      w_max = w + (*it)->button->w;
    }
    if (h + (*it)->button->h > h_max) {
      h_max = h + (*it)->button->h;
    }
    w += button_offset.w;
    h += button_offset.h;
  }
  w = w_max;
  h = h_max;

  activated = on;
  initialized = true;
  decided = false;
  ctrl_disable = false;
}


void MenuComponent::hide(bool on) {
  draw_hide = on;
}

void MenuComponent::disable(bool on) {
  ctrl_disable = on;
}


void MenuComponent::defaultSelection(bool on) {
  no_default = on;
  if (!on) {
    now_index = -1;
  }
}


bool MenuComponent::isDecided(void) {
  return decided;
}


void MenuComponent::setNowIndex(int index) {
  now_index = index;
}

int MenuComponent::getNowIndex(void) {
  return now_index;
}


void MenuComponent::beginFocus(void) {
  if (now_index < 0) {
    now_index = 0;
  }
  disable(false);
}


void MenuComponent::endFocus(void) {
  if (!no_default) {
    now_index = -1;
  }
  disable(true);
}


void MenuComponent::setIndexActive(int index, bool on) {
  if ((index < 0) || (index >= static_cast<int>(items.size()))) {
    return;
  }
  items[index]->select_enable = on;
}
