/*
  XN[eLXg\
  Satofumi KAMIMURA
  $Id$
*/

// \Todo ĕ`悪x悤ȂADra+---face ̓LbVǗ

#include "scrollAreaComponent.h"
#include "drawSurface.h"
#include "labelComponent.h"
#include "detect_os.h"


ScrollAreaComponent::ScrollAreaComponent(TTF_Draw& ttfObj,
					 const VXV::Rect& drawRect)
  : ttf(ttfObj), px_size(16), draw_rect(drawRect) {
  w = draw_rect.w;
  h = draw_rect.h;
  position = VXV::Grid(draw_rect.x, draw_rect.y);

  set_color.fore = White;
  set_color.back = Gray4;
  clear();
}


ScrollAreaComponent::~ScrollAreaComponent(void) {
}


VXV::Grid ScrollAreaComponent::drawChar(draws_t& dch,
					const VXV::Grid& position,
					VXV::Grid& cursor) {
  Uint16 ch[] = { dch.ch, 0x0000 };
  DrawSurface* surface =
    new DrawSurface(ttf.createText(ch, px_size,
				   dch.color.fore, dch.color.back), true);
  int width = surface->w;
  if (cursor.x + width <= draw_rect.w) {
    LabelComponent* label = new LabelComponent(surface);
    label->draw(position, VXV::Rect(0, 0, w, h), 1.0, cursor, false);
    delete label;
  }
  delete surface;

  return VXV::Grid(width, 0);
}


void ScrollAreaComponent::createEndl(VXV::Grid& cursor, int& first_endl,
				     std::deque<draws_t>::iterator& it) {
  if (first_endl == InvalidEndl) {
    first_endl = static_cast<int>(it - texts.begin() +1);
  }
  cursor.x = 0;
  cursor.y += px_size;
}


bool ScrollAreaComponent::draw(unsigned long ticks, const UserInput& ui) {

  int first_endl = InvalidEndl;
  VXV::Grid cursor = VXV::Grid(0, 0);
  for (std::deque<draws_t>::iterator it = texts.begin();
       it != texts.end(); ++it) {

    // ił̐܂Ԃ
    if ((cursor.y + px_size > draw_rect.h) && (first_endl != InvalidEndl)) {
      texts.erase(texts.begin(), texts.begin() + first_endl);
      break;
    }

    switch (it->ch) {
    case 0x00:
      break;

    case ' ':
      cursor.x += px_size >> 1;
      break;

      case '\t':
	// !!! 
	break;

    case '\n':
      createEndl(cursor, first_endl, it);
      break;

    default:
      cursor += drawChar(*it, position, cursor);
      if (cursor.x > draw_rect.w) {
	createEndl(cursor, first_endl, it);
	--it;
      }
      break;
    }
  }
  return true;
}


void ScrollAreaComponent::setPxelSize(int pxelSize) {
  px_size = pxelSize;
}


void ScrollAreaComponent::setColor(unsigned long color, unsigned long back) {
  set_color.fore = color;
  set_color.back = back;
}


void ScrollAreaComponent::setCh(const Uint16 ch, int width) {
  draws_t dch;
  dch.ch = ch;
  dch.width = width;
  dch.color = set_color;
  texts.push_back(dch);
}


int ScrollAreaComponent::printf(const char *fmt, va_list ap) {
  enum { BufferMax = 1024 };
  char buffer[BufferMax];

#ifndef MSC
  int n = vsnprintf(buffer, BufferMax, fmt, ap);
#else
  int n = _vsnprintf(buffer, BufferMax, fmt, ap);
#endif
  va_end(ap);
  for (int i = 0; i < n; ++i) {
    Uint16 ch = buffer[i];
    setCh(ch);
  }
  return n;
}


int ScrollAreaComponent::printf(const char *fmt, ...) {
  va_list ap;
  va_start(ap, fmt);
  return printf(fmt, ap);
}


void ScrollAreaComponent::drawUnicode(const Uint16* text) {
  // !!! 
  // !!! width = 2 ŁAP
}


void ScrollAreaComponent::clear(void) {
  texts.clear();
}
