/*
  SDL(Video)̏
  Satofumi KAMIMURA
  $Id$
*/

#include "sdlVideo.h"
#include "userInput.h"
#include "deleteObjects.h"
#include <limits.h>


UserInput::userInput_t UserInput::state;
bool SDL_Video::activated = false;
bool SDL_Video::fullscreen = false;
SDL_Surface *SDL_Video::screen = NULL;
SDL_mutex *SDL_Video::mutex = NULL;
std::map<char,SDL_Video::drawList> SDL_Video::draws;
Uint32 SDL_Video::pre_ticks = SDL_GetTicks();
bool SDL_Video::cursor_hide = false;
int SDL_Video::wait_msec_max = INT_MAX;
int SDL_Video::wait_msec = INT_MAX;
SDL_Video::call_t SDL_Video::callback = NULL;
bool SDL_Video::initialized = false;
std::vector<FocusComponentInterface*> SDL_Video::inputList;
int SDL_Video::input_index = 0;
bool SDL_Video::fullscreen_trigger = false;


SDL_Surface* SDL_Video::createScreen(void) {
  Uint32 mode = SDL_HWSURFACE | SDL_DOUBLEBUF;
  if (fullscreen) {
    mode |= SDL_FULLSCREEN;
  }
  return SDL_SetVideoMode(ScreenWidth, ScreenHeight, 32, mode);
}


int SDL_Video::updateThread(void* dummy) {
  UserInput& userInput = UserInput::getObject();

  bool activated_check = true;
  while (activated_check) {
    lock();
    activated_check = activated;
    if (!activated_check) {
      unlock();
      continue;
    }

    // ͏̍XV
    Uint32 ticks = SDL_GetTicks();
    userInput.internal_update();
    // TAB ɂtH[JX؂ւ
    if (userInput.state.tab_pressed) {
      toggleFocus();
    }
    if (userInput.toggle_fullscreen || fullscreen_trigger) {
      if (fullscreen_trigger) {
	fullscreen_trigger = false;
      } else {
	fullscreen = !fullscreen;
      }
      // XN[̃TCY
      screen = createScreen();

      // J[\̕`/B
      wait_msec = wait_msec_max;
      SDL_ShowCursor(SDL_ENABLE);
      cursor_hide = false;
    }

    if (fullscreen) {
      if (userInput.state.mouse_moved) {
	wait_msec = wait_msec_max;
	if (cursor_hide) {
	  SDL_ShowCursor(SDL_ENABLE);
	  cursor_hide = false;
	}
      } else {
	wait_msec -= ticks - pre_ticks;
	if (wait_msec < 0 && !cursor_hide) {
	  SDL_ShowCursor(SDL_DISABLE);
	  cursor_hide = true;
	}
      }
    }

    // `vf̍ĕ`
    for (std::map<char,drawList>::iterator mit = draws.begin();
	 mit != draws.end(); ++mit) {
      for (drawList::iterator lit = mit->second.begin();
	   lit != mit->second.end();) {
	bool alive = (*lit)->draw(ticks, userInput);
	if (alive) {
	  ++lit;
	} else {
	  lit = mit->second.erase(lit);
	}
      }
    }
    pre_ticks = ticks;
    userInput.keys_sys.clear();
    userInput.sdl_keys_sys.clear();
    userInput.sdl_mods_sys.clear();

    // o^Ă֐̎s
    if (callback) {
      callback(ticks);
    }
    SDL_Flip(screen);
    unlock();

    SDL_Delay(1000 / FPS);
  }
  return 0;
}


void SDL_Video::registerEventHandler(call_t function) {
  callback = function;
}


SDL_Video::SDL_Video(void)
  : SDL_Base(),
    thread(NULL), titleName(NULL), iconSurface(NULL), active_ticks(0) {
  if (!initialized) {
    pre_ticks = SDL_GetTicks();
    wait_msec = wait_msec_max;
    mutex = SDL_CreateMutex();
    fullscreen = false;
    initialized = true;
  }
}


SDL_Video::~SDL_Video(void) {
  if (initialized) {
    activate(false);
    SDL_DestroyMutex(mutex);

    if (titleName) {
      delete [] titleName;
    }

    if (iconSurface) {
      SDL_FreeSurface(iconSurface);
    }
    initialized = false;
  }
}


void SDL_Video::lock(void) {
  SDL_LockMutex(mutex);
}


void SDL_Video::unlock(void) {
  SDL_UnlockMutex(mutex);
}


void SDL_Video::activate(bool on) {
  if (activated == on) {
    return;
  }

  if (!activated) {
    if (SDL_InitSubSystem(SDL_INIT_VIDEO) < 0) {
      throw SDL_Exception();
    }
    if (iconSurface) {
      SDL_WM_SetIcon(iconSurface, NULL);
    }
    screen = createScreen();
    active_ticks = SDL_GetTicks();
    if (screen) {
      // \XVpXbh̋N
      if (!thread) {
	activated = true;
	thread = SDL_CreateThread(SDL_Video::updateThread, this);
      }
      if (titleName) {
	SDL_WM_SetCaption(titleName, NULL);
      }
    }
  } else {
    // \XVpXbh̏I҂
    lock();
    activated = false;
    unlock();
    if (thread) {
      SDL_WaitThread(thread, NULL);
      thread = NULL;
    }
    SDL_QuitSubSystem(SDL_INIT_VIDEO);
    active_ticks = 0;
  }
}


void SDL_Video::setTitle(const char *title, const char *icon) {
  if (titleName) {
    delete [] titleName;
  }
  if (title) {
    titleName = new char [strlen(title) + 1];
    sprintf(titleName, "%s", title);
  }

  if (iconSurface) {
    SDL_FreeSurface(iconSurface);
  }
  if (icon) {
    iconSurface = SDL_LoadBMP(icon);
  }
}


void SDL_Video::autoHideCursor(int waitMsec) {
  wait_msec_max = waitMsec;
  wait_msec = wait_msec_max;
}


void SDL_Video::blitSurface(SDL_Surface* surface,
			    const VXV::Rect& size, const VXV::Grid& pos) {
  SDL_Rect sdl_size, sdl_pos;
  sdl_size.x = size.x;
  sdl_size.y = size.y;
  sdl_size.w = size.w;
  sdl_size.h = size.h;
  sdl_pos.x = pos.x;
  sdl_pos.y = pos.y;
  SDL_BlitSurface(surface, &sdl_size, screen, &sdl_pos);
}


void SDL_Video::fillRect(const VXV::Rect& rect, unsigned long color) {
  Uint32 sdl_color = SDL_MapRGBA(SDL_Video::screen->format,
				 static_cast<Uint8>((color >> 24) & 0xff),
				 static_cast<Uint8>((color >> 16) & 0xff),
				 static_cast<Uint8>((color >>  8) & 0xff),
				 static_cast<Uint8>(color & 0xff));
  SDL_Rect sdl_rect;
  sdl_rect.x = rect.x;
  sdl_rect.y = rect.y;
  sdl_rect.w = rect.w;
  sdl_rect.h = rect.h;

  SDL_FillRect(screen, &sdl_rect, sdl_color);
}


unsigned long SDL_Video::getTicks(void) {
  if (active_ticks == 0) {
    return 0;
  }
  return (SDL_GetTicks() - active_ticks);
}


void SDL_Video::changeFocus(void) {
  if ((input_index < 0) ||
      (input_index >= static_cast<int>(inputList.size()))) {
    input_index = 0;
  }

  inputList[input_index]->endFocus();
  if (++input_index >= static_cast<int>(inputList.size())) {
    input_index = 0;
  }
  inputList[input_index]->beginFocus();
}


void SDL_Video::delInputComponent(ComponentInterface* component) {
  std::vector<FocusComponentInterface*>::iterator it
    = find(inputList.begin(), inputList.end(), component);
  if (it != inputList.end()) {
    int del_index = inputList.begin() - it;
    if (input_index == del_index) {
      changeFocus();
      --input_index;
    } else if (input_index > del_index) {
      --input_index;
    }
    inputList.erase(it);

    if (input_index < 0) {
      input_index = inputList.empty() ? 0 : inputList.size() -1;
    }
  }
}


void SDL_Video::toggleFocus(void) {
  if (inputList.empty()) {
    return;
  }
  changeFocus();
}


void SDL_Video::setFocus(FocusComponentInterface* component) {
  std::vector<FocusComponentInterface*>::iterator it
    = find(inputList.begin(), inputList.end(), component);
  if (it != inputList.end()) {
    inputList[input_index]->endFocus();
    input_index = it - inputList.begin() -1;
    changeFocus();
  }
}
