/*
  g嗦w肵čĕ`悷r[
  Satofumi KAMIMURA
  $Id$
*/

#include "viewComponent.h"
#include "deleteObjects.h"


ViewComponent::ViewComponent(const VXV::Rect& range, double magnify) {
  w = range.w;
  h = range.h;
  position = VXV::Grid(0, 0);

  draw_range = range;
  draw_magnify = magnify;
}


ViewComponent::~ViewComponent(void) {
  clear();
}


bool ViewComponent::draw(unsigned long ticks, const UserInput& ui) {

  BasicDrawInterface::setDrawPosition(position, draw_range, draw_magnify);
  for (std::list<BasicDrawInterface*>::iterator it = objs.begin();
       it != objs.end(); ++it) {
    if (*it) {
      (*it)->draw();
    }
  }
  return true;
}


ViewComponent& ViewComponent::updateMagnify(double magnify) {
  draw_magnify = magnify;

  return *this;
}


ViewComponent& ViewComponent::setViewToRangeGrid(const VXV::Grid& view_grid,
						 const VXV::Grid& range_grid) {
  int left = static_cast<int>(rint(view_grid.x - range_grid.x / draw_magnify));
  int top = static_cast<int>(rint(view_grid.y - range_grid.y / draw_magnify));
  updateViewPosition(VXV::Grid(left, top));

  return *this;
}


ViewComponent& ViewComponent::updateViewPosition(const VXV::Grid& pos) {
  draw_range.x = pos.x;
  draw_range.y = pos.y;

  return *this;
}


ViewComponent& ViewComponent::updateViewSize(const VXV::Rect& size) {
  draw_range.w = size.w;
  draw_range.h = size.h;

  return *this;
}


ViewComponent& ViewComponent::clear(void) {
  for_each(objs.begin(), objs.end(), DeleteObjects());
  objs.clear();

  return *this;
}


ViewComponent& ViewComponent::add(BasicDrawInterface* obj) {
  objs.push_back(obj);

  return *this;
}


void ViewComponent::del(BasicDrawInterface* obj) {
  std::list<BasicDrawInterface*>::iterator it = find(objs.begin(),
						     objs.end(), obj);
  if (it != objs.end()) {
    delete *it;
    *it = NULL;
    objs.erase(it);
  }
}
