/*
  j^p̈
  Satofumi KAMIMURA
  $Id$
*/

#include "parseArgs.h"
#include <stdio.h>
#include <string>


#ifndef LogFile
#define LogFile "logfile.xml"
#endif
#ifndef EnvFile
#define EnvFile "envfile.env"
#endif

static bool isHelpPrinted = false;


static void printHelp(void) {
  printf("\n"
	 "----- Monitor Library -----\n"
	 "Common Options:\n"
	 "-h,--help 		Display this information\n"
	 "-p,--playback		Run playback mode using logfile.xml\n"
	 "--nolog 		No output monitor log\n"
	 "-l [logfile], --log [logfile]\n"
	 "		 	Run playback mode using [logfile]\n"
	 "-s,--simulator  	Connect to each device's simulator\n"
	 "-fs			Full screen mode\n"
	 "\n");
}


int Monitor::parseArgs(char*& logfile, char*& envfile,
		       int argc, char *argv[]) {
  logfile = LogFile;
  envfile = EnvFile;
  bool simulator = false;
  bool playback = false;
  bool help = false;
  bool nolog = false;

  for (int i = 0; i < argc; ++i) {
    if (!strcmp("-s", argv[i]) || !strcmp("--simulator", argv[i])) {
      simulator = true;

    } else if (!strcmp("-p", argv[i]) || !strcmp("--playback", argv[i])) {
      playback = true;

    } else if (!strcmp("-l", argv[i]) || !strcmp("--log", argv[i])) {
      playback = true;
      if (i+1 < argc) {
	logfile = argv[++i];
      }
    } else if (!strcmp("-h", argv[i]) || !strcmp("--help", argv[i])) {
      help = true;

    } else if (!strcmp("--nolog", argv[i])) {
      nolog = true;

    } else {
      envfile = argv[i];
    }
  }
  if (help && !isHelpPrinted) {
    printHelp();
    isHelpPrinted = true;
  }
  if (nolog) {
    logfile = NULL;
  }

  if (playback) {
    return Playback;
  }
  return (simulator) ? Simulator : RealDevice;
}
