#ifndef SCREEN_TASK_H
#define SCREEN_TASK_H

/*!
  \file
  \brief XN[̕`揈
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "vmonitor.h"
#include "checkBoxComponent.h"
#include <set>


/*!
  \brief ʂ̐^XN
*/
class ScreenTask : public TaskInterface {
  enum {
    MiniFontPx = 12,
    LogFontPx = 18,

    FrameHeight = 108,
    MiniMapWidth = FrameHeight * 640 / 480,
    MiniInfoWidth = FrameHeight * 140 / 100,
    LineWidth = 2,

    LogLevel = 1,
    LogLevelFore = 2,

    MiniMap_X = LineWidth,
    MiniInfo_X = MiniMap_X + MiniMapWidth + LineWidth,
    MiniCmd_X = MiniInfo_X + MiniInfoWidth + LineWidth,

    INVALID_LAYER_ID = 0,
    TEXT_LAYER = 1,
    GRAPHIX_LAYER = 2,
    ALL_LAYER = 3,

    MiniScrMagnify = 10,
  };
  WindowInterface* win;
  TTF_Draw* ttf;
  vmonitor* mon;
  FillSurface* main_back;
  FillSurface* under_back;
  Uint32 ticks;
  bool isActivated;
  bool component_created;
  bool pause_next;
  bool pause_locked;

  DrawSurface* msec_text;
  DrawSurface* pos_text;
  DrawSurface* pause_text;
  DrawSurface* scroll_text;
  FillSurface* v_line;
  FillSurface* h_line_1;
  FillSurface* h_line_2;
  LabelComponent* msec_label;
  LabelComponent* pos_label;
  LabelComponent* pause_label;
  ViewComponent* main_view;
  ViewComponent* user_view;
  ViewComponent* mini_view;
  ContLineDraw* body_lines;
  ScrollAreaComponent* debug_area;
  ComboBoxComponent* crd_cmb;
  CheckBoxComponent* scroll_checkbox;

  double view_magnify;
  VXV::Grid view_center;
  VXV::Grid grid_center;
  bool no_scroll;

  bool debug_area_clear;
  unsigned long layer_index;
  static std::vector<BasicDrawInterface*> graphix_groups;
  static std::set<unsigned long> delete_index;
  static std::map<unsigned long,BasicDrawInterface*> text_map;
  static std::map<unsigned long,BasicDrawInterface*> graphix_map;

  std::deque<VXV::Grid> body_original;
  std::vector<CoordinateCtrl::polygon_t> env_polygons;
  std::deque<VXV::Grid> mini_body;
  std::deque<VXV::Grid> scr_rect;

  void updateView(void);
  void rotatePoint(VXV::Grid& point, double radian);
  void drawRunGrid(const VXV::Position& offset);
  void drawRobotBody(const VXV::Position& bodyPos, const VXV::Direction& diff);
  void drawEnvironment(const VXV::Position& pos_diff,
		       const VXV::Position& diff);
  void drawObjects(void);
  int printf(ScrollAreaComponent* area, const char* fmt, va_list ap);
  void userInputHandle(UserInput::userInput_t& ui);
  void drawRobotInfo(const VXV::Position& bodyPos);
  void handlePauseInput(UserInput::userInput_t& ui);
  void drawMiniMap(VXV::Position& bodyPos);
  void handleCrdSelectInput(void);

public:
  ScrollAreaComponent* command_log;

  /*!
    \brief w̃RXgN^

    \param winObj [i] EBhEIuWFNg
    \param ttfObj [i] TTFIuWFNg
  */
  ScreenTask(WindowInterface* winObj, TTF_Draw* ttfObj);
  ~ScreenTask(void);

  void init(void);
  void recv(void) {}
  void exec1msec(unsigned long total_msec) {}
  void send(void);
  bool updatePosition(void) { return false; }
  VXV::Position3D getBodyPosition(const VXV::Position3D& position) {
    return VXV::Position3D();
  }

  /*!
    \brief ʂ̕\
  */
  void show(void);

  /*!
    \brief ʂ̔\
  */
  void hide(void);

  /*!
    \brief ʓ̕\g嗦w

    \param magnify [i] g嗦
  */
  void updateViewMagnify(double magnify);

  /*!
    \brief `撆SXV

    \param center [i] `̒Sʒu
  */
  void setViewCenter(VXV::Grid& center);

  /*!
    \brief IuWFNg̍XV

    \param objs [i] |SQ
  */
  void setEnvironment(const std::vector<CoordinateCtrl::polygon_t>& objs);

  /*!
    \brief `IuWFNg̍폜

    \param index [i] 폜pCfbNX
  */
  void clear(unsigned long index);

  /*!
    \brief _Q̕`

    \param points [i] _Q
    \param color [i] F
    \param width [i] _̑傫
    \return 폜pCfbNX
  */
  unsigned long setPoints(const std::vector<VXV::Grid3D>& points,
			  unsigned long color, int width = 1);

  /*!
    \brief ̕`

    \param p0 [i] n_
    \param p1 [i] I_
    \param color [i] F
    \return 폜pCfbNX
  */
  unsigned long setLine(const VXV::Grid3D& p0, const VXV::Grid3D& p1,
			unsigned long color);

  /*!
    \brief Q̕`

    \param points [i] A\_Q
    \param color [i] F
    \return 폜pCfbNX
  */
  unsigned long setContLine(const std::deque<VXV::Grid3D>& points,
			    unsigned long color);

  unsigned long setCircle(const VXV::Grid& center, int r, unsigned long color);

  /*!
    \brief ̕`

    \todo Fwł悤ɂ

    \param text [i] `悷镶
    \param pos [i] `ʒu
    \param pxSize [i] TCY
    \param pin [i] WnɌŒ肷ꍇ true
    \param color [i] F
    \param back [i] wiF
  */
  unsigned long setText(const char* text, const VXV::Grid& pos, int pxSize,
			bool pin, unsigned long color, unsigned long back);

  int consolePrintf(const char* fmt, va_list ap);
  int commandLogPrintf(const char* fmt, ...);
  void activate(void);

  void scrollWithRobot(bool on);
};

#endif /* !SCREEN_TASK_H */
