#ifndef T_RUN_CTRL_SIMULATOR_H
#define T_RUN_CTRL_SIMULATOR_H

/*!
  \file
  \brief tRunCtrl ̃V~[gNX
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "taskInterface.h"
#include "nodeAccess.h"
#include "structTables.h"
#include "tcpipServer.h"
//#include "delaiedTcpipDevice.h"
#include "ticksPositionInterface.h"
#include <deque>


/*!
  \brief s䃂W[̃V~[g^XN
*/
class tRunCtrl_Simulator : public TaskInterface {
  friend class mRunCtrl;

  enum { SciPort = 0 };
  TcpipServer* server;
  //DelaiedTcpipDevice* con;
  TcpipDevice* con;
  nodeInfo_t node;
  runCtrl_t tbl;

  class TicksPosition : public VXV::TicksPositionInterface {
    friend class tRunCtrl_Simulator;
    friend class mRunCtrl;

    std::deque<VXV::Position3D> pos_deque;
    unsigned long first_ticks;
    unsigned long offset_length;
    long ticksDiff;
    void add(const VXV::Position3D& pos, unsigned long total_msec);
    void adjustOwnTicks(unsigned long setTicks, unsigned long ticks);
    unsigned long adjustTicksDiff(unsigned long ticks) const;

  public:
    TicksPosition(void);
    ~TicksPosition(void);
    VXV::Position3D getPosition(unsigned long ticks) const;
    void clear(void);
    void set_dataLength(unsigned long msec);
  };
  TicksPosition ticksPos;

public:
  tRunCtrl_Simulator(void);
  ~tRunCtrl_Simulator(void);
  void init(void);
  void recv(void);
  void exec1msec(unsigned long total_msec);
  void send(void) {}
  bool updatePosition(void);

  /*!
    \brief V~[^➑̈ʒuXV

    \param position [i] XVʒu
  */
  void setLocalPosition(const VXV::Position3D& position);
  VXV::Position3D getBodyPosition(const VXV::Position3D& position);
};

#endif /* !T_RUN_CTRL_SIMULATOR_H */
