#ifndef URG_SIMULATOR_H
#define URG_SIMULATOR_H

/*!
  \file
  \brief URG ZTfoCX̃V~[gNX
  
  \author Satofumi KAMIMURA
  
  $Id$
*/

#include "taskInterface.h"
//#include "delaiedTcpipDevice.h"
#include "tcpipServer.h"
#include "coordinateCtrl.h"
#include <list>

class URGCtrl;


/*!
  \brief URG ZTfoCX̃V~[gNX

  \todo params.rotate_direction K؂ɏ
*/
class URG_Simulator : public TaskInterface {
  TcpipServer* server;
  class ScanInfo {
  public:
    ScanInfo(void);
    ~ScanInfo(void);
    TcpipDevice* con;
    URGCtrl* obj;
    int pre_index;
    unsigned long raw_timestamp;
    long length[1024];
    bool cmd_handled;
    bool now_timeAdjustMode;
  };
  URGCtrl* pre_registered;
  std::list<ScanInfo*> sim_urgs;
  bool enable_timestamp;

  typedef CoordinateCtrl::polygon_t crd_polygon_t;
  std::vector<crd_polygon_t> env_polygons;

  void urgDeviceResponse(URG_Simulator::ScanInfo& urg);
  void urgDeviceSimulator(URG_Simulator::ScanInfo& urg,
			  unsigned long total_msec);
  bool checkCmdLength(TcpipDevice* con, int require_size);
  void replyVersionInfo(URG_Simulator::ScanInfo& urg);
  void replyAdjustTimestamp(URG_Simulator::ScanInfo& urg);
  void replyDataRequest(URG_Simulator::ScanInfo& urg);
  char decodeByte(char ch);
  void judgeSenseArea(URG_Simulator::ScanInfo& urg, bool isHandstand,
		      int from_index, int to_index);

public:
  URG_Simulator(void);
  ~URG_Simulator(void);
  void init(void);
  void recv(void);
  void exec1msec(unsigned long total_msec);
  void send(void) {}
  bool updatePosition(void) { return false; }
  VXV::Position3D getBodyPosition(const VXV::Position3D& position) {
    return VXV::Position3D();
  }

  /*!
    \brief URGCtrl IuWFNg̎󂯎

    \param urg_obj [i] URGCtrl IuWFNg
  */
  void setURGObject(URGCtrl* urg_obj);

  /*!
    \brief URG ̎ނw

    \param type [i] ނ
  */
  void setURGType(const char* type);

  /*!
    \brief ̎󂯎
  */
  void setEnvironment(const std::vector<crd_polygon_t>& objs);
};

#endif /* !URG_SIMULATOR_H */
