#ifndef V_MONITOR_H
#define V_MONITOR_H

/*!
  \file
  \brief VXV j^
  
  \author Satofumi KAMIMURA
  $Id$

  \todo hLg쐬
*/

#include "guiCtrl.h"
#include "monitorTask.h"
#include "logCtrl.h"
#include "environmentManage.h"
#include "propertyInfo.h"
#include "monitorMode.h"


namespace VXV {
  enum {
    InvalidLayerId = 0,
    TextLayer = 1,
    GraphixLayer = 2,
    AllLayer = 3,
  };
}


class ScreenTask;

/*!
  \brief j^̊ǗNX
*/
class vmonitor : public SDL_Base {
  friend class MonitorTask;
  friend class mRunCtrl;
  friend class mURGCtrl;
  friend class ScreenTask;

  WindowInterface* win;
  TTF_Draw* ttf;
  MonitorTask* task;
  ScreenTask* scr;
  int task_count;
  int mode;
  bool is_pause;
  const char* fname;
  LogCtrl* log;
  EnvironmentManage* env;
  SDL_sem* pause_sem;

  static std::string ttf_path;
  const char* getURGType(void);

  class VMonitorProperty : public PropertyInfo {
    void evaluate(void);
  public:
    std::string ttf_file;
    std::string urg_type;
    int crd_index;
  };
  VMonitorProperty* property;
  static void terminate(void);
  static vmonitor* obj;
  vmonitor(void);

public:
  ~vmonitor(void);

  /*!
    \brief IuWFNgԂ
  */
  static vmonitor* getObject(void);

  /*!
    \brief ڑ̎w

    \todo Lq

    \param argc [i] ̌
    \param argv [i] i[z
  */
  static int connect(int argc, char *argv[]);

  /*!
    \brief j^̓샂[hw

    \param monitorMode [i] 샂[h
    \param logfile [i] Ot@C
  */
  void setMonitorMode(int monitorMode, const char* logfile);

  /*!
    \brief j^̓샂[h擾

    \return 샂[h
  */
  static int getMonitorMode(void);

  /*!
    \brief ^CX^v̎擾
  */
  static unsigned long getTicks(void);

  /*!
    \brief ^XN̓o^

    \param monitor_task [i] ^XN
  */
  void add(TaskInterface* monitor_task);

  /*!
    \brief ^XN̍폜

    \param monitor_task [i] ^XN
  */
  void del(TaskInterface* monitor_task);

  /*!
    \brief ʂ̕\
  */
  static void show(void);

  /*!
    \brief ʂ̔\
  */
  static void hide(void);

  /*!
    \brief ꎞ~
  */
  static void pause(void);

  /*!
    \brief ĊJ
  */
  static void start(void);

  /*!
    \brief Ԃ̐is{ύX

    \param magnify [i] Ԃ̐is{
  */
  static void setTimeMagnify(double magnify);

  /*!
    \brief ʓ̕\g嗦w

    \param magnify [i] g嗦
  */
  static void setViewMagnify(double magnify);

  /*!
    \brief `IuWFNg̍폜

    \todo Lq

    \param layer [i] 폜pCfbNX
  */
  static void clear(unsigned long layer = 3);

  /*!
    \brief _Q̕`

    \todo Lq

    \param points [i] _Q
    \param color [i] F
    \param r [i] _̑傫
    \return 폜pCfbNX
  */
  static unsigned long drawPoints(const std::vector<VXV::Grid3D>& points,
				  unsigned long color = White, int r = 1);

  /*!
    \brief ̕`

    \todo Lq

    \param p0 [i] n_
    \param p1 [i] I_
    \param color [i] F
    \return 폜pCfbNX
  */
  static unsigned long drawLine(const VXV::Grid3D& p0, const VXV::Grid3D& p1,
				unsigned long color = White);

  /*!
    \brief Q̕`

    \todo Lq

    \param points [i] A\_Q
    \param color [i] F
    \return 폜pCfbNX
  */
  static unsigned long drawContLine(const std::deque<VXV::Grid3D>& points,
				    unsigned long color = White);

  static unsigned long drawCircle(const VXV::Grid& center, int r,
				  unsigned long color = White);

  /*!
    \brief ̕`

    \todo Fwł悤ɂ

    \param text [i] `悷镶
    \param pos [i] `ʒu
    \param pxSize [i] TCY
    \param pin [i] WnɌŒ肷ꍇ true
    \param color [i] F
    \param background [i] wiF
  */
  static unsigned long drawText(const char* text, const VXV::Grid& pos,
				int pxSize = 16, bool pin = false,
				unsigned long color = White,
				unsigned long background = Black);

  static int printf(const char* fmt, ...);

  static void scrollWithRobot(bool on);
};

#endif /* !V_MONITOR_H */
