# Makefile for SH7045F suffix rules
# Satofumi KAMIMURA
# $Id: rules.mak,v 1.1 2004/06/09 01:07:20 satofumi Exp $

# Compile command settings
CC_FOR_BUILD = ${ARCH}-gcc
CXX_FOR_BUILD = ${ARCH}-g++
AS_FOR_BUILD = ${ARCH}-as
LD_FOR_BUILD = ${ARCH}-ld
AR_FOR_BUILD = ${ARCH}-ar
OBJ_COPY_FOR_BUILD = ${ARCH}-objcopy
OBJ_DUMP_FOR_BUILD = ${ARCH}-objdump

# Suffix rules
.SUFFIXES :
.SUFFIXES : .rom .mot .dis .cof .o .h .c .S

.c.o:
	${CC_FOR_BUILD} ${CFLAGS} -c $<

.S.o:
	${CC_FOR_BUILD} ${CFLAGS} -c $<

.o.cof:
	${CC_FOR_BUILD} ${LDFLAGS} -T ${LD_LOAD} $^ -o $@ ${LDLIBS}

.cof.mot:
	${OBJ_COPY_FOR_BUILD} --adjust-vma=0 --srec-forceS3 -O srec $< $@
	@chmod a-x $@

.cof.dis:
	${OBJ_DUMP_FOR_BUILD} -D --disassemble-zeroes $< > $@

.o.rom:
	${CC_FOR_BUILD} ${LDFLAGS} -T ${LD_ROM} $^ -o $@.tmp ${LDLIBS}
	${OBJ_COPY_FOR_BUILD} --adjust-vma=0 --srec-forceS3 -O srec $@.tmp $@
	@${RM} $@.tmp
	@chmod a-x $@
.o.mot:
	${CC_FOR_BUILD} ${LDFLAGS} -T ${LD_LOAD} $^ -o $@.tmp ${LDLIBS}
	${OBJ_COPY_FOR_BUILD} --adjust-vma=0 --srec-forceS3 -O srec $@.tmp $@
	@${RM} $@.tmp
	@chmod a-x $@

(%): %
	${AR_FOR_BUILD} ${ARFLAGS} $@ $<
