#ifndef CONNECTION_DEVICE_H
#define CONNECTION_DEVICE_H

/*!
  \file
  \brief foCXڑ̃C^[tF[X

  \author Satofumi KAMIMURA

  $Id$
*/

#include "ringBufferTemplate.h"
#include <exception>
#include <string>


/*!
  \brief ʐM̃C^[tF[X
*/
class ConnectionDevice {
  std::string device_name;
  long baudrate_value;

  /*!
    \brief ڑ

    \param device [i] ڑfoCX
    \param baudrate [i] ڑ{[[g
    \retval 0 I
    \retval ߂l < 0 G[
  */
  virtual int raw_connect(const char* device, long baudrate) = 0;

  /*!
    \brief ؒf
  */
  virtual void raw_disconnect(void) = 0;
  virtual int raw_setBaudrate(long baudrate) = 0;

  /*!
    \brief M

    \param data [i] f[^
    \param len [i] f[^TCY
    \retval ߂l >= 0 Mf[^TCY
    \retval ߂l < 0 G[
  */
  virtual int raw_send(const char* data, int len) = 0;
  virtual void raw_flush(void) = 0;
  virtual void raw_check(int size, long timeout = 0) = 0;
  void check(int size, long timeout = 0);
  ConnectionDevice(const ConnectionDevice& rhs);

protected:
  enum { BufferSize = 4096 };
  RingBuffer<char> *recv_buffer; /*!< Mobt@ */

public:
  enum {
    NotConnected = -2,
    DeviceOpenFail = -3,
    InvalidBaudrate = -4,
    BaudrateAdjustFail = -5,
    RecvTimeout = -6,
    LibraryInitFail = -7,
    RetryFail = -8,
    FailCheckVersion = -9,
  };

  /*!
    \brief obt@TCYw̃RXgN^

    \param buffer_size [i] obt@TCY
  */
  ConnectionDevice(int buffer_size = BufferSize-1);
  virtual ~ConnectionDevice(void);

  /*!
    \brief G[bZ[WԂ
  */
  virtual const char* what(void) = 0;

  /*!
    \brief ڑ

    \param device [i] ڑfoCX
    \param baudrate [i] ڑ{[[g
    \retval 0 I
    \retval ߂l < 0 G[
  */
  int connect(const char* device, long baudrate);

  /*!
    \brief ؒf
  */
  void disconnect(void);

  /*!
    \brief {[[g̕ύX

    \param baudrate {[[g
    \retval 0 I
    \retval ߂l < 0 G[
  */
  int setBaudrate(long baudrate);

  /*!
    \brief ڑς݂ǂԂ

    \retval true ڑς
    \retval false ؒf
  */
  virtual bool isConnected(void) = 0;

  /*!
    \brief f[^̃tbV
  */
  void flush(void);

  /*!
    \brief M

    \param data [i] Mf[^
    \param len [i] f[^TCY
    \retval ߂l > 0 MoCg
    \retval ߂l < 0 G[
  */
  int send(const char* data, int len);

  /*!
    \brief M

    \param data [o] Mobt@
    \param maxlen [i] Mobt@̍ő啝
    \param timeout [i] ^CAEg [msec]
    \retval ߂l > 0 MoCg
    \retval ߂l < 0 G[
  */
  virtual int recv(char* data, int maxlen, long timeout = 0);

  /*!
    \brief obt@̏ԂύXɎM

    Mobt@̓e炷ƂȂf[^擾

    \param data [o] Mobt@
    \param maxlen [i] Mobt@̍ő啝
    \retval ߂l > 0 MoCg
    \retval ߂l < 0 G[
  */
  int copy(char *data, int maxlen);

  /*!
    \brief ǂݏo\ȃf[^TCYԂ

    \retval ǂݏo\ȃf[^TCY
  */
  int size(void);

  /*!
    \brief ǉŎM\ȃf[^TCYԂ

    \retval ǉŎM\ȃf[^TCY
  */
  int capacity(void);

  /*!
    \brief ڑfoCXԂ

    \retval ڑfoCX
  */
  const char* getDevice(void);

  /*!
    \brief ڑ{[[gԂ

    \retval ڑ{[[g
  */
  long getBaudrate(void);
};


/*!
  \brief ConnectionDevice ̗ONX
*/
class ConnectionDevice_Exception : public std::exception {
  std::string error_message;

public:
  /*!
    \brief ڑÕRXgN^

    \param message [i] OG[bZ[W
  */
  ConnectionDevice_Exception(const char* message) : error_message(message) {}
  virtual ~ConnectionDevice_Exception(void) throw () {}

  /*!
    \brief O̕Ԃ
  */
  virtual const char* what(void) const throw() {
    return error_message.c_str();
  }
};

#endif /* !CONNECTION_DEVICE_H */
