#ifndef TCPIP_DEVICE_H
#define TCPIP_DEVICE_H

/*!
  \file
  \brief TCP/IP ʐM

  \author Satofumi KAMIMURA

  $Id$
*/

#include "sdlBase.h"
#include "connectionDevice.h"
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
#include <SDL_net.h>
#endif


/*!
  \brief TCP/IP ʐM
*/
class TcpipDevice : protected SDL_Base, public ConnectionDevice {
  friend class TcpipServer;

#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  TCPsocket tcp_socket;
  SDLNet_SocketSet own_set;
  static bool initialized;
  static int sockets_num;
  static int sockets_max;
  static SDLNet_SocketSet socket_set;
#endif
  static void resizeSocketSet(void);
  void initialize(bool eachCheckSocket);

  int raw_connect(const char* host, long port);
  void raw_disconnect(void);
  int raw_setBaudrate(long baudrate);
  int raw_send(const char* data, int len);
  void raw_flush(void);
  void raw_check(int size, long timeout);
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  void addSocket(TCPsocket socket);
  void delSocket(TCPsocket socket);
  static int checkAllSockets(long timeout = 0);
#endif

public:
  /*!
    \brief obt@TCYw̃RXgN^

    \param buffer_size [i] obt@TCY
    \param eachCheckSockets [i] M`FbN\Pbgɍsꍇ true
  */
  TcpipDevice(int buffer_size, bool eachCheckSockets = true);

  /*!
    \brief M`FbN@w̃RXgN^

    \param eachCheckSockets [i] M`FbN\Pbgɍsꍇ true
  */
  TcpipDevice(bool eachCheckSockets = true);
#if !HAVE_CONFIG_H || HAVE_LIBSDL_NET
  /*!
    \brief SDL_net 󂯎RXgN^

    \param net_socket [i] SDL_net ̐ڑIuWFNg
    \param eachCheckSockets [i] M`FbN\Pbgɍsꍇ true
    \param buffer_size [i] obt@TCY
  */
  TcpipDevice(TCPsocket net_socket, bool eachCheckSockets = true,
	      int buffer_size = BufferSize-1);
#endif
  virtual ~TcpipDevice(void);

  const char* what(void);
  bool isConnected(void);

  /*!
    \brief M`FbN

    \param timeout [i] ^CAEg [msec]
    \retval ߂l > 0 Mf[^
    \retval 0 Mf[^Ȃ
    \retval ߂l < 0 G[
  */
  int checkSocket(long timeout = 0);
};

#endif /* !TCPIP_DEVICE_H */
