#!/usr/bin/env ruby
# Satofumi KAMIMURA
# $Id$


class Pair
  attr_accessor :x, :y
  def initialize(x, y)
    @x = x
    @y = y
  end
end


def rotate(x, y, t)
  x0 = x * Math.cos(t) - y * Math.sin(t)
  y0 = x * Math.sin(t) + y * Math.cos(t)
  return Pair.new(x0.to_i, y0.to_i)
end


# ǡ
class Box
  attr_accessor :x0, :y0, :x1, :y1
  def initialize(x0, y0, x1, y1)
    @x0 = x0
    @y0 = y0
    @x1 = x1
    @y1 = y1
  end

  def output(sx, sy, st);
    x0 = +(@x0 - sx) * 10
    y0 = -(@y0 - sy) * 10
    x1 = +(@x1 - sx) * 10
    y1 = -(@y1 - sy) * 10
    p0 = rotate(x0, y0, st)
    p1 = rotate(x1, y1, st)
    print "(polygon (", p0.x, ",", p0.y, ") (", p1.x, ",", p0.y, ") (", p1.x, ",", p1.y, ") (", p0.x, ",", p1.y, ") )\n"
  end
end


# ľǡ
class Line
  attr_accessor :n, :point
  def initialize(n, line_data)
    @n = n
    @point = [2 * n]
    @point = line_data.split(',')
  end

  def output(sx, sy, st)
    for i in 0...@n-1
      x0 = +(point[2*i].to_i - sx) * 10
      y0 = -(point[2*i +1].to_i - sy) * 10
      x1 = +(point[2*(i+1)].to_i - sx) * 10
      y1 = -(point[2*(i+1) +1].to_i - sy) * 10
      p0 = rotate(x0, y0, st)
      p1 = rotate(x1, y1, st)
      print "(polygon (", p0.x, ",", p0.y, ") (", p1.x, ",", p1.y, ") ) "
    end
    print "\n"
  end

  def output_chain(sx, sy, st)
    print "(polygon "
    for i in 0...@n
      x0 = +(point[2*i].to_i - sx) * 10
      y0 = -(point[2*i +1].to_i - sy) * 10
      p0 = rotate(x0, y0, st)
      print "(", p0.x, ",", p0.y, ") "
     end
    print ")", "\n"
  end
end


# ߥǡ
class Circle
  attr_accessor :x0, :y0, :x1, :y1
  def initialize(x0, y0, x1, y1)
    @x0 = x0
    @y0 = y0
    @x1 = x1
    @y1 = y1
  end

  def output(sx, sy, st);
    x0 = +(@x0 - sx) * 10
    y0 = -(@y0 - sy) * 10
    x1 = +(@x1 - sx) * 10
    y1 = -(@y1 - sy) * 10
    p0 = rotate(x0, y0, st)
    p1 = rotate(x1, y1, st)
    cx = (p0.x + p1.x) / 2
    cy = (p0.y + p1.y) / 2
    r = (cx - p0.x < p1.x - cx) ? cx - p0.x : p1.x - cx;
    print "(circle (", cx, ",", cy, ") ", r, " )\n"
  end
end


# Էϩν
def follwLineOutput(file, path, sx, sy, st)
  open(file + "_path.cpp", "w") { |io|
io.print <<-"EOB"
#include <runCtrl.h>
#include <vutils.h>
#include <deque>
#ifdef DRAW_PATH
#include <vmonitor.h>
#endif

void pathFollow(RunCtrl& run) {
  std::deque<VXV::Position> lines;

EOB

    t = 0.0
    pre_x = +(path.point[0].to_i - sx) * 10
    pre_y = -(path.point[1].to_i - sy) * 10
    for i in 0...path.n
      x0 = +(path.point[2*i].to_i - sx) * 10
      y0 = -(path.point[2*i +1].to_i - sy) * 10
      p0 = rotate(x0, y0, st)
      
      t = (Math.atan2(p0.y - pre_y, p0.x - pre_x)/(2.0*Math::PI)*360).to_i
      pre_x = x0
      pre_y = y0
      io.print "  lines.push_back(VXV::Position(",
               p0.x, ", ", p0.y, ", VXV::deg(", t.to_i, ")));\n"
    end
io.print <<-"EOB"

#ifdef DRAW_PATH
  std::deque<VXV::Grid3D> draw_lines;
  draw_lines.assign(lines.begin(), lines.end());
  vmonitor::drawContLine(draw_lines, White);
#endif

  int follow_r = run.getCurveRadius();
  run.followLine(lines.front());
  while (lines.size() > 0) {
    VXV::followLinesUpdate(run, lines, follow_r);
    VXV::Delay(100); // Do something
  }
  run.stop();
}
EOB
  }
end


# Ϸ̤γǼ
$sx = 0
$sy = 0
$st = 0.0
$box = []
$poly = []
$polygon = []
$circle = []
$path = nil


def parse_obj(io)
  while line = io.gets('.')
    case line.gsub!(/[\n\t ]/, '')

    when /poly\('blue',.+?\[(\d+),(\d+),(\d+),(\d+)\]/ then
      # ޥåפˤܥåȰ
      $sx = $1.to_i
      $sy = $2.to_i
      $st = Math.atan2($4.to_i - $2.to_i, $3.to_i - $1.to_i)

    when /box\('red','',(\d+),(\d+),(\d+),(\d+)/
      # 
      $box.push(Box.new($1.to_i, $2.to_i, $3.to_i, $4.to_i))

    when /poly\('red','',(\d+),\[(.+?)\]/
      # ľ
      $poly.push(Line.new($1.to_i, $2))

    when /polygon\('red','',(\d+),\[(.+?)\]/
      # Ĥľ
      $polygon.push(Line.new($1.to_i, $2))

    when /oval\('red','',(\d+),(\d+),(\d+),(\d+)/
      # 
      $circle.push(Circle.new($1.to_i, $2.to_i, $3.to_i, $4.to_i))

    when /poly\('green','',(\d),\[(.+?)\]/
      # ɽϩľ
      $path = Line.new($1.to_i, $2)
    end
  end
end


def parse_edf(io)
  if io.gets.chomp =~ /^EPS-draw Output level 5$/
    n = io.gets.to_i
    for i in 0...n

      line_1st = io.gets
      line_2nd = io.gets
      if !line_1st || !line_2nd
        break
      end

      if line_1st.chomp =~ /(\d),(\d),(\d),(\d),(\d),(\d),(\d),(\d),(\d)/
        if $4.to_i == 1 && $1.to_i == 0
          # ޥåפˤܥåȰ
          if line_2nd =~ /(\d+),(\d+),(\d+),(\d+)/
            $sx = $1.to_i
            $sy = $2.to_i
            $st = Math.atan2($4.to_i - $2.to_i, $3.to_i - $1.to_i)
          end
        end

        if $4.to_i == 2
          if $1.to_i == 3
            # 
            if line_2nd =~ /(\d+),(\d+),(\d+),(\d+)/
              $box.push(Box.new($1.to_i, $2.to_i, $3.to_i, $4.to_i))
            end
            
          elsif $1.to_i == 0
            # ľ
            $poly.push(Line.new((line_2nd.count(',')+1)/2, line_2nd))
          end
        end
        
        if $4.to_i == 4 && $1.to_i == 0
          # ɽϩľ
          $path = Line.new((line_2nd.count(',')+1)/2, line_2nd)
        end
      end
    end
  end
end


fileName = ARGV[0]
open(fileName) { |io|

  if fileName =~ /\.edf$/i
    parse_edf(io)
  else
    parse_obj(io)
  end
}


# Էϩν
if $path != nil
  follwLineOutput(File.basename(ARGV[0], ".obj"), $path, $sx, $sy, $st)
end

# Ķν
$box.each { |obj|
  obj.output($sx, $sy, $st)
}

$poly.each { |obj|
  obj.output($sx, $sy, $st)
}

$polygon.each { |obj|
  obj.output_chain($sx, $sy, $st)
}

#$circle.each { |obj|
#  obj.output($sx, $sy, $st)
#}
