/*
  Ǐ]֘A̕⏕֐
  Satofumi KAMIMURA
  $Id$
*/

#include "pathUtils.h"


typedef struct {
  // ax + by + c = 0
  double a, b, c;
} line_t;


static void createLine(line_t *line, const RC_Position& position) {
  line->a = cos(position.t.rad());
  line->b = -sin(position.t.rad());
  line->c =
    position.y * cos(position.t.rad()) - position.x * sin(position.t.rad());
}


RC_Position path::getNextLinePoint(const RC_Position& base,
				   const RC_Position& next,
				   int radius) {

  RC_Direction center = next.t - base.t;

  line_t first, second;
  createLine(&first, base);
  createLine(&second, next);

  double t = first.b * second.a - second.b * first.a;
  if (fabs(t) < 0.00001) {
    //printf("para\n");
    return base;		// s
  }
  double x = (second.a * first.c - first.a * second.c) / t;
  double y = (second.c * first.b - first.c * second.b) / t;

  //printf("%f, %f\n", x, y);

  double l = fabs(radius * sin(M_PI - center.rad() / 2));
  //printf("%d\n", (int)l);

  RC_Position change;
  change.x = (int)(x + l * -cos(base.t.rad()));
  change.y = (int)(y + l * -sin(base.t.rad()));
  change.t = base.t;

  //printf("%d, %d, %d\n", change.x, change.y, change.t.deg());
  //printf("\n");
  
  return change;
}


bool path::followLinesUpdate(RC_Coordinate& crd,
			     deque<RC_Position>& lines, int radius) {
  switch (lines.size()) {
  case 0:
    return false;
    break;
    
  case 1:
    if (crd.getLengthToLine(lines[0]) > 0) {
      lines.pop_front();
    }
    break;
    
  default:
    RC_Position next = path::getNextLinePoint(lines[0], lines[1], radius);
    if (crd.getLengthToLine(next) > 0) {
      lines.pop_front();
      crd.followLine(lines.front());
      //printf("line: %d, %d, %d\n",
      //lines.front().x, lines.front().y, lines.front().deg());
    }
    break;
  }
  
  return true;
}
