/*
 * 作成日: 2005/02/08
 */
package jp.co.kayo.gui;

import javax.swing.JLabel;
import javax.swing.ListModel;
import javax.swing.event.ListDataListener;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;


public class NodeListModel implements ListModel {
    private NodeList m_nodelist;
    
    NodeListModel(NodeList nodelist){
        m_nodelist = nodelist;
    }

    /**
     * @see javax.swing.ListModel#getSize()
     */
    public int getSize() {
        return m_nodelist.getLength();
    }

    /**
     * @see javax.swing.ListModel#getElementAt(int)
     */
    public Object getElementAt(int index) {
        Element e =(Element)m_nodelist.item(index);
        String ico = e.getAttribute("icon");
        return ico+e.getAttribute("name");
    }
    
    public Element getElement(int index) {
        if( index >=0 && index < m_nodelist.getLength()){
            Element e =(Element)m_nodelist.item(index);
            return e;
        }
        return null;
    }

    /**
     * @see javax.swing.ListModel#addListDataListener(javax.swing.event.ListDataListener)
     */
    public void addListDataListener(ListDataListener l) {
    }

    /**
     * @see javax.swing.ListModel#removeListDataListener(javax.swing.event.ListDataListener)
     */
    public void removeListDataListener(ListDataListener l) {
    }

}
