package jp.co.kayo.gui;

import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import javax.swing.event.TableModelListener;

/**
 * DOM対応テーブルモデルの結果
 * 
 * @author MasafumiTerazono
 * @version $Id: ResultDOMTableModel.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */

public class ResultDOMTableModel implements DOMTableModel {

    /**
     * ノードリスト
     */
    NodeList m_nodelist;

    /** タグネームの文字配列 */
    private String[] m_tagNames = null;

    /**
     * タグネームの配列とノードリストを受け取ったコンストラクタです。
     * 
     * @param tagNames
     *            タグネーム
     * @param nodelist
     *            ノードリスト
     */
    public ResultDOMTableModel(String[] tagNames, NodeList nodelist) {
        m_tagNames = new String[tagNames.length];
        System.arraycopy(tagNames, 0, m_tagNames, 0, m_tagNames.length);
        m_nodelist = nodelist;
    }

    /**
     * @see javax.swing.table.TableModel#isCellEditable(int, int)
     */
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    /**
     * @see javax.swing.table.TableModel#getColumnClass(int)
     */
    public Class getColumnClass(int columnIndex) {
        return String.class;
    }

    /**
     * @see javax.swing.table.TableModel#getColumnCount()
     */
    public int getColumnCount() {
        return m_tagNames.length;
    }

    /**
     * @see javax.swing.table.TableModel#getColumnName(int)
     */
    public String getColumnName(int columnIndex) {
        return m_tagNames[columnIndex];
    }

    /**
     * @see jp.co.qualica.client.swing.DOMTableModel#getRow(int)
     */
    public Element getRow(int rowIndex) {
        if (m_nodelist != null) {
            return (Element) m_nodelist.item(rowIndex);
        }

        return null;
    }

    /**
     * @see javax.swing.table.TableModel#getRowCount()
     */
    public int getRowCount() {
        if (m_nodelist != null) {
            return m_nodelist.getLength();
        }

        return 0;
    }

    /**
     * 
     * @see javax.swing.table.TableModel#setValueAt(java.lang.Object, int, int)
     */
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
    }

    /**
     * @see javax.swing.table.TableModel#getValueAt(int, int)
     */
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (m_nodelist != null) {
            Element element = (Element) m_nodelist.item(rowIndex);

            return element.getAttribute(m_tagNames[columnIndex]);
        }

        return null;
    }

    /**
     * @see javax.swing.table.TableModel#addTableModelListener(javax.swing.event.TableModelListener)
     */
    public void addTableModelListener(TableModelListener l) {
    }

    /**
     * @see javax.swing.table.TableModel#removeTableModelListener(javax.swing.event.TableModelListener)
     */
    public void removeTableModelListener(TableModelListener l) {
    }
}