package jp.co.kayo.io;

import java.util.logging.Level;
import java.util.logging.Logger;

/**
 * TODO 説明を定義してください。
 *
 * @author MasafumiTerazono
 * @version $Id: Log.java,v 1.1 2005/02/13 06:39:48 epepe Exp $
 */
public class Log {
    /**
     * 委譲しているLogインスタンス。
     */
    private Logger m_log = null;

    /**
     * Log生成時に指定されたClassを利用しています。
     *
     * @param log 委譲するLogのインスタンス
     */
    private Log(Logger log) {
        m_log = log;
    }

    /**
     * システムのデフォルトのロガーを返します。
     *
     * @return デフォルトのロガーのインスタンス。
     */
    public static Log logger() {
        return new Log(Logger.getLogger("W3G"));
    }

    /**
     * クラス名をカテゴリとしたロガーを返します。
     *
     * @param c クラス
     *
     * @return クラス名をカテゴリとしたロガー。
     */
    public static Log logger(Class c) {
        return new Log(Logger.getLogger(c.getName()));
    }

    /**
     * オブジェクトからクラス名を取得してロガーを返します。
     *
     * @param o オブジェクト。
     *
     * @return クラス名をカテゴリとしたロガー。
     */
    public static Log logger(Object o) {
        return new Log(Logger.getLogger(o.getClass().getName()));
    }

    /**
     * 任意の文字列をカテゴリとしたロガーを返します。
     *
     * @param s カテゴリ名。
     *
     * @return 指定されたカテゴリで生成されたロガー。
     */
    public static Log logger(String s) {
        return new Log(Logger.getLogger(s));
    }

    /**
     * @see org.apache.commons.logging.Log#isDebugEnabled()
     */
    public boolean isDebugEnabled() {
        return m_log.isLoggable(Level.FINER);
    }

    /**
     * @see org.apache.commons.logging.Log#isErrorEnabled()
     */
    public boolean isErrorEnabled() {
        return m_log.isLoggable(Level.FINE);
    }

    /**
     * @see org.apache.commons.logging.Log#isFatalEnabled()
     */
    public boolean isFatalEnabled() {
        return m_log.isLoggable(Level.SEVERE);
    }

    /**
     * @see org.apache.commons.logging.Log#isInfoEnabled()
     */
    public boolean isInfoEnabled() {
        return m_log.isLoggable(Level.INFO );
    }

    /**
     * @see org.apache.commons.logging.Log#isTraceEnabled()
     */
    public boolean isTraceEnabled() {
        return m_log.isLoggable(Level.FINEST);
    }

    /**
     * @see org.apache.commons.logging.Log#isWarnEnabled()
     */
    public boolean isWarnEnabled() {
        return m_log.isLoggable(Level.WARNING);
    }

    /**
     * @see org.apache.commons.logging.Log#debug(java.lang.Object)
     */
    public void debug(Object arg0) {
        if (isDebugEnabled()) {
            m_log.finer(arg0.toString());
        }
    }

    /**
     * @see org.apache.commons.logging.Log#debug(java.lang.Object, java.lang.Throwable)
     */
    public void debug(Object arg0, Throwable arg1) {
        if (isDebugEnabled()) {
            m_log.log(Level.FINER, arg0.toString(), arg1);
        }
    }

    /**
     * @see org.apache.commons.logging.Log#error(java.lang.Object)
     */
    public void error(Object arg0) {
        if (isErrorEnabled()) {
            m_log.fine(arg0.toString());
        }
    }

    /**
     * @see org.apache.commons.logging.Log#error(java.lang.Object, java.lang.Throwable)
     */
    public void error(Object arg0, Throwable arg1) {
        if (isErrorEnabled()) {
            m_log.log(Level.FINE, arg0.toString(), arg1);
        }
    }

    /**
     * @see org.apache.commons.logging.Log#fatal(java.lang.Object)
     */
    public void fatal(Object arg0) {
        if (isFatalEnabled()) {
            m_log.severe(arg0.toString());
        }
    }

    /**
     * @see org.apache.commons.logging.Log#fatal(java.lang.Object, java.lang.Throwable)
     */
    public void fatal(Object arg0, Throwable arg1) {
        if (isFatalEnabled()) {
            m_log.log(Level.SEVERE, arg0.toString(), arg1);
        }
    }

    /**
     * @see org.apache.commons.logging.Log#info(java.lang.Object)
     */
    public void info(Object arg0) {
        if (isInfoEnabled()) {
            m_log.info(arg0.toString());
        }
    }

    /**
     * @see org.apache.commons.logging.Log#info(java.lang.Object, java.lang.Throwable)
     */
    public void info(Object arg0, Throwable arg1) {
        if (isInfoEnabled()) {
            m_log.log(Level.INFO, arg0.toString(), arg1);
        }
    }

    /**
     * @see org.apache.commons.logging.Log#trace(java.lang.Object)
     */
    public void trace(Object arg0) {
        if (isTraceEnabled()) {
            m_log.finest(arg0.toString());
        }
    }

    /**
     * @see org.apache.commons.logging.Log#trace(java.lang.Object, java.lang.Throwable)
     */
    public void trace(Object arg0, Throwable arg1) {
        if (isTraceEnabled()) {
            m_log.log(Level.FINEST, arg0.toString(), arg1);
        }
    }

    /**
     * @see org.apache.commons.logging.Log#warn(java.lang.Object)
     */
    public void warn(Object arg0) {
        if (isWarnEnabled()) {
            m_log.warning(arg0.toString());
        }
    }

    /**
     * @see org.apache.commons.logging.Log#warn(java.lang.Object, java.lang.Throwable)
     */
    public void warn(Object arg0, Throwable arg1) {
        if (isWarnEnabled()) {
            m_log.log(Level.WARNING, arg0.toString(), arg1);
        }
    }
}
