package jp.co.kayo.io;

import org.apache.xpath.XPathAPI;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

import org.xml.sax.InputSource;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringReader;

import java.nio.charset.Charset;

import java.util.Vector;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.OutputKeys;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;


public class XMLUtil {
    private static DocumentBuilderFactory _factory = null;

    public static DocumentBuilderFactory getFactory() {
        if (_factory == null) {
            _factory = DocumentBuilderFactory.newInstance();
        }

        return _factory;
    }

    public static void setText(Element elm, String text) {
        Document doc = elm.getOwnerDocument();

        if (doc != null) {
            Text textnode = doc.createTextNode(text);
            elm.appendChild(textnode);
        }
    }

    public static String getTextContents(Node node, boolean deep)
        throws Exception {
        if (node == null) {
            throw new Exception("parameter was null.");
        }

        NodeList childNodes;
        StringBuffer contents = new StringBuffer();
        node.normalize();
        childNodes = node.getChildNodes();

        for (int i = 0; i < childNodes.getLength(); i++) {
            if (childNodes.item(i).getNodeType() == Node.TEXT_NODE) {
                contents.append(childNodes.item(i).getNodeValue());
            } else {
                if (deep) {
                    contents.append(getTextContents(childNodes.item(i), deep));
                }
            }
        }

        return contents.toString();
    }

    public static String getTextNodeValue(Node node, String xql) {
        String ret = null;

        if (node != null) {
            try {
                ret = findValue(node, xql, false);
            } catch (Exception e) {
                if (Log.logger(XMLUtil.class).isDebugEnabled()) {
                    Log.logger(XMLUtil.class).debug("getTextNodeValue", e);
                }
            }
        }

        return ret;
    }

    public static String getTextValue(Node node, String xql) {
        String ret = null;

        if (node != null) {
            try {
                ret = findValue(node, xql, true);
            } catch (Exception e) {
                if (Log.logger(XMLUtil.class).isDebugEnabled()) {
                    Log.logger(XMLUtil.class).debug("getTextValue", e);
                }
            }
        }

        return ret;
    }

    public static String NodeToString(Node node, boolean indent, boolean omitflg)
        throws Exception {
        if (node == null) {
            throw new Exception("parameter was null.");
        }

        java.io.StringWriter out = new java.io.StringWriter();

        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer;

        transformer = factory.newTransformer();
        transformer.setOutputProperty(OutputKeys.INDENT, indent ? "yes" : "no");
        transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,
            omitflg ? "no" : "yes");
        transformer.transform(new DOMSource(node), new StreamResult(out));

        return out.toString();
    }

    public static Node StreamToNode(InputStream in, boolean indent,
        boolean omitflg) throws Exception {
        if (in == null) {
            throw new Exception("parameter was null.");
        }

        DOMResult out = new DOMResult();

        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer;

        transformer = factory.newTransformer();
        transformer.setOutputProperty(OutputKeys.INDENT, indent ? "yes" : "no");
        transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,
            omitflg ? "no" : "yes");
        transformer.transform(new StreamSource(in), out);

        return out.getNode();
    }

    public static Node StringToNode(String xmlstr, boolean indent,
        boolean omitflg) throws Exception {
        if (xmlstr == null) {
            throw new Exception("parameter was null.");
        }

        java.io.StringReader in = new StringReader(xmlstr);
        DOMResult out = new DOMResult();

        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer;

        transformer = factory.newTransformer();
        transformer.setOutputProperty(OutputKeys.INDENT, indent ? "yes" : "no");
        transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION,
            omitflg ? "no" : "yes");
        transformer.transform(new StreamSource(in), out);

        return out.getNode();
    }

    public static String findValue(Node node, String xql, boolean deep)
        throws Exception {
        String ret = null;

        if ((xql == null) || (xql.length() == 0)) {
            throw new Exception("findValue called with empty xql statement");
        }

        if (node == null) {
            throw new Exception("findValue called with null node");
        }

        Node find = XPathAPI.selectSingleNode(node, xql);

        if (find != null) {
            ret = getTextContents(find, deep);
        } else {
            ret = "";
        }

        return ret;
    }
    public static Document newDocument() throws Exception {
        DocumentBuilder builder = getFactory().newDocumentBuilder();

        return builder.newDocument();
    }
    public static void nodeOptimize(Node node) {
        if (node.hasChildNodes() != true) {
            return;
        }

        NodeList list = node.getChildNodes();

        Vector removelsit = new Vector();

        for (int i = 0; i < list.getLength(); i++) {
            Node c = list.item(i);

            if (c.getNodeType() == Node.ELEMENT_NODE) {
                nodeOptimize(c);
            } else {
                removelsit.add(c);
            }
        }

        for (int i = 0; i < removelsit.size(); i++) {
            node.removeChild((Node) removelsit.get(i));
        }
    }
    public static Document parse(String xmlstr) throws Exception {
        DocumentBuilder builder = getFactory().newDocumentBuilder();

        java.io.StringReader in = new StringReader(xmlstr);

        return builder.parse(new InputSource(in));
    }
    public static Document loadXml(String filename) throws Exception {
        DOMResult domresult;
        InputStreamReader in = null;

        try {
            in = new InputStreamReader(new FileInputStream(new File(filename)), Charset.forName("UTF-8"));
            StreamSource s = new StreamSource(in);

            domresult = new DOMResult();

            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer;

            transformer = factory.newTransformer();
            transformer.transform(s, domresult);
        } finally {
            if (in != null) {
                in.close();
            }
        }

        return (Document) domresult.getNode();
    }
    
    public static void saveXml(Document doc, String filename, String xsl)
        throws Exception {
        DOMResult domresult;
        OutputStreamWriter out = null;

        try {
            if (xsl != null) {
                ProcessingInstruction pi = doc.createProcessingInstruction("xml-stylesheet",
                        "type='text/xsl' href='" + xsl + "'");
                doc.insertBefore(pi, doc.getFirstChild());
            }

            out = new OutputStreamWriter(new FileOutputStream(new File(filename)), Charset.forName("UTF-8"));

            DOMSource s = new DOMSource(doc);

            domresult = new DOMResult();

            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer;

            boolean indent = true;
            boolean omitflg = true;
            transformer = factory.newTransformer();

            //transformer.setOutputProperty(OutputKeys.INDENT, indent ? "yes" : "no");
            transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, omitflg ? "no" : "yes");
            transformer.setOutputProperty(OutputKeys.ENCODING, out.getEncoding());
            transformer.transform(s, new StreamResult(out));
        } finally {
            if (out != null) {
                out.close();
            }
        }
    }
    public static String toString(Node node, boolean indent, boolean omitflg) {
        String xml = "";

        if (node != null) {
            try {
                xml = NodeToString(node, indent, omitflg);
            } catch (Exception e) {
                if (Log.logger(XMLUtil.class).isDebugEnabled()) {
                    Log.logger(XMLUtil.class).debug("toString", e);
                }
            }
        }

        return xml;
    }
}