<?php

if (!defined('IN_WACKO'))
{
	exit;
}

$wacko_translation = [

	// language
	'lang_scheme'	=> [
		'name'		=> 'Chinese',
		'code'		=> 'zh',
		'dir'		=> 'ltr',
		'locale'	=> 'zh_CN.UTF-8',
	],

	// common
	'AddButton'					=> '添加',
	'ArchiveButton'				=> '归档',
	'CancelButton'				=> '取消',
	'ContinueButton'			=> '继续',
	'ConvertButton'				=> '转换',
	'CreateButton'				=> '创建',
	'DeleteButton'				=> '删除',
	'RemoveButton'				=> '删除',
	'RenameButton'				=> '重命名',
	'ResetButton'				=> '重置',
	'RestoreButton'				=> '恢复',
	'SaveButton'				=> '保存',
	'SearchButton'				=> '搜索',
	'SendButton'				=> '发送',
	'SetButton'					=> '设置',
	'SubmitButton'				=> '提交',
	'UpdateButton'				=> '更新',

	'FormInvalid'				=> '提交的表格无效。尝试再次提交。',
	'UnitPixel'					=> 'px',
	'Number'					=> 'Number',

	// logged in panel
	'AccountText'				=> '我的帐户',
	'AccountTip'				=> '帐户设置',
	'AdminText'					=> '管理',
	'AdminTip'					=> '管理面板',
	'LogoutLink'				=> '退出',
	'LogoutButton'				=> '退出',
	'LogoutAreYouSure'			=> '确定退出？',

	// registration panel
	'RegistrationWelcome'		=> '创建账户：',
	'RegistrationButton'		=> '创建账户',
	'UserNameOwned'				=> '用户名已注册，请更换',
	'SiteRegistered'			=> '您已成功注册网站 %1。',
	'RegistrationEmailInfo'		=> '有效的电子邮件地址。来自系统的所有电子邮件都将发送到此地址。2该电子邮件地址不公开，仅在您希望接收新密码或希望通过电子邮件接收某些新闻或通知时使用。',
	'EmailConfirmHint'			=> '请点击发送给您的说明中的链接确认您的电子邮件地址<br>如果不验证您的电子邮件地址，您将无法检索可能丢失的密码<br>此外，您不会收到最近页面更改和评论的通知。',
	'EmailConfirmRequired'		=> '没有确认的电子邮件地址，你将不被允许登录。',
	'NameTooShort'				=> '用户名太短，至少需要%2个字符。',
	'NameTooLong'				=> '用户名太长，最多允许%2个字符。',
	'NameAlphanumOnly'			=> '用户名必须 %1 - %2 字符并且是字母数字组合',
	'NameCamelCaseOnly'			=> '用户名的长度必须在%1到%2个字符之间，并且为WikiName的格式。',
	'NewUserAccount'			=> '新账户',

	'NewAccountSubject'			=> '账户注册',
	'NewAccountAdminCreated'	=> '用户%1已使用用户名“%2”为您创建了一个帐户。为了完成注册，请访问以下URL（确保以单行形式输入），并设置您自己的访问密码：',
	'NewAccountUsername'		=> '用户名：',
	'AccountLanguage'			=> '语言：',
	'NewAccountEmail'			=> '电子邮件：',
	'NewAccountIP'				=> '远程IP地址：',
	'NewAccountSignupInfo'		=> '已创建以下帐户：',

	'UserWaitingApproval'		=> '已向网站管理员发送电子邮件。管理员将审核已提交的信息，并批准或拒绝您的请求。',
	'UserRequiresApproval'		=> '要批准或拒绝此用户访问%1，请转到“管理”面板。',
	'UserApprovalInfo'			=> '注册后，您的请求将发送给网站管理员以供批准。然后，您将收到一封包含进一步说明的电子邮件。',
	'UserApprovalHint'			=> '您将收到一封特定的电子邮件，包含激活信息。在此之前无法登陆。',

	'UserApprovalPending'		=> '您的帐户仍在等待批准。',
	'UserApprovalDenied'		=> '您的帐户已被拒绝访问此网站。',

	'RegistrationApproved'		=> '注册已批准',
	'RegistrationDenied'		=> '注册被拒绝',
	'PendingApproval'			=> '待批准',

	'UserApprovedInfo'			=> '您已获准访问 %1。',
	'UserDeniedInfo'			=> '您已被拒绝访问 %1。',

	'RegistrationThreshold'		=> '填写表格的时间不应少于%1秒。',
	'Language'					=> '语言',

	// login panel
	'LoginWelcome'				=> '登录',
	'CreateAccount'				=> '创建新帐号',
	'RegistrationLink'			=> '注册',
	'LoginName'					=> '用户名',
	'Password'					=> '密码',
	'LoginButton'				=> '登录',
	'LoginLink'					=> '登录',
	'PersistentCookie'			=> '记住我的登录状态',
	'Session'					=> '会话',
	'SessionTip'				=> '当前会话的参数',
	'SessionDuration'			=> '会话持续时间',
	'SessionDurationSession'	=> '浏览器会话',
	'SessionDurationDay'		=> '1天',
	'SessionDurationWeek'		=> '1周',
	'SessionDurationMonth'		=> '1月',
	'LoggedInAs'				=> '您登陆于',

	'ClearCookies'				=> '删除所有cookies',
	'BindSessionIp'				=> '将会话绑定到 IP 地址',
	'BindSessionIpOn'			=> '已启用（当前IP%1）',
	'TrafficProtection'			=> '流量保护',
	'SessionEnds'				=> '当前会话结束',
	'LastVisit'					=> '最后一次访问已记录',

	'LoginIncorrect'			=> '您输入的用户名或密码无效。',
	'WelcomeBack'				=> '欢迎回来, %1',
	'LoginAttemptsExceeded'		=> '您超过了允许的最大登录尝试次数<br>除了用户名和密码之外，您现在还必须解决下面的验证码问题。',

	// session notice
	'IPAddressChanged'			=> 'IP地址变更为 %1 （之前是 %2）',

	'SessionReplay'				=> '会话因重放而终止。',
	'SessionObsolete'			=> '会话超时',
	'SessionExpired'			=> '会话过期',
	'SessionTimeout'			=> '会话因超时而终止。',
	'SessionInactivity'			=> '会话因不活动而终止。',
	'SessionUaChange'			=> '由于用户代理更改，会话已终止。',
	'SessionTLSChange'			=> '由于TLS更改，会话已终止。',
	'SessionIPChange'			=> '会话因 IP 更改而终止。',

	// other
	'Guest'						=> '游客',
	'Help'						=> '帮助',
	'TopicSearchText'			=> '只搜索标题',
	'WordprocessorVersion'		=> '文字处理器版本',

	// notifications
	'EmailHello'				=> '你好 ',
	'EmailModerator'			=> '版主',
	'WatchedPageChanged'		=> '页面更改完毕 ',
	'SomeoneChangedThisPage'	=> ' 更改了您正在观看的页面： ',
	'NewPageCreatedSubj'		=> '新页面',
	'NewPageCreatedBody'		=> '用户 %1 创建了一个新页面： ',
	'FileUploadedSubj'			=> '新文件',
	'FileUploadedBody'			=> '用户 %1 上传了一个新文件： ',
	'FileReplacedBody'			=> '用户 %1 已替换文件： ',

	'ActionDenied'				=> '此处拒绝操作。',
	'TocTitle'					=> '目录 ',
	'OuterLink2'				=> '跳出链接',
	'FileLink'					=> '',
	'PDFLink'					=> 'PDF 文档',
	'RDFLink'					=> 'PDF 文档',
	'EmailLink'					=> '写一封电子邮件 （邮件客户端启动）',
	'JabberLink'				=> '通过 XMPP 聊天 （Jabber 客户端启动）',
	'PermaLink'					=> '永久链接',
	'PermaLinkTip'				=> '本页面该版本的固定链接',
	'PermaLink0Tip'				=> '本文的永久链接',

	'ShowTip'					=> '返回查看模式',
	'ShowText'					=> '查看',
	'WikieditAutocomplete'		=> '使用 Ctrl+Space 完成wiki链接',
	'WikiEditInactiveJs'		=> '为了能够使用WikiEdit，请在浏览器中启用JavaScript。',
	'NumerateLinks'				=> '打印视图中计算链接',
	'Comment'					=> '评论',
	'Comments0'					=> '添加留言',
	'Comments1'					=> '查看评论 （1 评论）',
	'CommentsN'					=> '查看评论 （%1 评论）',
	'Comments'					=> '评论',
	'CommentHint'				=> '<a href="%1">登录</a>或<a href="%2">创建一个帐户</a>以发表评论。',
	'CommentEdited'				=> '编辑',
	'Links'						=> '链接',
	'Version'					=> '版本',

	// details formatter
	'ShowHideDetails'			=> '细节',

	'PrivacyPolicy'				=> '隐私政策',
	'TermsOfUse'				=> '使用条款',
	'AcceptTermsOfUse'			=> '我已阅读、理解并同意本网站的服务条款。',

	'ShowComments'				=> '显示评论/表单',
	'HideComments'				=> '隐藏评论/表单',
	'AddComment'				=> '请发布评论：',
	'AddCommentTitle'			=> '评论标题：',
	'CommentTitleRe'			=> '回复:',
	'AddCommentButton'			=> '添加评论',
	'HereLink'					=> '这里',
	'PageHandlerMoreTip'		=> '更多',

	'ThemeCorrupt'				=> '主题已损坏',
	'InvalidNamespace'			=> '给定的命名空间无效。',
	'DoesNotExists'				=> '该页不存在。',
	'PromptCreate'				=> '您是不是要 <strong><a href="%1">新建</a></strong> 它呢？',
	'RevisionHint'				=> '這是一个旧版本的 of <a href="%1">%2</a> from %3 edited by %4.',
	'ReadAccessDenied'			=> '无阅读权限',
	'ReadAccessDeniedHintGuest'	=> '登录后可阅读。',
	'PageDeletedInfo'			=> '本页已被删除。',
	'RevisionDeletedInfo'		=> '此修订已被删除。',
	'CommentDeletedInfo'		=> '此评论已被删除。',

	'LastEditedBy'				=> '最后编辑于',
	'YouAreOwner'				=> '你是本页的所有者。',
	'Owner'						=> '所有者：',
	'Nobody'					=> '本页没有所有者',
	'TakeOwnership'				=> '成为所有者',
	'FilesTip'					=> '管理上传福建',
	'FilesText'					=> '附件',
	'DeleteTip'					=> '删除页面，文件和评论',
	'DeleteCommentTip'			=> '删除评论',
	'DeleteText'				=> '删除',
	'AclText'					=> '权限管理',
	'AclTip'					=> '修改权限',

	'PropertiesText'			=> '属性',
	'PropertiesTip'				=> '编辑页面属性',
	'EditTip'					=> '编辑该页。',
	'EditText'					=> '编辑',
	'EditSection'				=> '编辑章节 %1',
	'EditSectionHint'			=> '第 %1 节，共 %2 节',
	'SectionHeadline'			=> '章节',
	'EditCommentTip'			=> '编辑评论',
	'EditComment'				=> '编辑此评论',
	'ReplyComment'				=> '回复',
	'ReplyCommentTip'			=> '回复此评论',
	'RevisionTip'				=> '查看最近的修改历史',
	'RevisionText'				=> '修订版本',
	'ReferrersTip'				=> '查看链接到本页的历史',
	'ReferrersText'				=> '反向链接',
	'ModerateTip'				=> '审核主题和帖子',
	'ModerateText'				=> '管理',
	'SearchText'				=> '搜索： ',

	'AclUpdated'				=> '权限设置已更新',
	'AclGaveOwnership'			=> ' 并赋予所有权给 %1。',
	'AclNoNewOwner'				=> '但所有权未转移，因为未找到用户 %1。',
	'NewPageOwnership'			=> '页面所有权已转让',
	'YouAreNewOwner'			=> '前所有者 %1 转让了所有权 ' . "\n" . '的下一页给你',
	'PageOwnershipInfo'			=> '',
	'AclRead'					=> '浏览权限：',
	'AclWrite'					=> '编辑权限：',
	'AclComment'				=> '评论权限：',
	'AclCreate'					=> '创建：',
	'AclUpload'					=> '上传：',
	'AclFor'					=> '访问控制列表 - %1',
	'SetOwner'					=> '设置拥有者：',
	'OwnerDontChange'			=> '不改变',
	'AclAccessDenied'			=> '你不是本页的所有者',
	'AclSyntaxError'			=> '访问控制列表语法错误',
	'AclHelp'					=> '<code>*</code> - 每个人都可以<br>' .
									'<code>$</code> - 仅限注册用户<br>' .
									'<code>!</code> - 前面的感叹号否定了相应的权利<br>' .
									'<code>[UserName]</code> - 允许用户的名称<br>' .
									'<code>[GroupName]</code> - 允许的用户组的名称（别名）<br>' .
									'<code>(an empty list)</code> - 只有页面所有者有权访问',

	'AccessMode'				=> '可见性',
	'AccessDenied'				=> '拒绝',
	'AccessPublic'				=> '公开',
	'AccessRegistered'			=> '已注册',
	'AccessPrivate'				=> '隐私',
	'AccessCustom'				=> '自定义',

	// purge handler
	'PurgePage'					=> '清理页面',
	'NotOwnerAndCantPurge'		=> '您不是该页面的所有者，无法清除该页面。',
	'ReallyPurge'				=> '注意：清除页面是不可逆的！',
	'SelectPurgeOptions'		=> '选择必要的清除选项：',
	'PurgeComments'				=> '清除页面上的所有评论',
	'CommentsPurged'			=> '所有评论删除完毕',
	'PurgeFiles'				=> '删除所有附件',
	'FilesPurged'				=> '所有附件已删除',
	'PurgeRevisions'			=> '清除页面的所有修订',
	'RevisionsPurged'			=> '所有修订已删除',
	'PurgeButton'				=> '清理',

	// categories handler
	'Categories'				=> '类别',
	'CategoriesAssign'			=> '分配',
	'CategoriesEdit'			=> '编辑',
	'Category'					=> '分类',
	'CategoriesFor'				=> '类别',
	'CategoriesTip'				=> '编辑分类',
	'CategoriesText'			=> '类别',
	'CategoriesUpdated'			=> '分类更新',
	'CategoriesAlreadyExists'	=> '这个类%1别已经存在。',
	'CategoriesAdded'			=> '分类%1添加成功',
	'CategoriesRenamed'			=> '分类重命名成功',
	'CategoriesUngrouped'		=> '类别解绑成功。',
	'CategoriesGrouped'			=> '在新组中输入的类别。',
	'NoMultilevelGrouping'		=> '无法实现多级分组类别。',
	'CategoriesDeleted'			=> '该分类已从数据库和所有页面中删除。',
	'CategoriesAdd'				=> '创建新分类',
	'CategoryDescription'		=> '描述',
	'CategoriesAddGrouped'		=> '按类别分组',
	'CategoriesAddGroupedNo'	=> '没有分组',
	'CategoriesRename'			=> '将分类 %1 重命名为',
	'CategoriesRenameInfo'		=> '* 注意：更改将影响分配给该分类的所有页面。',
	'CategoriesGroup'			=> '将类别 %1 与',
	'CategoriesGroupInfo'		=> '* 选择[未分组]，可拆分类别。',
	'CategoriesNoGroup'			=> '[未分组]',
	'CategoriesDelete'			=> '您确定要删除分类 %1 吗？',
	'CategoriesDeleteInfo'		=> '* 注意：更改将影响分配给该类别的所有页面。 如果这个词有一个子类别，它们不会被删除，而只会被拆分。',
	'CategoriesStoreInfo'		=> '要将类别分配给页面，请选中复选框。',
	'CategoriesStoreButton'		=> '保存分类',
	'CategoriesGroupButton'		=> '组',
	'CategoriesEditInfo'		=> '要编辑类别列表，请选择单选按钮。',
	'NoCategoriesForThisLang'	=> '未指定此语言的类别。',
	'PagesCategory'				=> '页面类别',
	'CategoryNotExists'			=> '类别不存在。',
	'CategoryEmpty'				=> '类别为空。',
	'NoCategorySelected'		=> '未选择任何类别。',
	'NoCategoriesAssigned'		=> '没有为此语言分配的类别。',
	'TagCloud'					=> '标签云',
	'PagesTaggedWith'			=> '%1 页标记为 %2',
	'CategoriesOfCluster'		=> '集群的',
	'TaggedWithTip'				=> '显示标记为 %1 的页面',

	// source handler
	'SourceText'				=> '来源',
	'SourceTip'					=> '查看源代码',
	'SourceCopyToClipboard'		=> '复制到剪贴板',
	'SourceFor'					=> '查看 %1 的源代码',

	// Groups action
	'GroupsSearch'				=> '寻找用户组',
	'GroupsNoMatching'			=> '未找到匹配组。 尝试使用更柔和的搜索条件。',
	'GroupsOpenProfile'			=> '查看用户资料',
	'GroupsName'				=> '用户组',
	'GroupsMembers'				=> '用户列表',
	'GroupsDescription'			=> '描述',
	'GroupsCreated'				=> '创建',
	'GroupsNotFound'			=> '未找到用户组 %2。 单击<a href="%1">此处</a>，转到主列表。',
	'GroupsProfile'				=> '用户信息',
	'GroupsList'				=> '查看全部用户组组列表',
	'GroupSpace'				=> '组空间',

	'MetaUpdated'				=> 'Meta数据更新',

	'PreviewButton'				=> '预览',
	'Preview'					=> '预览',
	'Chars'						=> '字符',
	'PageBody'					=> '页面正文',
	'EditNote'					=> '简述您的修改',
	'EditNoteMissing'			=> '缺少编辑摘要',
	'EditMinor'					=> '这是一个细微的更改',
	'MinorEditHide'				=> '隐藏次要编辑',
	'MinorEditShow'				=> '显示次要编辑',
	'PostAnonymously'			=> '匿名发布，不透露姓名',
	'NotifyMe'					=> '通知我有关页面的新评论和更改',
	'OverwriteAlert'			=> '覆盖警报：此页面在您编辑时被其他人修改。<br>请复制您的更改并重新编辑此页面。',
	'TextDbOversize'			=> '注意：你的文本超过了长度限制的%1个字符。请将您的文本缩短到可接受的字符数。提示：你可以将剩余的文本放在单独的一页。',
	'EditingRevisionWarning'	=> '您正在编辑此页面的旧版本。 如果您发布它，此后所做的任何更改都将被删除。 <br>您可能希望改为编辑当前版本。',
	'WriteAccessDenied'			=> '您没有编辑该页的权限。',
	'EmptyPage'					=> '页面正文为空 - 未保存！',
	'EmptyComment'				=> '留言沒有內容？ 不保存留言！',
	'CommentAccessDenied'		=> '抱歉，您不能在此页面上发表评论。',
	'CommentFlooded'			=> '帖子发布之间的间隔不得少于 %1 秒。',
	'CommentAdded'				=> '评论已添加。',
	'YouAreNowTheOwner'			=> '你已成为本页的拥有者。',
	'PageSaved'					=> '页面版本 %1 已保存。',
	'CommentSaved'				=> '评论已保存。',

	'RevisionsFor'				=> '历史 %1',
	'DefaultDiffMode'			=> '默认差异模式',
	'DiffMode'		=> [
		'0'		=> '所有差异',
		'1'		=> '单个差异',
		'2'		=> '源',
		'3'		=> '并排显示',
		'4'		=> '行内显示',
		'5'		=> '合并',
		'6'		=> '整合',
		'7'		=> '上下文',
	],

	'PreviousEdit'				=> '前一修订版',
	'NextEdit'					=> '后一修订版',

	'Diff'						=> '差异',
	'PreviousVersion'			=> '上一修订',
	'LatestVersion'				=> '最后版本',
	'NextVersion'				=> '下一修订',

	'ShowDifferencesButton'		=> '查看差异',
	'CancelReturnButton'		=> '取消并返回页面',
	'Comparison'				=> ' %1 修订之间的差异',
	'RevisionAsOf'				=> '修订 %1 截止',
	'SimpleDiffAdditions'		=> '新增内容：',
	'SimpleDiffDeletions'		=> '删除内容：',
	'NoDifferences'				=> '两版本之间没有差异。',
	'ReEditOldRevision'			=> '重新编辑这个旧版本',

	'ExternalPages'				=> '链接到 %1 （%2） 的外部页面（<a href="%3">查看域列表</a>）：',
	'ExternalPagesGlobal'		=> '链接到此 WackoWiki （%2） 的站点（<a href="%1">查看域列表</a>）：',
	'Last24Hours'				=> '过去24小时',
	'LastDays'					=> '过去 %1 天',
	'DomainsSitesPages'			=> '链接到 %1 （%2） 的域/网站页面（<a href="%3">查看不同 URL 的列表</a>）：',
	'DomainsSitesPagesGlobal'	=> '链接到此 WackoWiki 的域/站点（<a href="%1">查看不同 URL 列表</a>）：',
	'ViewReferrersPage'			=> '翻页',
	'ViewReferrersPerPage'		=> '每页',
	'ViewReferrersByTime'		=> '按时间',
	'ViewReferrersGlobal'		=> '全局',
	'NoneReferrers'				=> '空',
	'NotOwnerCantDelete'		=> '您不是此页面的所有者，无法将其删除',

	// remove
	'RemovePage'				=> '刪除该页',
	'RemoveRevision'			=> '移除版本',
	'RemoveComment'				=> '删除评论',
	'RemoveCluster'				=> '删除集群内所有页面',
	'RemoveDontKeep'			=> '不要保存已删除页面和评论的副本',
	'RemoveDontKeepRevision'	=> '不要保存已删除修订的副本',
	'RemoveDontKeepComment'		=> '不要保存已删除评论的副本',
	'RemoveDontKeepFile'		=> '不要保存已删除文件的副本',
	'ReferrersRemoved'			=> '已删除推荐人。',
	'LinksRemoved'				=> '已删除链接。',
	'CategoriesRemoved'			=> '页面类别已删除。',
	'AclsRemoved'				=> '页面 acl 已删除。',
	'BookmarksRemoved'			=> '书签已删除。',
	'WatchesRemoved'			=> '关注被移除',
	'CommentsRemoved'			=> '页面上的评论已删除。',
	'FilesRemoved'				=> '页面中的文件已删除。',
	'PageRemoved'				=> '页面已删除。',
	'PageCachePurged'			=> '缓存已清除。',
	'ClusterRemoved'			=> '删除了集群的所有页面。',
	'RevisionRemoved'			=> '已删除修订 %1。',
	'RevisionsRemoved'			=> '已删除修订。',
	'ActionHaveNoUndo'			=> '此动作无法恢复。',

	// restore
	'PageRestored'				=> '页面已恢复。',
	'RevisionRestored'			=> '已恢复修订。',
	'LocalFilesRestored'		=> '本地文件已恢复。',

	'PrintVersion'				=> '打印版本',
	'PrintText'					=> '打印',
	'LinkedPages'				=> '链接页面：',
	'NoLinkedPages'				=> '没有链接页面',
	'ReferringPages'			=> '来源页：',
	'NoReferringPages'			=> '没有来源页',
	'Footnotes'					=> '脚注：',
	'Footnote'					=> '脚注',
	'MostPopularPages'			=> '最多查看页面',
	'MostCommentedPages'		=> '评论最多的页面',
	'NoAccessToSourcePage'		=> '您无权阅读操作源页面。',
	'SourcePageDoesntExist'		=> '操作源页面尚不存在',
	'NotLoggedInThusEdited'		=> '因为您尚未登入,所以无法得知您曾经编辑过的页面。',
	'DidntEditAnyPage'			=> '您尚未编辑任何页面。',
	'NoPagesFound'				=> '没有找到页面。',
	'MyChangesTitle1'			=> '这是您已编辑的页面列表，按您上次更改的时间排序',
	'MyChangesTitle2'			=> '这是您编辑过的页面列表，以及您上次更改的时间',
	'OrderABC'					=> '按字母顺序',
	'OrderCreation'				=> '按日期',
	'OrderChange'				=> '按修改',
	'ListOwnedPages'			=> '这是您拥有的页面列表（按字母顺序排列）',
	'ListOwnedPages2'			=> '这是您拥有的页面列表（按日期排序）',
	'ListOwnedPages3'			=> '这是您拥有的页面列表（按更改排序）',
	'NotLoggedInThusOwned'		=> '因为您尚未登入,所以无法得知您拥有的页面。',
	'NoOrphaned'				=> '没有页面被孤立,好极了！',
	'NoRecentComments'			=> '最近没有评论。',
	'LatestCommentBy'			=> '最后评论于',
	'NoRecentlyCommented'		=> '最近没有评论页面。',
	'NoDeletedPages'			=> '未找到已删除的页面。',
	'NoDeletedRevisions'		=> '未找到已删除的修订。',
	'NoDeletedFiles'			=> '未找到已删除的文件。',
	'CommentsDisabled'			=> '没有评论',

	'SearchResults'				=> '搜索结果 ',
	'NotFound'					=> '没找到',
	'NoResultsFor'				=> '没搜索到  ',
	'SearchFor'					=> '搜索：',
	'TopicSearchResults'		=> '主题搜索结果 ',
	'NotFoundInTopics'			=> '在主题中找不到',
	'FilterLangNotAvailable'	=> '所选语言不可用！',

	'PostedBy'					=> '发布者',
	'ThisIsCommentOn'			=> '这是一个评论',
	'At'						=> 'at',
	'To'						=> '到',
	'By'						=> '由',
	'From'						=> '来自',
	'For'						=> 'for',
	'ReturnToCommented'			=> '返回评论页面',
	'AbandonedComment'			=> '此评论所属的页面已不存在！',

	'PagesLinkingTo'			=> '以下页面链接到',
	'NoPageLinkingTo'			=> '沒有页面链接到',
	'NoWantedPages'				=> '沒有等待建立的页面！',
	'RemoveWatch'				=> '停止监视',
	'SetWatch'					=> '监视本页',
	'WatchText'					=> '监视',
	'UnwatchText'				=> '取消监视',
	'UserSettingsStored'		=> '用户设置已保存。',
	'LoggedOut'					=> '您已经成功注销。',
	'LoggedOutAuto'				=> '为安全起见，您的会话已结束。 请重新登录。',

	// user settings
	'EmailConfirmResent'		=> '重复的电子邮件确认代码发送到您的地址。',
	'EmailConfirmNotSent'		=> '无法发送确认码：未指定电子邮件！',
	'Hello'						=> '你好',
	'UserName'					=> '用户名',
	'EmailAddress'				=> '您的邮箱',
	'RealName'					=> '全名',
	'MenuItemsShown'			=> '菜单项数量',
	'RecordsPerPage'			=> '每页记录',
	'DoShowComments'			=> '预设显示留言',
	'DoubleclickEditing'		=> '双击页面编辑',
	'UpdateSettingsButton'		=> '更新设置',

	'AccountDisabled'			=> '您的帐户可能被禁用或阻止。',
	'WrongPassword'				=> '密码错误！',
	'ConfirmPassword'			=> '重输密码',
	'Email'						=> '邮箱地址',
	'MustBeWikiName'			=> '用戶名必须符合 <a href="https://wackowiki.org/doc/Doc/English/WikiName" target="_blank">WikiName</a> 格式！',
	'SpecifyEmail'				=> '您必须提供您的电子邮件地址。',
	'NotAEmail'					=> '您的邮件地址也许不是有效的。',
	'EmailTaken'				=> '输入的电子邮件地址已被使用。',
	'EmailDomainNotAllowed'		=> '电子邮件%1 不在允许的域名列表.',
	'PasswordsDidntMatch'		=> '您输入的密码和确认密码不一致。',
	'SpacesArentAllowed'		=> '密码中不允许有空格。',
	'ListMyPages'				=> '列出您的页面',
	'ListMyChanges'				=> '列出您的更改',
	'ListMyWatches'				=> '被关注页面列表',
	'ListMyChangesWatches'		=> '关注页面之间的变化',
	'SeeListOfPages'			=> '查看您拥有的页面列表 (MyPages) 和您编辑过的页面 (MyChanges)。',
	'AddBookmark'				=> '将当前页面添加到书签',
	'RemoveBookmark'			=> '从书签移除',

	'YourLanguage'				=> '选择您的语言',
	'ShowSpaces'				=> '在 WikiNames 中显示空格',
	'WrongPage4Redirect'		=> '由于重定向参数错误，无法重定向',
	'RedirectsToItself'			=> '页面重定向到自身。',
	'ReallyDeletePage'			=> '您真的要删除此页面吗？<br>此操作无法撤消！<br><br>警告：删除此页面将删除所有页面版本、评论、附件、ACL 和引用者。',
	'CommentForWatchedPage'		=> '页面的新评论 ',
	'SomeoneCommented'			=> ' 评论了您正在观看的此页面： ',
	'AlertReferringPages'		=> '这些页面引用本页面',

	'AccountDelete'				=> '删除帐户',
	'AccountDeleteConfirm'		=> '您确定要删除该帐户吗？',
	'AccountDeleted'			=> '帐号已成功删除',
	'AccountDeleteHeader'		=> '删除帐户 %1',
	'AccountDeleteInfo'			=> '您创建的数据（例如电子邮件、偏好、附件、维基条目）将被尽可能多地删除。 但是请注意，不能在不妨碍其他用户工作的情况下删除附件和 wiki 条目等数据。 因此，此类数据将重新分配给名为 %1 的帐户。 由于每个已删除帐户的数据都会重新分配给该帐户，因此无法区分您创建的数据与另一个已删除帐户的数据。',
	'AccountDeleteWarning'		=> '删除用户帐户是不可撤销的操作。',
	'AccountDeleteHint'			=> '您的帐户将从系统中删除。 因此，您将无法再使用当前凭据登录。 如果您选择再次成为本应用的用户，您可以通过本应用授予的方式来实现。',
	'AccountDeleteVerify'		=> '输入您的登录名 %1 以验证删除。 提交后，系统会要求您确认密码。',

	'MarkRead'					=> '标记全部已读',
	'CurrentTime'				=> '目前',
	'Created'					=> '创建',
	'Modified'					=> '修改时间',

	'EditIcon'					=> '编辑',
	'TreeClusterTitle'			=> '子页列表 %1',
	'TreeSiteTitle'				=> '站点树',
	'TreeEmpty'					=> '%1 没有子页面',
	'TreeEmptyLevels'			=> '%1 没有给定深度级别的子页面。 增加深度值。',
	'TreeTooBig'				=> '子页面过多',

	// clone handler
	'ClonePage'					=> '克隆页面',
	'CloneText'					=> '克隆',
	'CloneName'					=> '输入克隆页名字',
	'CloneButton'				=> '克隆',
	'PageCloned'				=> '页面 %1 克隆完成。',
	'ClonedFrom'				=> '克隆至 %1。',
	'MassClone'					=> '克隆整个集群',
	'MassCloning'				=> '正在克隆集群',
	'CloneCannotRead'			=> '无法读取页面 %1。',
	'CloneCannotCreate'			=> '无法创建页面 %1。',

	'SortComment'				=> '按评论排序',
	'SortCommentAsc'			=> '最近的在底部',
	'SortCommentDesc'			=> '最近的在顶部',

	'RenamePage'				=> '重命名该页',
	'RenameText'				=> '重命名',
	'RenameTip'					=> '重命名该页',
	'NewName'					=> '为此页面输入新名称',
	'AlreadyExists'				=> '页面 %1 已存在。',
	'AlreadyNamed'				=> '此页面已命名为 %1。',
	'PageRenamed'				=> '页面重命名',
	'NewNameOfPage'				=> '此页面的新名称： ',
	'NotOwnerCantRename'		=> '您不是此页面的所有者，因此无法重命名它',
	'NeedRedirect'				=> '在旧页面上创建重定向到新页面',
	'RedirectCreated'			=> '在页面 %1 中创建重定向到新页面',

	'UserSettings'				=> '用户设置',
	'UserSettingsGeneral'		=> '常规设置',
	'UserSettingsNotifications'	=> '通知',

	'NotifyMinorEdit'			=> '同时通知小的编辑',
	'NotifyPageEdit'			=> '编辑',
	'NotifyComment'				=> '评论',
	'NotifyOff'					=> '关闭',
	'NotifyAlways'				=> '始终',
	'NotifyPending'				=> '待办',
	'NotifyDigest'				=> '摘要',
	'NotifyPendingPageTip'		=> '对于您正在观看的页面的第一个更改，只会发送一个通知。',
	'NotifyPendingCommentTip'	=> '对于您正在观看的页面的第一个评论，只会发送一个通知。',
	'NotifyPendingTip'			=> '当您访问页面的当前版本时，通知会自动重新启用。',

	'FurtherPending'			=> '除非您访问此页面，否则在进一步更改的情况下不会有其他通知。',

	'UserSettingsEmailMe'		=> '接收电子邮件提醒 ...',

	'UserSettingsExtended'		=> '扩展',
	'UserSettingsOther'			=> '其他设置',
	'UserSpace'					=> '用户空间',
	'ChooseTheme'				=> '主题',

	'CreatePage'				=> '创建该页面',
	'CreateNewPage'				=> '创建一个新的页面',
	'CreateNewPageText'			=> '创建',
	'CreateNewPageTip'			=> '创建一个新的页面',

	'CreateRandomPage'			=> '创建一个随机页面：',
	'CreateSubPage'				=> '在当前集群创建一个子页面：',
	'CreatePageParentCluster'	=> '在上级集创建一个子页面：',
	'CreatePageDenied'			=> '您没有访问权限。',
	'CreatePageDeniedAddress'	=> '您无权在此地址创建页面。',
	'PageAlreadyExists'			=> '根据提供的地址，页面 %1 已经存在。',
	'PageAlreadyExistsEdit'		=> '你想要 %1 吗？',
	'PageAlreadyExistsEdit2'	=> '编辑',
	'PageAlreadyExistsEditDenied'	=> '你不能编辑它',

	'SimilarPagesExists'		=> '与 %1 类似的页面已存在：',
	'SimilarPagesHint'			=> '存在与 %1 类似的页面：',

	'PageReservedWord'			=> '您不能使用 %1 作为地址的一部分，因为它是一个保留字。',
	'UserReservedWord'			=> '用户名不能包含%1，因为它是一个保留字。',

	'DontRedirect'				=> '不允许通过操作 Redirect 进行自动重定向。',
	'SendWatchEmail'			=> '当有人（您除外）更改您正在观看的任何页面时发送通知电子邮件',
	'AllowIntercom'				=> '允许来自系统用户的个人消息',
	'AllowMassemail'			=> '管理员可以通过电子邮件向我发送信息',
	'HideLastSession'			=> '隐藏上次会话',
	'ValidateIP'				=> '将会话绑定到IP',
	'AnonymousPub'				=> '最好是匿名发布（以隐藏名称）',
	'PageMoved'					=> '这一页被移动了。你可以在',
	'RedirectedFrom'			=> '重定向自%1',
	'RedirectedTo'				=> '重定向至',
	'CurrentPassword'			=> '当前密码',
	'NewPassword'				=> '新密码',
	'YouWantChangePassword'		=> '更改密码',
	'ChangePasswordButton'		=> '更改密码',
	'PasswordChanged'			=> '您已经修改了您的密码！',
	'EmailWelcome'				=> '您已在 ',
	'EmailRegistered'			=> '您已在 %1 成功注册。' . "\n" . '您的用户名：%2' . "\n\n",
	'EmailVerify'				=> '如果您想接收通知，您必须验证您的电子邮件地址。 请点击或复制以下链接至网络浏览器：' . "\n" . '%1',
	'EmailRegisteredLogin'		=> '请返回 Wiki 并使用您的新用户名和密码登录。',
	'EmailRegisteredIgnore'		=> '如果您没有请求此注册，请忽略此消息，不会发生任何事情。',
	'EmailDoNotReply'			=> '不要回复此消息。',
	'EmailReverify'				=> '有人（也许是您）在 %1 提交了您的电子邮件作为通知地址' . "\n" . '您的用户名：%2'."\n\n" . '如果你想收到通知，你需要批准你的电子邮件。 请按照链接执行此操作。' . "\n" . '%3' . "\n\n",
	'EmailConfirm'				=> '请验证您的电子邮件',
	'EmailConfirmed'			=> '电子邮件已成功确认。',
	'EmailNotConfirmed'			=> '无法确认电子邮件。 这可能是由于确认代码不正确或电子邮件地址可能已被确认。 您可以通过登录并在 %1 页面上查看其状态来检查电子邮件地址是否已被确认。',
	'EmailNotVerified'			=> '电子邮件未验证！',
	'EmailNotVerifiedDesc'		=> '您将不会收到有关已观看页面的更改或评论的通知，' .
									'来自其他用户的消息，以及您<strong>将无法恢复忘记的密码</strong>，' .
									'在您的电子邮件地址得到确认之前，请点击发送给您的电子邮件中的链接。 ' .
									'如果在注册后的几天内您从未收到电子邮件，请单击',

	'ForgotPasswordHint'		=> '输入您的登录名和电子邮件地址，' . "\n" . '然后将向您发送包含说明的电子邮件。',
	'ForgotPassword'			=> '忘记密码？',
	'UserNotFound'				=> '未找到具有此名称或电子邮件地址的用户。',
	'NotConfirmedEmail'			=> '您的电子邮件地址未确认。<br>无法将邮件发送到未确认的地址。',
	'EmailForgotSubject'		=> '密码续订 ',
	'EmailForgotMessage'		=> '有人（也许是您）忘记了 %1 的密码。' . "\n" . '您的登录名：%2'."\n\n" . '单击链接或将其复制到浏览器地址行以更改您的密码。' . "\n" . '%3'."\n\n",
	'CodeWasSent'				=> '密码恢复说明已通过电子邮件发送给您。',
	'WrongCode'					=> '错误的代码',
	'ChangePasswordForUser'		=> '%1 的密码更改',

	'Watchers'					=> '%1 的关注列表',
	'WatchersFor'				=> '关注 ',
	'NoWatchers'				=> '%1 没有关注者',
	'NotOwnerToViewWatchers'	=> '您不是此页面的所有者，您无法查看该页面的关注者列表。',

	// thumbnail
	'TbnError'					=> '创建缩略图出错：%1',
	'TbnImageAreaTooBig'		=> '尺寸超过%1的文件',
	'TbnImageMissing'			=> '文件可能丢失：%1',

	// admin_recovery action
	'GenerateRecoveryHash'		=> '为您的 <code>recovery_password</code> 生成密码哈希',

	// import action
	'ImportTo'					=> '导入集群：',
	'ImportWhat'				=> '用于导入的 XML 文件：',
	'ImportButton'				=> '导入',
	'ImportSuccess'				=> '导入成功。',
	'ImportFailed'				=> '导入失败。',
	'ImportHint'				=> '请提供您要导入的集群，不要提供相对地址。',
	'ImportAttention'			=> '注意：覆盖集群中的相同页面。',
	'ImportNote'				=> '已导入页面',

	// mywatches action
	'WatchedPages'				=> '您为更改而关注的所有页面的列表 ',
	'UnwatchedPages'			=> '您未关注的所有页面的列表',
	'NoWatchedPages'			=> '您没有关注的页面。',
	'NoUnwatchedPages'			=> '你关注的所有页面的变化。',
	'ViewWatchedPages'			=> '显示关注的页面',
	'ViewUnwatchedPages'		=> '显示未关注的页面',
	'NotLoggedInWatches'		=> '您尚未登录，因此我们无法识别您的关注列表。',

	// mychangeswatches action
	'MyChangesWatches'			=> '自上次编辑以来您关注过的所有其他人编辑的页面的列表',
	'ResetChangesWatches'		=> '重置更改列表',
	'NoChangesWatches'			=> '在您关注的页面中没有任何变化...',

	// whatsnew action
	'NewCommentAdded'			=> '添加新评论',
	'NewFileAdded'				=> '添加新文件',
	'NewPageCreated'			=> '创建新页面',
	'NewRevisionAdded'			=> '页面移动完毕',
	'Cluster'					=> '集群',
	'PageDeleted'				=> '页面已删除',
	'CommentDeleted'			=> '评论已删除',
	'FileDeleted'				=> '文件已删除',

	// users action
	'UsersSearch'				=> '搜索用户',
	'UsersOpenProfile'			=> '查看用户资料',
	'UsersNoMatching'			=> '找不到匹配的用户。试试更柔和的搜索条件。',
	'UsersName'					=> '文件名',
	'UsersPages'				=> '页面',
	'UsersChanges'				=> '更改',
	'UsersSubscription'			=> '订阅',
	'UsersWatches'				=> '关注',
	'UsersComments'				=> '评论',
	'UsersUploads'				=> '上传',
	'UploadQuota'				=> '使用空间',
	'UploadQuotaTip'			=> '上传Space Quota',
	'UsersLogins'				=> '登录名',
	'UsersRevisions'			=> '修订版本',
	'UsersSignup'				=> '注册',
	'UsersLastSession'			=> '最后会话',
	'UsersNotFound'				=> '未找到用户 %2。 单击<a href="%1">此处</a>，转到主列表。',
	'UsersProfile'				=> '用户信息',
	'UsersContact'				=> '联络表',
	'UsersList'					=> '查看整个用户列表',
	'UsersNA'					=> '[未设置]',
	'UsersNA2'					=> '[否]',
	'UsersSignupDate'			=> '注册日期',
	'UsersGroupMembership'		=> '组成员',
	'UsersPersonalInfo'			=> '个人信息',
	'UsersOwnedPages'			=> '拥有的页面：',
	'UsersCommentsPosted'		=> '发表的评论：',
	'UsersFilesUploaded'		=> '上传的文件：',
	'UsersRevisionsMade'		=> '所做的修订：',
	'UsersDocsSortName'			=> '[以名称排序]',
	'UsersDocsSortCreation'		=> '[创建日期排序]',
	'UsersChangesSortAsc'		=> '[升序排列]',
	'UsersChangesSortDesc'		=> '[降序排列]',
	'UsersSessionNA'			=> '[未记录]',
	'UsersSessionHidden'		=> '[隐藏]',
	'IntercomSubject'			=> '主题：',
	'IntercomMessage'			=> '消息：',
	'IntercomCopy'				=> '给我一份副本',
	'IntercomSubjectN'			=> '[发新贴]',
	'IntercomDisabled'			=> '抱歉，您不想要或无法接收个人消息。',
	'IntercomHint'				=> '如果你想回复你收到的个人消息，请先登录并再次点击链接。',
	'IntercomDesc'				=> '发送电子邮件地址收件人携带的个人消息，而不会泄露您的地址。收件人可以使用您个人资料页面上的类似表格来回复您。',
	'PMOversized'				=> '消息长度超出了允许的最大大小 %1 。请缩短您的信息并再次提交。',
	'PMFlooded'					=> '发送个人消息之间的间隔不应小于 %1 秒。',
	'PMSent'					=> '已成功将个人消息发送给用户。',
	'PMBody'					=> '此消息已由用户 %1 发送给您。',
	'PMBodyCopy'				=> '你向用户%1发送了以下信息。',
	'PMReply'					=> '要回复此电子邮件，请单击以下链接（不要使用回复按钮/邮件回复）：',
	'PMNotLoggedIn'				=> '您未在系统中注册，无法向用户发送个人消息。',

	// admin_replace action
	'ReplaceText'				=> '替换文字',
	'TextOriginal'				=> '原文字：',
	'TextReplacement'			=> '替换文字：',
	'ReplaceTextRegex'			=> '使用正则表达式',
	'Namespace'					=> '命名空间：',
	'ReplaceTextCluster'		=> '只在这个集群内搜索和替换：',
	'ReplaceTextEditPages'		=> '仅在页面内容中替换',
	'ReplaceTextEditComments'	=> '替换注释中的文本',
	'ReplaceTextEditTitles'		=> '替换页面标题中的文本',
	'ReplaceTextGiveTarget'		=> '必须指定查找的字符串。',
	'ReplaceTextNoNamespace'	=> '您必须选择至少一个命名空间。',
	'ReplaceTextNoDifference'	=> '替换文本和目标文本之间没有区别。',
	'ReplaceTextNoOption'		=> '必须选择至少一个替换选项。',
	'ReplaceTextPagesEdit'		=> '在以下%3页面}}的文本中，将%1替换成%2：',
	'ReplaceTextTitlesEdit'		=> '用%2替换以下%3页的标题中的%1：',
	'ReplaceTextReplace'		=> '替换',
	'ReplaceTextSuccess'		=> '在%3个页面中，%1将被替换为%2。',
	'ReplaceTextNoMatch'		=> '找不到包含字符串%1的页面。',
	'ReplaceTextNoTitleMatch'	=> '找不到标题包含%1的页面。',
	'ReplaceTextEditFailed'		=> '替换文本失败',
	'ReplaceTextTitleTooBig'	=> '原始或替换的文本对标题来说太大。',
	'ReplaceTextReturn'			=> '返回表格',
	'ReplaceTextWarning'		=> '警告：有%1个页面已经包含替换字符串%2。如果您进行此次替换，您将无法从这些字符串中分离您的替换文字。',
	'ReplaceTextBlankWarning'	=> '警告：因为替换字串为空，此次操作将不可逆。',
	'ReplaceTextEditSummary'	=> '文本替换： %1 → %2',
	'InvertSelection'			=> '反选',

	// Properties
	'PropertiesFor'				=> ' %1 的页面属性',
	'MetaTag'					=> '标签',
	'MetaTitle'					=> '标题',
	'MetaKeywords'				=> '关键词',
	'MetaDescription'			=> '描述',
	'On'						=> '开启',
	'Off'						=> '关闭',
	'Registered'				=> '已注册',
	'MetaComments'				=> '显示评论',
	'MetaFiles'					=> '显示文件面板',
	'MetaToc'					=> '显示目录',
	'MetaIndex'					=> '显示集群面板',
	'MetaIndexMode'				=> '显示级别模式',
	'MetaIndexFull'				=> '树',
	'MetaIndexUpper'			=> '上升',
	'MetaIndexLower'			=> '降低',
	'MetaHtml'					=> '对HTML的支持',
	'MetaSafeHtml'				=> '过滤不安全的HTML',
	'MetaTypografica'			=> '排版校对器',
	'MetaNoIndex'				=> '阻止搜索引擎',
	'SettingsID'				=> '页面ID',
	'SettingsSize'				=> '大小',
	'SettingsSizeTip'			=> '源码 / 编译',
	'SettingsCreated'			=> '创建',
	'SettingsCurrent'			=> '修改时间',
	'SettingsTotalRevs'			=> '修订版本',
	'SettingsTotalComs'			=> '评论',
	'SettingsWatchers'			=> '关注者',
	'SettingsHits'				=> '视图',
	'SettingsText'				=> '设置',
	'SettingsEdit'				=> '编辑',
	'SettingsRevisions'			=> '修订版本',
	'SettingsClone'				=> '克隆',
	'SettingsRename'			=> '重命名',
	'MassRename'				=> '针对整个集群',
	'SettingsRemove'			=> '删除',
	'SettingsPurge'				=> '清理',
	'SettingsModerate'			=> '管理',
	'SettingsPermissions'		=> '权限',
	'AclForEntireCluster'		=> '针对整个集群',
	'SettingsAttachments'		=> '附件',
	'SettingsUpload'			=> '上传',
	'SettingsCategories'		=> '类别',
	'SettingsLanguages'			=> '语言',
	'SettingsReferrers'			=> '反向連接',
	'SettingsWatch'				=> '监视',
	'SettingsLatex'				=> 'LaTeX版本',
	'SettingsXML'				=> '导出到XML',
	'NeedToChangeLang'			=> '不支持的页面语言 %1 需要更改。',
	'SetLang'					=> '本页语言',
	'SetMenuLabel'				=> '菜单标签',
	'SetShowMenuLabel'			=> '在导航中显示',

	// upload
	'UploadFiles'				=> '文件上传',
	'UploadFor'					=> '文件上传：',
	'UploadButton'				=> '上传',
	'UploadGlobalText'			=> '公共访问',
	'UploadGlobal'				=> '全局',
	'UploadLocalText'			=> '仅适用于被允许查看当前页面的用户',
	'UploadAsName'				=> '文件名：',
	'UploadOverwrite'			=> '覆盖已存在的同名文件',
	'FileDesc'					=> '描述：',
	'UploadForbidden'			=> '您不能在此处上传文件。',
	'UploadOverwriteDenied'		=> '只有文件所有者或管理员可以覆盖%1的文件。',
	'UploadNoFile'				=> '由于某种原因，没有表单中的文件。',
	'UploadMaxSizeReached'		=> '文件大小超过了允许的限制！',
	'UploadDirNotWritable'		=> '文件目录不可写！',
	'UploadNotAPicture'			=> '只允许上传图片，你想上传什么？',
	'UploadEmptyExtension'		=> '文件名和扩展名不能为空。',
	'FilenameTooLong'			=> '文件名不能超过240字节。',
	'BannedFiletype'			=> '%1 不是允许的文件类型。',
	'PermittedFiletype'			=> '允许的文件类型：',
	'UploadMimeMismatch'		=> '文件扩展名%1与检测到的文件MIME类型（%2）不匹配。',
	'UploadBadMime'				=> 'MIME类型为%1的文件已被禁止上传。',
	'FileIsDuplicate'			=> '上传的文件与的当前版本完全相同。',
	'FileHasDuplicate'			=> '本文件是以下文件的副本：',

	'UploadMaxFileQuota'		=> '您已达到上传限制，无法上传此文件',
	'UploadDone'				=> '文件上传成功',
	'UploadFileForbidden'		=> '文件访问被禁止',
	'UploadTitle'				=> '可从此页面访问的文件',
	'UploadTitleGlobal'			=> '可从任何地方访问的文件',

	'UploadFile'				=> '上传',
	'UploadMax'					=> '不超过 ',
	'UploadUsedStorage'			=> '使用中的存储 ',

	// attachments
	'Attachments'				=> '附件',
	'Attachment'				=> '附件',
	'AttachmentsToPage'			=> '到页面',
	'AttachmentsToCluster'		=> '到集群',
	'AttachmentsByTime'			=> '按时间',
	'AttachmentsGlobal'			=> '全局',
	'AttachmentsAll'			=> '全部',
	'AttachmentsLinked'			=> '已使用',

	'FileViewProperties'		=> '查看',
	'FileViewPropertiesTip'		=> '查看此文件的元数据',
	'FileEditProperties'		=> '编辑',
	'FileEditPropertiesTip'		=> '编辑此文件的元数据',
	'FileEditedMeta'			=> '此文件已更新元数据',
	'FileEditDenied'			=> '您无权编辑此文件',
	'FileLabel'					=> '标记',
	'FileLabelTip'				=> '标记此文件',
	'FileRemove'				=> '删除',
	'FileRemovedFromDB'			=> '从数据库中删除的文件',
	'FileRemovedFromFS'			=> '从物理主机中删除的文件',
	'FileRemovedFromFSError'	=> '删除文件似乎是不可能的！',
	'FileRemoveConfirm'			=> '确定删除此文件？',
	'FileRemoveDenied'			=> '您无权删除此文件',
	'FileNotFound'				=> '文件未找到。',

	'FileSearch'				=> '搜索文件：',
	'UploadBy'					=> '上传者：',
	'FileAdded'					=> '文件添加完毕：',
	'FileModified'				=> '修改时间：',
	'FileSize'					=> '文件大小：',
	'FileDimension'				=> '大小：',
	'MimeType'					=> 'MIME 类型：',
	'FileName'					=> '文件名：',
	'FileCaption'				=> '标题：',
	'FileAuthor'				=> '作者：',
	'FileSource'				=> '源：',
	'FileSourceUrl'				=> 'URL：',
	'FileAttachedTo'			=> '附加到：',
	'FileSyntax'				=> '句法：',
	'FileAbsolutePath'			=> '绝对路径',
	'FileRelativePath'			=> '相对路径',
	'FileUsage'					=> '文件用途：',
	'FileUsageText'				=> '以下个页面使用本文件：',
	'NoFileUsage'				=> '没有页面链接本文件',

	'FileSortExt'				=> '扩展',
	'FileSortName'				=> '文件名',
	'FileSortSize'				=> '文件大小',
	'FileSortTime'				=> '文件添加完毕',

	'SortBy'					=> '排序：',
	'Ascending'					=> '升序',
	'Decending'					=> '降序',

	'Files0'					=> '附件',
	'Files1'					=> '显示文件（1个文件）',
	'FilesN'					=> '显示文件（%1个文件）',
	'Files'						=> '文件',
	'File'						=> '文件',
	'ShowFiles'					=> '显示文件表单',
	'HideFiles'					=> '隐藏文件表单',
	'DoShowFiles'				=> '默认显示文件列表',
	'NoAttachments'				=> '没有要显示的附件。',

	'RegistrationLang'			=> '你的语言',
	'InvalidWikiName'			=> '选择的名称无效',
	'InvalidUserName'			=> '选择的用户名无效',
	'Bookmarks'					=> '收藏夹',
	'ReallyDeleteComment'		=> '您真的要删除此评论吗？<br>此操作无法撤消！',
	'ReallyDeleteRevision'		=> '您真的要删除此修订吗？<br>此操作无法撤消！',

	'RegistrationClosed'		=> '未开放注册。 请联系管理员',
	'AclAreYouSure'				=> '您将更改此页面及其所有子页面的 ACL。 继续？',

	'BookmarkDeleteSelected'	=> '删除选中的',
	'BookmarkMark'				=> '标记',
	'BookmarkNumber'			=> '第',
	'BookmarkNone'				=> '您没有收藏。',
	'BookmarkTitle'				=> '书签标题',
	'BookmarkPage'				=> '页面',
	'BookmarkSaveChanges'		=> '保存更改',
	'BookmarksAddPage'			=> '为以下页面设置书签：',
	'BookmarkAlreadyExists'		=> '书签已存在',

	'PoweredBy'					=> '构建于',

	'MassRenaming'				=> '重命名整个集群',
	'MassNewName'				=> '输入此集群的新名称',
	'MassNeedRedirect'			=> '在旧页面上创建重定向到新页面',

	// pagination
	'ToOverview'				=> '返回总览',
	'ToThePage'					=> '翻页：',
	'Next'						=> '下一页',
	'Prev'						=> '上一页',
	'NextAcr'					=> '下一页',
	'PrevAcr'					=> '上一页',
	'Back'						=> '返回',

	// filter
	'Filter'					=> '筛选',
	'OptionalFilters'			=> '可选过滤器：',
	'Any'						=> '所有',

	// My Groups
	'UserGroups'				=> '用户组',
	'MyGroups'					=> '关联组',
	'Group'						=> '组',
	'Groups'					=> '群组',

	// license action
	'DistributedUnder'			=> '素材分布如下',
	'AuthorsDisplayHint'		=> '保存页面时将显示作者列表。',
	'AnonymousUsers'			=> '匿名用户',
	'License'					=> '许可',
	'LicenseArray'				=> [
		'1'		=> '署名-禁止演绎许可协议',
		'2'		=> '署名-非商业性使用-相同方式共享许可协议',
		'3'		=> '署名-非商业性使用-禁止演绎许可协议',
		'4'		=> '署名-相同方式共享许可条款',
		'5'		=> '署名-非商业性使用许可协议',
		'6'		=> '属性',
		'7'		=> 'CC0 1.0 Universal',
		'8'		=> 'GNU 自由文档许可证',
		'9'		=> '公有领域',
		'10'	=> '版权所有',
	],
	'LicenseMeta'				=> [
		'1'		=> '公有领域',
		'2'		=> '保留部分权利',
		'3'		=> '版权所有',
	],

	// Cache
	'ClearCache'				=> '清空缓存',
	'CacheCleared'				=> '缓存清理完毕。',
	'ConfigCache'				=> '设置缓存',
	'FeedCache'					=> '信息流缓存',
	'PageCache'					=> '页面缓存',
	'SQLCache'					=> 'SQL缓存',
	'TemplateCache'				=> '模板缓存',
	'ThumbCache'				=> '缩略图缓存',

	// Embed
	'EmbedNoURL'				=> '请使用参数 url 指定媒体资源的地址。 （例如 {{embed url="https://example.com/embed/video.mp4"}} ）',

	// Feed
	'FeedTitle'					=> '信息流标题',
	'FeedMulti'					=> '多媒体信息流',
	'FeedNoURL'					=> '请使用参数url指定信息流。（例如，{{feed url=”https://example.com/feed.xml"}} ）',
	'FeedError'					=> '无法加载或解析 Feed',
	'FeedSource'				=> '来源：',
	'FeedXMLTip'				=> '',

	// XML / RSS autodiscovery
	'ChangesXMLTitle'			=> ' - 最近更改',
	'ChangesXML'				=> '最新改变 ',
	'CommentsXMLTitle'			=> ' - 最近的评论',
	'CommentsXML'				=> '最近的评论 ',
	'NewsXMLTitle'				=> ' - 最近的新闻',
	'NewsXML'					=> '最近的新闻 ',
	'RevisionXMLTip'			=> '单击以查看 XML 格式的最新页面修订。',
	'CommentsXMLTip'			=> '单击以查看 XML 格式的最新评论。',
	'ChangesXMLTip'				=> '单击以查看 XML 格式的最新更改。',
	'NewsXMLTip'				=> '单击以查看 XML 格式的最新新闻。',
	'RevisionsXML'				=> '的修订 ',
	'ExportClusterXML'			=> '导出整个集群 ',
	'AccessDeniedXML'			=> '您无权访问此信息。',

	'ChangesFeed'				=> '更改',
	'CommentsFeed'				=> '评论',
	'NewsFeed'					=> '新闻动态',
	'RevisionsFeed'				=> '的修订 ',

	'LastModification'			=> '最后修改',

	// Captcha
	'Captcha'					=> '请输入您在图片中看见的文字',
	'CaptchaFailed'				=> '您输入的验证码不正确。 请再试一次。',
	'CaptchaReload'				=> '新验证码',
	'CaptchaReloadWarning'		=> '抱歉，无法重新加载验证码图片，您必须重新加载页面才能执行此操作',

	// news
	'News'						=> '新闻动态',
	'NewsName'					=> '标题：',
	'NewsNoName'				=> '您忘记添加新闻标题。',
	'NewsNotAvailable'			=> '没有可用的新闻。',
	'NewsNoClusterDefined'		=> '未定义新闻集群。',
	'NewsDiscuss'				=> '讨论这篇文章...',

	// blog
	'BlogNewTopic'				=> '发布新内容',
	'NoPostAvailable'			=> '没有可用的帖子',

	// Review
	'Reviewer'					=> '审稿人',
	'Reviewed'					=> '已审核',
	'Review'					=> '审查',
	'ReviewedBy'				=> '审核人',
	'RemoveReview'				=> '删除此页面的评论',
	'SetReview'					=> '审查了这个页面',
	'SetAsReviewed'				=> '将页面设置为已审核',
	'SetAsUnreviewed'			=> '将页面设置为未审核',

	// word filter
	'PotentialSpam'				=> '已识别的潜在垃圾信息',

	// moderation handler
	'Moderation'				=> '版主',
	'Topics'					=> '主题',
	'ModerateSection'			=> '节/页 ',

	'NotModerator'				=> '您无权管理此页面/章节',
	'ModerateDeleteTopic'		=> '删除主题 / 页',
	'ModerateDeletePosts'		=> '删除帖子',
	'ModerateMove'				=> '移动',
	'ModerateSplit'				=> '拆分/移动评论',
	'ModerateMerge'				=> '合并',
	'ModerateLock'				=> '锁定',
	'ModerateUnlock'			=> '解锁',
	'ModerateAccept'			=> '接受',
	'ModerateDeleteConfirm'		=> '您确定要<strong>删除</strong>以下主题吗？',
	'ModerateRenameConfirm'		=> '为所选页面输入新标题',
	'ModerateRenameExists'		=> '页面同名已经存在！ 选择一个不同的名称。',
	'ModerateRename1Only'		=> '注意：只有您选择的第一页会被重命名！',
	'ModerateMovesConfirm'		=> '选择要移动论坛的目标分区',
	'ModerateMoveConfirm'		=> '选择论坛或指定集群以移动这些主题。 要将页面移动到站点的根目录，请键入“/”；',
	'ModeratePgMoveConfirm'		=> '指定要放置页面的集群的名称。 要将页面移动到站点的根目录，请键入“/”；',
	'ModerateMoveExists'		=> '操作中止：此部分中已存在同名 %1 的主题。 如果您还需要转移上述主题，请先重命名。',
	'ModerateMoveNotExists'		=> '页面/集群不存在。 请检查名称并重试。',
	'ModerateMergeConfirm'		=> '选择一个主题，它应该结合其余的',
	'ModerateMerge2Min'			=> '要加入，您必须至少选择两个主题！',
	'ModerateComDelConfirm'		=> '您确定要<strong>删除</strong> %1 %2 吗？',
	'ModerateComment'			=> '评论',
	'ModerateComments'			=> '评论',
	'ModerateSplitNewName'		=> '指定可分离主题的名称并选择分离模式',
	'ModerateSplitPageName'		=> '输入页面/主题的名称，可分离评论的移动位置，并选择分离模式',
	'ModerateSplitAllAfter'		=> '在第一个选择（包括）之后分离所有评论',
	'ModerateSplitSelected'		=> '仅分隔选定的评论（共 %1 个）',
	'ModerateUserProfile'		=> '用户信息',
	'ModerateNoItemChosen'		=> '请通过设置按钮选择至少一项。',

	'ModerateSection2'			=> '管理版块',
	'ModerateTopicsDeleted'		=> '所选主题已成功删除。',
	'ModerateTopicsRelocated'	=> '所选主题已成功迁移。',
	'ModerateTopicsRenamed'		=> '主题已成功重命名。',
	'ModerateTopicsMerged'		=> '所选主题已成功合并。',
	'ModerateTopicsBlocked'		=> '所选主题已成功屏蔽',
	'ModerateTopicsUnlocked'	=> '所选主题已成功解锁。',
	'ModerateTopicDeleted'		=> '主题已成功删除。',
	'ModeratePageMoved'			=> '页面已成功移动。',
	'ModerateTopicRenamed'		=> '主题已成功重命名。',
	'ModerateTopicBlocked'		=> '话题成功屏蔽',
	'ModerateTopicUnlocked'		=> '话题成功解锁。',
	'ModerateCommentsDeleted'	=> '所选评论已成功删除。',
	'ModerateCommentsSplit'		=> '所选评论已成功分离到新主题中。',
	'ModerateCommentsSplitFailed'	=> '注意：由于某种原因，将所选评论与新主题分开失败。<br>通常这不应该发生，因此请让事件站点管理员处理。<br>作为预防措施，问题已保留为原始形式。',
	'ModerateCommentsMoved'		=> '所选评论已成功迁移到给定页面。',

	// forum
	'ForumSubforums'			=> '论坛',
	'ForumTopic'				=> '主题',
	'ForumTopics'				=> '主题',
	'ForumPosts'				=> '文章',
	'ForumReplies'				=> '回复',
	'ForumAuthor'				=> '作者',
	'ForumViews'				=> '视图',
	'ForumCreated'				=> '创建',
	'ForumComments'				=> '评论',
	'ForumLastComment'			=> '最新评论',
	'ForumNoComments'			=> '没有评论。',
	'ForumNoTopics'				=> '暂无新内容。',
	'ForumNewTopic'				=> '发起新讨论',
	'ForumTopicName'			=> '标题：',
	'ForumTopicSubmit'			=> '发布',
	'ForumNoTopicName'			=> '指定新页面的名称。',
	'ForumNewPosts'				=> '新帖',
	'ForumLocked'				=> '部分封锁',
	'ForumUpdated'				=> '已更新',
	'ForumNoClusterDefined'		=> '没有定义论坛集群',
	'ForumOutsideCluster'		=> '确保 %1 操作位于论坛集群内。',

	// password complexity
	'PwdCplxShort'				=> '密码太短了。',
	'PwdCplxEquals'				=> '密码包含用户名。',
	'PwdCplxWeak'				=> '密码不符合复杂性要求。',
	'PwdCplxDesc1'				=> '密码要求： ',
	'PwdCplxDesc2'				=> '密码不能少于 %1 个字符，不能包含用户名',
	'PwdCplxDesc3'				=> '不能包含你的用户名',
	'PwdCplxDesc4'				=> '应该包括 ',
	'PwdCplxDesc41'				=> '字母和数字',
	'PwdCplxDesc42'				=> '大写和小写字母和数字',
	'PwdCplxDesc43'				=> '大写和小写字母、数字和非字母字符',
	'PwdCplxDesc5'				=> '您可以使用任何字母、数字和特殊字符，除了空格。',

	'PasswordTooShort'			=> '密码太短了。',
	'PasswordTooCommon'			=> '密码太简单了。',
	'PasswordSameAsUsername'	=> '您的密码与用户名相同。',
	'PasswordSameAsEmail'		=> '您的密码与邮箱同名',

	'Timezone'					=> '时区',

	'LanguageArray'	=> [
		'bg' => '保加利亚语',
		'da' => '丹麦文',
		'de' => '德语',
		'el' => '希腊语',
		'en' => '英语',
		'es' => '西班牙语',
		'et' => '爱沙尼亚语',
		'fa' => '波斯语',
		'fr' => '法语',
		'hi' => '印地语',
		'hu' => '匈牙利文',
		'it' => '意大利语',
		'ja' => '日语',
		'ko' => '韩文',
		'nl' => '荷兰语',
		'pl' => '波兰语',
		'pt' => '葡萄牙语',
		'ru' => '俄语',
		'zh' => '简体中文',
		'zh-tw' => '繁体中文',
	],

	'AccountStatus'				=> '账户状态',
	'AccountStatusArray' => [
		'0' => '活动',
		'1' => '待审核',
		'2' => '锁定',
		'3' => '无效',
	],

	'JustNow'		=> '当前',
	'MinuteAgo'		=> '1分钟前',
	'MinutesAgo'	=> '%1 分钟前',
	'HourAgo'		=> '1小时前',
	'HoursAgo'		=> '%1 小时前',
	'DayAgo'		=> '昨天',
	'DaysAgo'		=> '%1 天前',
	'WeekAgo'		=> '一周前',
	'WeeksAgo'		=> '%1 周前',
	'MonthAgo'		=> '1学月前',
	'MonthsAgo'		=> '%1 月前',
	'YearAgo'		=> '一年前',
	'YearsAgo'		=> '%1 年前',

	'InAMoment'		=> '一会儿',
	'InAMinute'		=> '1分钟内',
	'InMinutes'		=> ' %1 分钟内',
	'InAnHour'		=> '1小时内',
	'InHours'		=> ' %1 小时内',
	'Tomorrow'		=> '明天',
	'InDays'		=> ' %1 天内',
	'InAWeek'		=> '一周内',
	'InWeeks'		=> ' %1 周内',
	'InAMonth'		=> '一月内',
	'InMonths'		=> ' %1 月内',
	'InAYear'		=> '一年内',
	'InYears'		=> ' %1 年内',

	// norm multiples
	'ByteDecimalShort'			=> ['B', 'KB', 'MB', 'GB', 'TB', 'PB', 'EB', 'ZB', 'YB'],
	'ByteDecimalLong'			=> ['字节', 'Kilobyte', 'Megabyte', 'Gigabyte', 'Terabyte', 'Petabyte', 'Exabyte', 'Zettabyte', 'Yottabyte'],
	'ByteBinaryShort'			=> ['B', 'KiB', 'MiB', 'GiB', 'TiB', 'PiB', 'EiB', 'ZiB', 'YiB'],
	'ByteBinaryLong'			=> ['字节', 'Kibibyte', 'Mebibyte', 'Gibibyte', 'Tebibyte', 'Pebibyte', 'Exbibyte', 'Zebibyte', 'Yobibyte'],
	'PixelDecimalShort'			=> ['px', 'KP', 'MP', 'GP', 'TP', 'PP', 'EP', 'ZP', 'YP'],
	'PixelDecimalLong'			=> ['pixel', 'Kpx', 'Mpx', 'Gpx', 'Tpx', 'Ppx', 'Epx', 'Zpx', 'Ypx'],

	// loading error
	'UnknownAction'				=> '未知动作',
	'UnknownMethod'				=> '未知方法',
	'FormatterNotFound'			=> '未找到格式化程序 %1',

	// log
	'LogAdminLoginSuccess'		=> '成功登录到管理面板',
	'LogAdminLogout'			=> '注销管理面板',
	'LogAdminLoginFailed'		=> '!!授权进入管理面板失败!!',
	'LogAdminLoginLocked'		=> '锁定登录到管理面板',
	'LogUserCookieForged'		=> '!!**尝试使用登录 ##%1##** 登录伪造的 cookie!!',
	'LogInvalidFormToken'		=> '检测到正在进行的潜在 CSRF 攻击： %1',
	'LogRemovedPage'			=> '!!已删除页面 ##%1##（用户 %2）!!',
	'LogRemovedCluster'			=> '!!已删除 **集群** ##%1## （用户 %2）!!',
	'LogRemovedRevision'		=> '!!已删除版本 ##%3## 页[[/%1]] （用户 %2）!!',
	'LogRemovedComment'			=> '!!已删除评论 ##%3## 页[[/%1]] （用户 %2）!!',
	'LogRemovedFile'			=> '!!已从页面 ##%2## 移除文件 [[/%1]]!!',
	'LogRemovedAllComments'		=> '!!移除页面的所有评论 [[/%1]]!!',
	'LogRemovedAllRevisions'	=> '!!清除页面的所有修订]!!',
	'LogRemovedAllFiles'		=> '!!已移除所有文件，附加到[[/%1]]!!',
	'LogTopicLocked'			=> '论坛主题已锁定 [[/%1]]',
	'LogTopicUnlocked'			=> '解锁讨论主题 [[/%1]]',
	'LogAclUpdated'				=> '已更新 ACL 页面 [[/%1]]',
	'LogOwnershipChanged'		=> '拥有页面 [[/%1]] 被转移到用户 ##%2##',
	'LogUserLoginFailed'		=> '!!未成功尝试使用 ##~%1 ##登录！',
	'LogClonedPage'				=> '第## %1页## 克隆到 [[/%2]]',
	'LogRenamedPage'			=> '页面 ##%1## 重命名为 [[/%2]]',
	'LogRenamedPage2'			=> '。旧页面设置为与新页面的链接',
	'LogSplittedPage'			=> '页面[[/%1]] 上的评论已拆分到页面 [[/%2]]',
	'LogMergedPages'			=> '页面 %1 已合并到页面 [[/%2]]',
	'LogUserPasswordReminded'	=> '用户 ##%1## 请求密码恢复过程地址 ##%2##',
	'LogUserPasswordRecovered'	=> '用户 ##%1## 成功恢复他忘记的密码',
	'LogUserPasswordChanged'	=> '用户 ##%1## 已成功更新（更改） 他的密码',
	'LogUserPasswordMismatch'	=> '!!用户 ##%1## 更改密码失败：当前密码不匹配！',
	'LogUserIPSwitched'			=> '未授权的 IP 地址更改，用户 %1 从 %2 到 %3',
	'LogPageImported'			=> '导入页面 [[/%1]]',
	'LogSaveNoRights'			=> '没有适当的权限保存页面 [[/%1]]',
	'LogPageCreated'			=> '创建新页面 [[/%1]]',
	'LogPagePropertiesUpdated'	=> '已更新页面属性 [[/%1]]',
	'LogPageOwnershipClaimed'	=> '用户获得页面 [[/%1] ] 的所有权',
	'LogFileUploadedLocal'		=> '新文件 ##%2## 上传到页面 [[/%1]] （大小 %3）',
	'LogFileUploadedGlobal'		=> '新文件 ##%2## 上传到全局文件夹 （大小 %3）',
	'LogPMSent'					=> '个人消息 ##%1## -> ##%2## 成功发送',
	'LogUserSimilarName'		=> '尝试以相同的用户名注册：##%1##',
	'LogUserEmailNotAllowed'	=> '电子邮件##%1## 不在允许的域名列表',
	'LogRegisterTiming'			=> '注册失败，表单时间阈值为##%1##秒（原为##%2##）。',
	'LogUserRegistered'			=> '成功注册了一个新用户 ##%1## （##%2##）',
	'LogUserEmailActivated'		=> '成功激活邮箱 ##%1##  ，用户 ##%2##',
	'LogCommentPosted'			=> '添加 [[/%1 个新评论]] 到页面 [[/%2]]',
	'LogUserLoginOK'			=> '用户 ##%1## 成功登录到系统',
	'LogUserLoggedOut'			=> '用户 ##%1## 成功登出系统',
	'LogUserSessionContinued'	=> '用户 ##%1## 继续暂停的会话',
	'LogUserSettingsUpdate'		=> '用户 ##%1## 更新了个人设置',
	'LogPageEdited'				=> '已编辑页面 [[/%1]]',
	'LogCommentEdited'			=> '已编辑评论 [[/%1]]',
	'LogUpdatedFileMeta'		=> '从页面 [[/%1]] 更新文件元数据##%2## ',
	'LogUpdatedFileCategories'	=> '更新页面[[/%1]] 的文件类别##%2## ',

	'LogXmlSitemapGenerated'	=> '生成XML站点地图',
	'LogReferrersPurged'		=> '维护：已清除的来源',
	'LogRevisionsPurged'		=> '维护：删除了过时的页面修订',
	'LogDeletedPagesPurged'		=> '维护：删除页面已清除',
	'LogSystemLogPurged'		=> '维护：系统日志已清除',
	'LogCachedPagesPurged'		=> '维护：已清除缓存页面',
	'LogSqlCachePurged'			=> '维护：缓存的 sql 结果已清除',
	'LogExpiredTokensPurged'	=> '维护：已清除过期的 cookie_token',
	'LogErrorSplitComments'		=> '将评论与主题[[/%1]]分离时出错新主题##%2##：未创建页面',
	'LogCategoriesUpdated'		=> '更新的页面类别 [[/%1]]',
	'LogCategoryCreated'		=> '创建了一个新类别 //%1//',
	'LogCategoryRenamed'		=> '类别 ##%1## 重命名为 ##%2##',
	'LogCategoryDebundled'		=> '类别 ##%1## 已解绑',
	'LogCategoryGrouped'		=> '类别 ##%1## 与单词 ##%2## 分组',
	'LogCategoryRemoved'		=> '类别 ##%1## 从数据库中删除',

	'ErrorMinPHPVersion'		=> 'PHP版本必须大于 <strong>' . PHP_MIN_VERSION . '</strong>,' .
									' 你的服务器似乎在运行一个 <strong>' . PHP_VERSION . '</strong>。' .
									'  为了使WackoWiki能够正常工作，你应该升级到一个较新的PHP版本。',

];
