/*
 * Decompiled with CFR 0.152.
 */
package org.openoffice.xmerge.converter.xml.sxc;

import java.awt.Color;
import java.io.IOException;
import java.util.Vector;
import org.openoffice.xmerge.ConvertData;
import org.openoffice.xmerge.ConvertException;
import org.openoffice.xmerge.Document;
import org.openoffice.xmerge.DocumentSerializer;
import org.openoffice.xmerge.converter.xml.OfficeConstants;
import org.openoffice.xmerge.converter.xml.StyleCatalog;
import org.openoffice.xmerge.converter.xml.sxc.BookSettings;
import org.openoffice.xmerge.converter.xml.sxc.CellStyle;
import org.openoffice.xmerge.converter.xml.sxc.ColumnRowInfo;
import org.openoffice.xmerge.converter.xml.sxc.ColumnStyle;
import org.openoffice.xmerge.converter.xml.sxc.Format;
import org.openoffice.xmerge.converter.xml.sxc.NameDefinition;
import org.openoffice.xmerge.converter.xml.sxc.RowStyle;
import org.openoffice.xmerge.converter.xml.sxc.SpreadsheetEncoder;
import org.openoffice.xmerge.converter.xml.sxc.SxcDocument;
import org.openoffice.xmerge.util.Debug;
import org.openoffice.xmerge.util.XmlUtil;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SxcDocumentSerializer
implements OfficeConstants,
DocumentSerializer {
    private Color foreground = Color.black;
    private Color background = Color.white;
    private long format = 0L;
    private Format fmt = new Format();
    private int rowID = 1;
    private int colID = 1;
    private int rowsRepeated = 1;
    private int colsRepeated = 1;
    private StyleCatalog styleCat = null;
    private Vector ColumnRowList;
    private int displayWidth = 0;
    protected SpreadsheetEncoder encoder = null;
    protected SxcDocument sxcDoc = null;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$sxc$ColumnStyle;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$sxc$RowStyle;
    static /* synthetic */ Class class$org$openoffice$xmerge$converter$xml$sxc$CellStyle;

    public SxcDocumentSerializer(Document document) {
        this.sxcDoc = (SxcDocument)document;
    }

    protected void addCell(String string) throws IOException {
        int n = this.colID;
        int n2 = this.rowID;
        int n3 = 0;
        while (n3 < this.rowsRepeated) {
            if (n3 > 0) {
                Debug.log(4, "</TR>");
                Debug.log(4, "<TR>");
            }
            n = this.colID;
            int n4 = 0;
            while (n4 < this.colsRepeated) {
                Debug.log(4, "<TD>");
                this.encoder.addCell(n2, n, this.fmt, string);
                Debug.log(4, string);
                Debug.log(4, "</TD>");
                ++n;
                ++n4;
            }
            ++n2;
            ++n3;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private String getAttribute(Node node, String string) {
        Node node2;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null && (node2 = namedNodeMap.getNamedItem(string)) != null) {
            return node2.getNodeValue();
        }
        return null;
    }

    protected int getDecimalPlaces(Node node) {
        int n = 0;
        Element element = null;
        if (!(node instanceof Element)) {
            return n;
        }
        element = (Element)node;
        NodeList nodeList = element.getElementsByTagName("text:p");
        if (nodeList.getLength() != 1) {
            return n;
        }
        Node node2 = nodeList.item(0);
        if (node2.hasChildNodes()) {
            NodeList nodeList2 = node2.getChildNodes();
            int n2 = nodeList2.getLength();
            int n3 = 0;
            while (n3 < n2) {
                String string;
                int n4;
                Node node3 = nodeList2.item(n3);
                if (node3.getNodeType() == 3 && (n4 = (string = node3.getNodeValue()).lastIndexOf(".")) > 0) {
                    string = string.substring(n4 + 1);
                    n = string.length();
                }
                ++n3;
            }
        }
        return n;
    }

    protected void loadStyles(SxcDocument sxcDocument) {
        org.w3c.dom.Document document = sxcDocument.getContentDOM();
        this.styleCat = new StyleCatalog(25);
        NodeList nodeList = null;
        String[] stringArray = new String[]{"table-column", "table-row", "table-cell"};
        Class[] classArray = new Class[]{class$org$openoffice$xmerge$converter$xml$sxc$ColumnStyle != null ? class$org$openoffice$xmerge$converter$xml$sxc$ColumnStyle : (class$org$openoffice$xmerge$converter$xml$sxc$ColumnStyle = SxcDocumentSerializer.class$("org.openoffice.xmerge.converter.xml.sxc.ColumnStyle")), class$org$openoffice$xmerge$converter$xml$sxc$RowStyle != null ? class$org$openoffice$xmerge$converter$xml$sxc$RowStyle : (class$org$openoffice$xmerge$converter$xml$sxc$RowStyle = SxcDocumentSerializer.class$("org.openoffice.xmerge.converter.xml.sxc.RowStyle")), class$org$openoffice$xmerge$converter$xml$sxc$CellStyle != null ? class$org$openoffice$xmerge$converter$xml$sxc$CellStyle : (class$org$openoffice$xmerge$converter$xml$sxc$CellStyle = SxcDocumentSerializer.class$("org.openoffice.xmerge.converter.xml.sxc.CellStyle"))};
        nodeList = document.getElementsByTagName("office:automatic-styles");
        if (nodeList.getLength() != 0) {
            this.styleCat.add(nodeList.item(0), stringArray, classArray, null, false);
        }
    }

    public abstract ConvertData serialize() throws ConvertException, IOException;

    protected void traverseBody(Node node) throws IOException {
        Debug.log(4, "<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        Debug.log(4, "<DEBUGLOG>");
        if (node.hasChildNodes()) {
            Object object;
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    object = node2.getNodeName();
                    if (((String)object).equals("table:named-expressions")) {
                        this.traverseNamedExpressions(node2);
                    } else {
                        Debug.log(4, "Skipping " + XmlUtil.getNodeInfo(node2) + " />");
                    }
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < n) {
                object = nodeList.item(n3);
                if (object.getNodeType() == 1) {
                    String string = object.getNodeName();
                    if (string.equals("table:table")) {
                        this.traverseTable((Node)object);
                    } else {
                        Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo((Node)object) + " />");
                    }
                }
                ++n3;
            }
        }
        Debug.log(4, "</DEBUGLOG>");
    }

    /*
     * Unable to fully structure code
     */
    protected void traverseCell(Node var1_1) throws IOException {
        block34: {
            var2_2 = var1_1.getAttributes();
            var3_3 = 0;
            var4_4 = null;
            this.fmt.clearFormatting();
            if (var2_2 != null && var2_2.item(0) != null) ** GOTO lbl9
            Debug.log(1, "No Cell Attributes\n");
            break block34;
lbl-1000:
            // 1 sources

            {
                Debug.log(1, "Cell Attribute " + var3_3 + ": " + var4_4.getNodeName() + " : " + var4_4.getNodeValue() + "\n");
lbl9:
                // 2 sources

                ** while ((var4_4 = var2_2.item((int)var3_3++)) != null)
            }
        }
        var5_5 = var2_2.getNamedItem("table:value-type");
        var6_6 = var2_2.getNamedItem("table:number-columns-repeated");
        var7_7 = var2_2.getNamedItem("table:style-name");
        var8_8 = new String("");
        if (var7_7 != null) {
            var8_8 = var7_7.getNodeValue();
        }
        if (var8_8.equalsIgnoreCase("Default")) {
            Debug.log(4, "No defined Style Attribute was found");
        } else if (var8_8.length() != 0) {
            var9_9 = (CellStyle)this.styleCat.lookup(var8_8, "table-cell", null, SxcDocumentSerializer.class$org$openoffice$xmerge$converter$xml$sxc$CellStyle != null ? SxcDocumentSerializer.class$org$openoffice$xmerge$converter$xml$sxc$CellStyle : (SxcDocumentSerializer.class$org$openoffice$xmerge$converter$xml$sxc$CellStyle = SxcDocumentSerializer.class$("org.openoffice.xmerge.converter.xml.sxc.CellStyle")));
            var10_13 = var9_9.getFormat();
            this.fmt = new Format((Format)var10_13);
        }
        if (var6_6 != null) {
            var9_9 = var6_6.getNodeValue();
            var10_13 = new Integer((String)var9_9);
            this.colsRepeated = var10_13.intValue();
        } else {
            this.colsRepeated = 1;
        }
        if (this.fmt.isDefault() && var8_8.length() == 0) {
            var9_10 = 1;
            var10_13 = this.ColumnRowList.elements();
            while (var10_13.hasMoreElements()) {
                var11_14 = (ColumnRowInfo)var10_13.nextElement();
                if (!var11_14.isColumn()) continue;
                if (this.colID >= var9_10 && this.colID < var9_10 + var11_14.getRepeated()) {
                    this.fmt = new Format(var11_14.getFormat());
                }
                var9_10 += var11_14.getRepeated();
            }
        }
        if (var5_5 != null) {
            this.displayWidth = 0;
            var9_11 = var5_5.getNodeValue();
            if (var9_11.equalsIgnoreCase("string")) {
                this.fmt.setCategory("string");
                var10_13 = var2_2.getNamedItem("table:string-value");
                Debug.log(4, "Cell Type String :  " + var10_13);
                if (var10_13 != null) {
                    this.fmt.setValue(var10_13.getNodeValue());
                }
            } else if (var9_11.equalsIgnoreCase("float")) {
                this.fmt.setCategory("float");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(var1_1));
                var10_13 = var2_2.getNamedItem("table:value");
                this.fmt.setValue(var10_13.getNodeValue());
            } else if (var9_11.equalsIgnoreCase("time")) {
                this.fmt.setCategory("time");
                var10_13 = var2_2.getNamedItem("table:time-value");
                this.fmt.setValue(var10_13.getNodeValue());
            } else if (var9_11.equalsIgnoreCase("date")) {
                this.fmt.setCategory("date");
                var10_13 = var2_2.getNamedItem("table:date-value");
                this.fmt.setValue(var10_13.getNodeValue());
            } else if (var9_11.equalsIgnoreCase("currency")) {
                this.fmt.setCategory("currency");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(var1_1));
                var10_13 = var2_2.getNamedItem("table:value");
                this.fmt.setValue(var10_13.getNodeValue());
            } else if (var9_11.equalsIgnoreCase("boolean")) {
                this.fmt.setCategory("boolean");
                var10_13 = var2_2.getNamedItem("table:boolean-value");
                this.fmt.setValue(var10_13.getNodeValue());
            } else if (var9_11.equalsIgnoreCase("percentage")) {
                this.fmt.setCategory("percentage");
                this.fmt.setDecimalPlaces(this.getDecimalPlaces(var1_1));
                var10_13 = var2_2.getNamedItem("table:value");
                this.fmt.setValue(var10_13.getNodeValue());
            } else {
                Debug.log(4, "No defined value type" + var9_11);
            }
        }
        if ((var9_12 = var2_2.getNamedItem("table:formula")) != null) {
            if (var5_5 == null) {
                this.fmt.setCategory("string");
                var10_13 = var2_2.getNamedItem("table:string-value");
                this.fmt.setValue(var10_13.getNodeValue());
            }
            var10_13 = var9_12.getNodeValue();
            this.addCell((String)var10_13);
        } else {
            Debug.log(1, "TextNode, DateNode, TimeNode or BooleanNode\n");
            if (var1_1.hasChildNodes()) {
                var10_13 = var1_1.getChildNodes();
                var11_15 = var10_13.getLength();
                var12_16 = 0;
                while (var12_16 < var11_15) {
                    var13_17 = var10_13.item(var12_16);
                    if (var13_17.getNodeType() == 1 && (var14_18 = var13_17.getNodeName()).equals("text:p")) {
                        this.traverseParagraph(var13_17);
                    }
                    ++var12_16;
                }
            } else if (!this.fmt.isDefault()) {
                this.addCell("");
            }
        }
        this.format = 0L;
        this.colID += this.colsRepeated;
        this.colsRepeated = 1;
    }

    protected void traverseNamedExpressions(Node node) throws IOException {
        Debug.log(4, "<NAMED:EXPRESSIONS>");
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    NameDefinition nameDefinition = new NameDefinition(node2);
                    this.encoder.setNameDefinition(nameDefinition);
                }
                ++n2;
            }
        }
        Debug.log(4, "</NAMED:EXPRESSIONS>");
    }

    /*
     * Unable to fully structure code
     */
    protected void traverseParagraph(Node var1_1) throws IOException {
        block9: {
            var2_2 = var1_1.getAttributes();
            var3_3 = 0;
            var4_4 = null;
            if (var2_2 != null && var2_2.item(0) != null) ** GOTO lbl8
            Debug.log(1, "No Paragraph Attributes\n");
            break block9;
lbl-1000:
            // 1 sources

            {
                Debug.log(1, "Paragraph Attribute " + var3_3 + ": " + var4_4.getNodeName() + " : " + var4_4.getNodeValue() + "\n");
lbl8:
                // 2 sources

                ** while ((var4_4 = var2_2.item((int)var3_3++)) != null)
            }
        }
        if (var1_1.hasChildNodes()) {
            var5_5 = var1_1.getChildNodes();
            var6_6 = var5_5.getLength();
            var7_7 = new StringBuffer();
            var8_8 = 0;
            while (var8_8 < var6_6) {
                var9_9 = var5_5.item(var8_8);
                var10_10 = var9_9.getNodeType();
                switch (var10_10) {
                    case 3: {
                        var7_7.append(var9_9.getNodeValue());
                        break;
                    }
                    case 5: {
                        var11_11 = var9_9.getChildNodes();
                        var12_12 = var11_11.getLength();
                        var13_13 = 0;
                        while (var13_13 < var12_12) {
                            var14_14 = var11_11.item(var13_13);
                            if (var14_14.getNodeType() == 3) {
                                var7_7.append(var14_14.getNodeValue());
                            }
                            ++var13_13;
                        }
                        break;
                    }
                }
                ++var8_8;
            }
            var9_9 = var7_7.toString();
            this.addCell((String)var9_9);
        }
    }

    public void traverseSettings(Node node) throws IOException {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    String string = node2.getNodeName();
                    if (string.equals("config:config-item-set")) {
                        this.traverseSettings(node2);
                    } else if (string.equals("config:config-item-map-indexed")) {
                        this.traverseSettings(node2);
                    } else if (string.equals("config:config-item-map-entry")) {
                        BookSettings bookSettings = new BookSettings(node2);
                        this.encoder.addSettings(bookSettings);
                    } else {
                        Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(node2) + " />");
                    }
                }
                ++n2;
            }
        }
    }

    protected void traverseTable(Node node) throws IOException {
        Debug.log(4, "<TABLE>");
        this.ColumnRowList = new Vector();
        NamedNodeMap namedNodeMap = node.getAttributes();
        String string = namedNodeMap.getNamedItem("table:name").getNodeValue();
        this.rowID = 1;
        this.encoder.createWorksheet(string);
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = nodeList.getLength();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = nodeList.item(n2);
                if (node2.getNodeType() == 1) {
                    String string2 = node2.getNodeName();
                    if (string2.equals("table:table-row")) {
                        this.traverseTableRow(node2);
                    } else if (string2.equals("table:table-column")) {
                        this.traverseTableColumn(node2);
                    } else if (!string2.equals("table:scenario")) {
                        Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo(node2) + " />");
                    }
                }
                ++n2;
            }
        }
        this.encoder.setColumnRows(this.ColumnRowList);
        Debug.log(4, "</TABLE>");
    }

    protected void traverseTableColumn(Node node) throws IOException {
        Cloneable cloneable;
        Object object;
        Debug.log(4, "traverseColumn() : ");
        NamedNodeMap namedNodeMap = node.getAttributes();
        Node node2 = namedNodeMap.getNamedItem("table:style-name");
        Node node3 = namedNodeMap.getNamedItem("table:number-columns-repeated");
        Node node4 = namedNodeMap.getNamedItem("table:default-cell-style-name");
        int n = 1;
        int n2 = 0;
        ColumnRowInfo columnRowInfo = new ColumnRowInfo(1);
        if (node3 != null) {
            Debug.log(4, "traverseColumn() repeated-cols : " + node3.getNodeValue());
            n = Integer.parseInt(node3.getNodeValue());
            columnRowInfo.setRepeated(n);
        }
        String string = new String("");
        if (node4 != null) {
            string = node4.getNodeValue();
            Debug.log(4, "traverseColumn() default-cell-style : " + string);
        }
        if (string.equalsIgnoreCase("Default") || string.length() == 0) {
            Debug.log(4, "No default cell Style Attribute was found");
        } else {
            object = (CellStyle)this.styleCat.lookup(string, "table-cell", null, class$org$openoffice$xmerge$converter$xml$sxc$CellStyle != null ? class$org$openoffice$xmerge$converter$xml$sxc$CellStyle : (class$org$openoffice$xmerge$converter$xml$sxc$CellStyle = SxcDocumentSerializer.class$("org.openoffice.xmerge.converter.xml.sxc.CellStyle")));
            cloneable = new Format(((CellStyle)object).getFormat());
            columnRowInfo.setFormat((Format)cloneable);
        }
        object = new String("");
        if (node2 != null) {
            object = node2.getNodeValue();
        }
        if (((String)object).equalsIgnoreCase("Default") || ((String)object).length() == 0) {
            Debug.log(4, "No defined Style Attribute was found");
        } else {
            cloneable = (ColumnStyle)this.styleCat.lookup((String)object, "table-column", null, class$org$openoffice$xmerge$converter$xml$sxc$ColumnStyle != null ? class$org$openoffice$xmerge$converter$xml$sxc$ColumnStyle : (class$org$openoffice$xmerge$converter$xml$sxc$ColumnStyle = SxcDocumentSerializer.class$("org.openoffice.xmerge.converter.xml.sxc.ColumnStyle")));
            n2 = ((ColumnStyle)cloneable).getColWidth();
            columnRowInfo.setSize(n2);
            Debug.log(4, "traverseColumn() Column Width : " + n2);
        }
        this.ColumnRowList.add(columnRowInfo);
    }

    protected void traverseTableRow(Node node) throws IOException {
        Object object;
        Object object2;
        int n;
        Object object3;
        NamedNodeMap namedNodeMap = node.getAttributes();
        if (namedNodeMap != null) {
            Object object4;
            object3 = namedNodeMap.getNamedItem("table:style-name");
            Node node2 = namedNodeMap.getNamedItem("table:number-rows-repeated");
            n = 1;
            if (node2 != null) {
                object2 = node2.getNodeValue();
                Debug.log(4, "traverseTableRow() repeated-rows : " + (String)object2);
                n = Integer.parseInt((String)object2);
            }
            object2 = new String("");
            if (object3 != null) {
                object2 = object3.getNodeValue();
            }
            if (((String)object2).equalsIgnoreCase("Default") || ((String)object2).length() == 0) {
                Debug.log(4, "No defined Row Style Attribute was found");
            } else {
                object = (RowStyle)this.styleCat.lookup((String)object2, "table-row", null, class$org$openoffice$xmerge$converter$xml$sxc$RowStyle != null ? class$org$openoffice$xmerge$converter$xml$sxc$RowStyle : (class$org$openoffice$xmerge$converter$xml$sxc$RowStyle = SxcDocumentSerializer.class$("org.openoffice.xmerge.converter.xml.sxc.RowStyle")));
                int n2 = ((RowStyle)object).getRowHeight();
                Debug.log(4, "traverseTableRow() Row Height : " + n2);
                object4 = new ColumnRowInfo(n2, n, 2, n2 != 0);
                this.ColumnRowList.add(object4);
            }
            object = namedNodeMap.getNamedItem("table:number-rows-repeated");
            if (object != null) {
                String string = object.getNodeValue();
                object4 = new Integer(string);
                this.rowsRepeated = (Integer)object4;
            } else {
                this.rowsRepeated = 1;
            }
        }
        Debug.log(4, "<TR>");
        if (node.hasChildNodes()) {
            object3 = node.getChildNodes();
            int n3 = object3.getLength();
            n = 0;
            while (n < n3) {
                object2 = object3.item(n);
                if (object2.getNodeType() == 1) {
                    object = object2.getNodeName();
                    if (((String)object).equals("table:table-cell")) {
                        this.traverseCell((Node)object2);
                    } else {
                        Debug.log(4, "<OTHERS " + XmlUtil.getNodeInfo((Node)object2) + " />");
                    }
                }
                ++n;
            }
        }
        this.rowID += this.rowsRepeated;
        this.rowsRepeated = 1;
        this.colID = 1;
        this.colsRepeated = 1;
        Debug.log(4, "</TR>");
    }
}

