<?xml version="1.0" encoding="UTF-8"?>
<!--

   $RCSfile: master_refs_workaround.xsl,v $

   $Revision: 1.5 $

   last change: $Author: rt $ $Date: 2005/01/28 15:24:06 $

   The Contents of this file are made available subject to the terms of
   either of the following licenses

          - GNU Lesser General Public License Version 2.1
          - Sun Industry Standards Source License Version 1.1

   Sun Microsystems Inc., October, 2000

   GNU Lesser General Public License Version 2.1
   =============================================
   Copyright 2000 by Sun Microsystems, Inc.
   901 San Antonio Road, Palo Alto, CA 94303, USA

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public
   License version 2.1, as published by the Free Software Foundation.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with this library; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
   MA  02111-1307  USA


   Sun Industry Standards Source License Version 1.1
   =================================================
   The contents of this file are subject to the Sun Industry Standards
   Source License Version 1.1 (the "License"); You may not use this file
   except in compliance with the License. You may obtain a copy of the
   License at http://www.openoffice.org/license.html.

   Software provided under this License is provided on an "AS IS" basis,
   WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
   WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
   See the License for the specific provisions governing your rights and
   obligations concerning the Software.

   The Initial Developer of the Original Code is: Sun Microsystems, Inc.

   Copyright © 2002 by Sun Microsystems, Inc.

   All Rights Reserved.

   Contributor(s): _______________________________________

-->
<!--
    For further documentation and updates visit http://xml.openoffice.org/sx2ml
-->
<xsl:stylesheet
        xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
        xmlns:office="http://openoffice.org/2000/office"
        xmlns:style="http://openoffice.org/2000/style"
        xmlns:text="http://openoffice.org/2000/text"
        xmlns:table="http://openoffice.org/2000/table"
        xmlns:draw="http://openoffice.org/2000/drawing"
        xmlns:fo="http://www.w3.org/1999/XSL/Format"
        xmlns:xlink="http://www.w3.org/1999/xlink"
        xmlns:number="http://openoffice.org/2000/datastyle"
        xmlns:svg="http://www.w3.org/2000/svg"
        xmlns:chart="http://openoffice.org/2000/chart"
        xmlns:dr3d="http://openoffice.org/2000/dr3d"
        xmlns:math="http://www.w3.org/1998/Math/MathML"
        xmlns:form="http://openoffice.org/2000/form"
        xmlns:script="http://openoffice.org/2000/script"
        xmlns:dc="http://purl.org/dc/elements/1.1/"
        xmlns:meta="http://openoffice.org/2000/meta"
        xmlns:config="http://openoffice.org/2001/config"
        xmlns:help="http://openoffice.org/2000/help"
        xmlns:java="http://xml.apache.org/xslt/java"
        xmlns:sxg="http://www.jclark.com/xt/java/org.openoffice.xslt.OOoMasterDocument"
        xmlns:xt="http://www.jclark.com/xt"
        xmlns:common="http://exslt.org/common"
        xmlns:xalan="http://xml.apache.org/xalan"
        xmlns="http://www.w3.org/1999/xhtml"
        version="1.0"
        exclude-result-prefixes="office style text table draw fo xlink number svg chart dr3d math form script dc meta config help java sxg xt common xalan">


    <!--
    SUMMARY:
     following parameter triggers a (quite time consuming) workaround for enabling of chapter links in the table-of-content.

    IN DETAIL:
     Currently some links used in the Office XML (for example, in the content table as '#7.Some%20Example%20Headline%7Outline')
     are not a valid URLs (cmp. bug id# 102311).
     No file destination is specified nor exist any anchor element for these links in the Office XML.
     A workaround for this transformation therefore had to be made. This time-consuming mechanism is disabled by default and
     can be activated by a parameter (i.e. 'childDocumentExist'). A creation of an anchor is made for each header element.
     All header titles gonna be encoded to be usable in a relative URL.  -->


    <!--
        CREATION OF A HELPER VARIABLE AS WORKAROUND FOR THE CONTENT TABLE ULR BUG


        As no valid URL from the content table to the child documents exist in the content table,
        a work-around is done:

        First two helper variables are being created.

        One containing the list of all references of the master document:
        containg all their title,
        for example:

            <chapter-ref title="aTitle 1" />
            <chapter-ref title="aTitle 2" />
            <chapter-ref title="aTitle 2/>
            <chapter-ref title="aTitle 3/>

        The other containing all heading from the child documents linked from the master document.
        The variable 'childrenHeadings' contains their title and the number of preceding similar titles,
        for example:


            <child file-url="aURL">
                <heading title="aTitle1" level="1">
                <heading title="aTitle2" level="2">
                <heading title="aTitle3" level="1">
            </child>

        For each chapter reference from the content table the

         by encoding the chapter names of the child document with the java URLEncoder and
        use this as a part of a link. Furthermore for all heading elements a encoded anchor will be created from the heading.
        Last the workaround parses all children documents for this anhor, as there is no distinction of files from the content table entries.

        The new added node set to the globalData variable concering the content table is written as


        <content-table-headings>
            <heading file-url="aFileURLToTheGeneratedHeading1" level="1">
            <heading file-url="aFileURLToTheGeneratedHeading2" level="2">
            <heading file-url="aFileURLToTheGeneratedHeading1" level="1">
            <heading file-url="aFileURLToTheGeneratedHeading2" level="2">
        </content-table-headings>


        Preconditions:
        The correct sequence of child documents according to the Content Table is necessary, granted by the office.
    -->
    <xsl:template name="create-helper-variables-for-Content-Table">
        <xsl:param name="globalData" />

        <xsl:if test="$debugEnabled">
            <xsl:message>Creation of master document helper variable for the content table....</xsl:message>
        </xsl:if>
        <!-- Here a helper variable for the content table is created, containing
             all chapter-references which point to a child document.
             In the variable, a 'chapter-ref' element will be created,
             containg the title, stripped from surrounding spaces,
             and the reference, for example:

                <chapter-ref
                    title="sample-Title 1"
                    content-table-id="../dummy.sxw" />
                <chapter-ref title="a-Title 2" />
                <chapter-ref title="cTitle 1" />
                <chapter-ref title="aTitle 3" />
            -->
        <xsl:variable name="chapterRefs-RTF">
            <!-- XPATH starting with '/*/' as the flat and the zipped XML file format have different root elements -->
            <xsl:for-each select="/*/office:body/text:table-of-content/text:index-body/text:p/text:a">
                <xsl:element name="chapter-ref" namespace="">
                    <xsl:variable name="title"><xsl:apply-templates mode="concatenate" /></xsl:variable>
                    <xsl:attribute name="title">
                        <xsl:value-of select="normalize-space(string($title))"/>
                    </xsl:attribute>
                    <xsl:attribute name="content-table-id">
                        <xsl:value-of select="@xlink:href" />
                    </xsl:attribute>
                </xsl:element>
            </xsl:for-each>
        </xsl:variable>

        <xsl:if test="$debugEnabled">
            <xsl:message>Finished the Creation of master document helper variable for the content table!</xsl:message>
            <xsl:message>Creation of master document helper variable for the child documents...</xsl:message>
        </xsl:if>
        <!-- Here a helper variable of created from the children documents.
             Containg all heading elements from the child documents. Some or all of them are
             chapters referenced by the Global Document.
             The variable contains their title, the level of the heading and the file URL of the child,
             for example:

                <heading title="aTitle1" level="1" file-url="aURL1">
                <heading title="aTitle2" level="2" file-url="aURL1">
                <heading title="aTitle3" level="1" file-url="aURL1">
                <heading title="aTitle4" level="1" file-url="aURL2">
                <heading title="aTitle5" level="2" file-url="aURL2">
                <heading title="aTitle2" level="3" file-url="aURL2">
                <heading title="aTitle6" level="3" file-url="aURL2">
                <heading-count>7</heading-count>
            -->
        <!-- all headers from children documents will be added -->
        <xsl:variable name="childrenHeadings-RTF">
            <xsl:apply-templates select="/*/office:body/text:section" mode="creation-of-variable" />
        </xsl:variable>
        <xsl:if test="$debugEnabled">
            <xsl:message>Finished the Creation of master document helper variable for the child documents!</xsl:message>
        </xsl:if>
        <xsl:choose>
            <xsl:when test="function-available('xalan:nodeset')">
                <xsl:call-template name="create-global-variable-for-Content-Table">
                    <xsl:with-param name="chapterRefs" select="xalan:nodeset($chapterRefs-RTF)" />
                    <xsl:with-param name="childrenHeadings" select="xalan:nodeset($childrenHeadings-RTF)" />
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('common:node-set')">
                <xsl:call-template name="create-global-variable-for-Content-Table">
                    <xsl:with-param name="chapterRefs" select="common:node-set($chapterRefs-RTF)" />
                    <xsl:with-param name="childrenHeadings" select="common:node-set($childrenHeadings-RTF)" />
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('xt:node-set')">
                <xsl:call-template name="create-global-variable-for-Content-Table">
                    <xsl:with-param name="chapterRefs" select="xt:node-set($chapterRefs-RTF)" />
                    <xsl:with-param name="childrenHeadings" select="xt:node-set($childrenHeadings-RTF)" />
                    <xsl:with-param name="globalData" select="$globalData" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Functions for node-set conversion not found!</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template name="create-global-variable-for-Content-Table">
        <xsl:param name="chapterRefs" />
        <xsl:param name="childrenHeadings" />
        <xsl:param name="globalData" />

        <xsl:if test="$debugEnabled">
            <!-- helper variable collecting all headings from the master document file children-->
            <xsl:for-each select="$childrenHeadings/heading">
                <xsl:message>#              <xsl:value-of select="position()" />
                </xsl:message>
                <xsl:message>level:         <xsl:value-of select="@level" />
                </xsl:message>
                <xsl:message>title:         <xsl:value-of select="@title" />
                </xsl:message>
                <xsl:message>encoded-title: <xsl:value-of select="@encoded-title" />
                </xsl:message>
                <xsl:message>file-url:      <xsl:value-of select="@file-url" />
                </xsl:message>
                <xsl:message>header-no:     <xsl:value-of select="@header-no" />
                </xsl:message>
                <xsl:message>**</xsl:message>
            </xsl:for-each>
            <!-- helper variable collecting all heading references from the content table of the the master document -->
            <xsl:message>+-+-+ childrenHeadings/heading-count: <xsl:value-of select="$childrenHeadings/heading-count" />
            </xsl:message>
            <xsl:for-each select="$chapterRefs/chapter-ref">
                <xsl:message># <xsl:value-of select="position()" />
                </xsl:message>
                <xsl:message>title: <xsl:value-of select="@title" />
                </xsl:message>
                <xsl:message>**</xsl:message>
            </xsl:for-each>
        </xsl:if>

        <xsl:choose>
            <xsl:when test="function-available('sxg:set-heading-no')">
                <xsl:value-of select="sxg:set-heading-no(1)" />
                <xsl:value-of select="sxg:set-current-child-no(1)" />
                <xsl:value-of select="sxg:set-current-child-url(string($childrenHeadings/heading/@file-url))" />
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.setHeadingNo')">
                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.setHeadingNo(1)" />
                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.setCurrentChildNo(1)" />
                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.setCurrentChildUrl(string($childrenHeadings/heading/@file-ur))" />
            </xsl:when>
        </xsl:choose>

        <xsl:if test="$debugEnabled">
            <xsl:message>Creating master document variable for chapter relations....</xsl:message>
        </xsl:if>
        <xsl:variable name="contentTableHeadingsGlobalData-RTF">
            <xsl:element name="content-table-headings" namespace="">

                <!-- had to use a for loop, as a recursion ends with an stackoverflow exception after about 600 recursive calls -->
                <xsl:choose>
                    <xsl:when test="function-available('sxg:get-heading-no')">
                        <xsl:for-each select="$chapterRefs/chapter-ref">
                            <xsl:call-template name="searchHeadingInChildDocument">
                                <xsl:with-param name="chapterRefs" select="$chapterRefs" />
                                <xsl:with-param name="childrenHeadings" select="$childrenHeadings" />
                                <xsl:with-param name="currentChapterRefNo" select="position()" />
                                <xsl:with-param name="currentHeadingNo" select="sxg:get-heading-no()" />
                                <xsl:with-param name="currentChildURL" select="sxg:get-current-child-url()" />
                                <xsl:with-param name="currentChildNo" select="sxg:get-current-child-no()" />
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getHeadingNo')">
                        <xsl:for-each select="$chapterRefs/chapter-ref">
                            <xsl:call-template name="searchHeadingInChildDocument">
                                <xsl:with-param name="chapterRefs" select="$chapterRefs" />
                                <xsl:with-param name="childrenHeadings" select="$childrenHeadings" />
                                <xsl:with-param name="currentChapterRefNo" select="position()" />
                                <xsl:with-param name="currentHeadingNo" select="java:org.openoffice.xslt.OOoMasterDocument.getHeadingNo()" />
                                <xsl:with-param name="currentChildURL" select="java:org.openoffice.xslt.OOoMasterDocument.getCurrentChildUrl()" />
                                <xsl:with-param name="currentChildNo" select="java:org.openoffice.xslt.OOoMasterDocument.getCurrentChildNo()" />
                            </xsl:call-template>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getHeadingNo()</xsl:message>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:element>

            <!-- adding the already exisiting global data environment -->
            <xsl:copy-of select="$globalData" />
        </xsl:variable>
        <xsl:if test="$debugEnabled">
            <xsl:message>Finished master document variable for chapter relations!</xsl:message>
        </xsl:if>

        <xsl:choose>
            <xsl:when test="function-available('xalan:nodeset')">
                <xsl:call-template name="start-self-and-children-transformation">
                    <xsl:with-param name="globalData" select="xalan:nodeset($contentTableHeadingsGlobalData-RTF)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('xt:node-set')">
                <xsl:call-template name="start-self-and-children-transformation">
                    <xsl:with-param name="globalData" select="xt:node-set($contentTableHeadingsGlobalData-RTF)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('common:node-set')">
                <xsl:call-template name="start-self-and-children-transformation">
                    <xsl:with-param name="globalData" select="common:node-set($contentTableHeadingsGlobalData-RTF)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getOutputURLForHTML</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template name="searchHeadingInChildDocument">
        <xsl:param name="chapterRefs" />
        <xsl:param name="childrenHeadings" />
        <xsl:param name="currentChapterRefNo" />
        <xsl:param name="currentHeadingNo" />
        <xsl:param name="currentChildURL" />
        <xsl:param name="currentChildNo" />
        <xsl:variable name="currentChapterRef" select="$chapterRefs/chapter-ref[$currentChapterRefNo]" />
        <xsl:variable name="currentChapterID" select="$currentChapterRef/@content-table-id" />
        <xsl:variable name="currentChapterTitle" select="$currentChapterRef/@title" />
        <xsl:variable name="currentChildHeading" select="$childrenHeadings/heading[$currentHeadingNo]" />
        <xsl:variable name="headingTitle" select="$currentChildHeading/@title" />
        <xsl:variable name="headingLevel" select="$currentChildHeading/@level" />
        <xsl:variable name="headingNo" select="$currentChildHeading/@header-no" />
        <xsl:variable name="newChildURL" select="string($currentChildHeading/@file-url)" />

        <xsl:if test="$debugEnabled">
            <xsl:message>*** new heading </xsl:message>
            <xsl:message>currentChapterID:    <xsl:value-of select="$currentChapterID" />
            </xsl:message>
            <xsl:message>currentChapterTitle: <xsl:value-of select="$currentChapterTitle" />
            </xsl:message>
            <xsl:message>currentChapterID:    <xsl:value-of select="$currentChapterID" />
            </xsl:message>
            <xsl:message>currentHeadingNo:    <xsl:value-of select="$currentHeadingNo" />
            </xsl:message>
            <xsl:message>headingTitle:        <xsl:value-of select="$headingTitle" />
            </xsl:message>
            <xsl:message>headingLevel:        <xsl:value-of select="$headingLevel" />
            </xsl:message>
            <xsl:message>headingNo:           <xsl:value-of select="$headingNo" />
            </xsl:message>
            <xsl:message>newChildURL:         <xsl:value-of select="$newChildURL" />
            </xsl:message>
        </xsl:if>

        <xsl:variable name="isNewFile" select="string($newChildURL) != string($currentChildURL)" />
        <xsl:if test="$isNewFile">
            <!-- reset of the already collected child headers -->
            <xsl:call-template name="calc-chapter-numbers">
                <xsl:with-param name="level" select="0" />
            </xsl:call-template>
        </xsl:if>
        <xsl:variable name="absoluteChapterLevel">
            <xsl:call-template name="calc-chapter-numbers">
                <xsl:with-param name="level" select="number($headingLevel)" />
            </xsl:call-template>
        </xsl:variable>

        <xsl:variable name="isChapterHeading" select="$headingTitle = $currentChapterTitle" />

        <xsl:variable name="outFileURL">
            <xsl:choose>
                <xsl:when test="function-available('sxg:get-output-u-r-l-for-h-t-m-l')">
                    <xsl:value-of select="sxg:get-output-u-r-l-for-h-t-m-l($newChildURL)" />
                </xsl:when>
                <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getOutputURLForHTML')">
                    <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.getOutputURLForHTML($newChildURL)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getOutputURLForHTML</xsl:message>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:variable>

        <xsl:element name="heading" namespace="">
            <!-- necessary to as ID from the content table to get the correct heading element (the buggy URL used as ID)-->
            <xsl:attribute name="content-table-id">
                <xsl:choose>
                    <xsl:when test="$isChapterHeading">
                        <xsl:value-of select="$currentChapterID" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:text>only a heading, but not a chapter</xsl:text>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <!-- no of the used child, necessary for quick finding of chapters of next file  -->
            <xsl:attribute name="child-document-no">
                <xsl:choose>
                    <xsl:when test="$isNewFile">
                        <xsl:value-of select="$currentChildNo + 1" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="$currentChildNo" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:attribute>
            <!-- the URL of the child document source, containing the heading -->
            <xsl:attribute name="file-url">
                <xsl:value-of select="$newChildURL" />
            </xsl:attribute>
            <xsl:attribute name="out-file-url">
                <xsl:value-of select="$outFileURL" />
            </xsl:attribute>
            <xsl:attribute name="level">
                <xsl:value-of select="$headingLevel" />
            </xsl:attribute>
            <xsl:attribute name="title">
                <xsl:value-of select="$headingTitle" />
            </xsl:attribute>
            <xsl:attribute name="encoded-title">
                <xsl:value-of select="$currentChildHeading/@encoded-title" />
            </xsl:attribute>
            <xsl:attribute name="absolute-chapter-level">
                <xsl:value-of select="$absoluteChapterLevel" />
            </xsl:attribute>
        </xsl:element>


        <xsl:choose>
            <xsl:when test="$childrenHeadings/heading-count != $currentHeadingNo">
                <!-- procede as long the list of children isn'nt worked through -->
                <xsl:choose>
                    <xsl:when test="$isChapterHeading">
                        <!-- global variables have to be set, so the for-each loop can access them -->
                        <xsl:choose>
                            <xsl:when test="function-available('sxg:set-heading-no')">
                                <xsl:value-of select="sxg:set-heading-no($currentHeadingNo + 1)" />
                                <xsl:if test="$isNewFile">
                                    <xsl:value-of select="sxg:set-current-child-no($currentChildNo + 1)" />
                                    <xsl:value-of select="sxg:set-current-child-url(string($newChildURL))" />
                                </xsl:if>
                            </xsl:when>
                            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.setHeadingNo')">
                                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.setHeadingNo($currentHeadingNo + 1)" />
                                <xsl:if test="$isNewFile">
                                    <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.setCurrentChildNo($currentChildNo + 1)" />
                                    <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.setCurrentChildUrl($newChildURL)" />
                                </xsl:if>
                            </xsl:when>
                            <xsl:otherwise>
                                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.setHeadingNo</xsl:message>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:when>
                    <xsl:otherwise>
                        <!-- not a chapter heading, call itself until a chapter ref is found or the end of headings is reached -->
                        <xsl:call-template name="searchHeadingInChildDocument">
                            <xsl:with-param name="chapterRefs" select="$chapterRefs" />
                            <xsl:with-param name="childrenHeadings" select="$childrenHeadings" />
                            <xsl:with-param name="currentChapterRefNo" select="$currentChapterRefNo" />
                            <xsl:with-param name="currentHeadingNo" select="$currentHeadingNo + 1" />
                            <xsl:with-param name="currentChildURL" select="$currentChildURL" />
                            <xsl:with-param name="currentChildNo" select="$currentChildNo" />
                        </xsl:call-template>
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$debugEnabled">
                    <xsl:message>All child documents have been walked through without finding the chapter name!</xsl:message>
                    <xsl:message>       childrenHeadings/heading-count:    <xsl:value-of select="$childrenHeadings/heading-count" />
                    </xsl:message>
                    <xsl:message>       currentHeadingNo:                  <xsl:value-of select="$currentHeadingNo" />
                    </xsl:message>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <!-- To make the headings unique, the absolute heading is added to them
         E.g. The level 1.2.3.4. would result into a 1_2_3_4 string -->
    <xsl:template name="calc-chapter-numbers">
        <xsl:param name="level" />

        <xsl:choose>
            <xsl:when test="function-available('sxg:calc-chapter-numbers')">
                <xsl:value-of select="sxg:calc-chapter-numbers($level)" />
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.calcChapterNumbers')">
                <xsl:value-of select="java:org.openoffice.xslt.OOoMasterDocument.calcChapterNumbers($level)" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.calcChapterNumbers</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <!-- ******************************************************************************* -->
    <!-- ***  Creation of helper variable of the headings of all children documents  *** -->
    <!-- ******************************************************************************* -->


    <xsl:template match="/*/office:body/text:section" mode="creation-of-variable">

        <xsl:call-template name="parseHeadingsFromChildren" />

        <!-- after the last child document the master document will be parsed -->
        <xsl:if test="position() = last()">
            <!-- search the master document after all child documents have been searched


            Office SDK PATCH NO INDEX ELEMENT WANTED !! - null pointer exception
            <xsl:call-template name="getPreviousHeaderNo">
                <xsl:with-param name="amountOfCurrentHeading"   select="count(following-sibling::text:h)" />
                <xsl:with-param name="nodeToSearchForHeading"   select="following-sibling::text:h" />
            </xsl:call-template>
                                                                    -->

           <!-- get the overall No of Headers -->
            <xsl:call-template name="getAllHeaderNo" />
        </xsl:if>
    </xsl:template>


    <!-- redirection to have a speakable template name -->
    <xsl:template name="parseHeadingsFromChildren">
        <xsl:variable name="fileRef" select="string(text:section-source/@xlink:href)" />
        <xsl:choose>
            <xsl:when test="function-available('sxg:get-content-u-r-l')">
                <xsl:call-template name="getContentRootNode">
                    <xsl:with-param name="fileURL" select="sxg:get-content-u-r-l($fileRef)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getContentURL')">
                <xsl:call-template name="getContentRootNode">
                    <xsl:with-param name="fileURL" select="java:org.openoffice.xslt.OOoMasterDocument.getContentURL($fileRef)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getContentURL!</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>


    <xsl:template name="getContentRootNode">
        <xsl:param name="fileURL" />

        <xsl:variable name="childRootNode" select="document($fileURL)" />
        <xsl:call-template name="getPreviousHeaderNo">
            <xsl:with-param name="fileURL" select="$fileURL" />
            <!-- the absolute source path will be added as prefix -->
            <xsl:with-param name="amountOfCurrentHeading" select="count($childRootNode/*/office:body/descendant::text:h)" />
            <xsl:with-param name="nodeToSearchForHeading" select="$childRootNode/*/office:body/descendant::text:h" />
        </xsl:call-template>

    </xsl:template>


    <xsl:template name="getPreviousHeaderNo">
        <xsl:param name="fileURL" />
        <xsl:param name="nodeToSearchForHeading" />
        <xsl:param name="amountOfCurrentHeading" />

        <xsl:choose>
            <xsl:when test="function-available('sxg:get-previous-child-documents-heading-count')">
                <xsl:call-template name="addHeadingInfo">
                    <xsl:with-param name="nodeToSearchForHeading" select="$nodeToSearchForHeading" />
                    <xsl:with-param name="fileURL" select="$fileURL" />
                    <xsl:with-param name="previousHeader" select="sxg:get-previous-child-documents-heading-count($amountOfCurrentHeading)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getPreviousChildDocumentsHeadingCount')">
                <xsl:call-template name="addHeadingInfo">
                    <xsl:with-param name="nodeToSearchForHeading" select="$nodeToSearchForHeading" />
                    <xsl:with-param name="fileURL" select="$fileURL" />
                    <xsl:with-param name="previousHeader" select="java:org.openoffice.xslt.OOoMasterDocument.getPreviousChildDocumentsHeadingCount($amountOfCurrentHeading)" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: java:org.openoffice.xslt.OOoMasterDocument.getPreviousChildDocumentsHeadingCount</xsl:message>
            </xsl:otherwise>
        </xsl:choose>

    </xsl:template>


    <xsl:template name="addHeadingInfo">
        <xsl:param name="fileURL" />
        <xsl:param name="previousHeader" />
        <xsl:param name="nodeToSearchForHeading" />

        <xsl:variable name="previousHeader2" select="number($previousHeader)" />
        <xsl:for-each select="$nodeToSearchForHeading">
            <xsl:variable name="title"><xsl:apply-templates mode="concatenate" /></xsl:variable>
            <xsl:variable name="encodedTitle">
                <xsl:call-template name="encode-string">
                    <!-- the space has to be normalized,
                        otherwise an illegal argument exception will be thrown for XT-->
                    <xsl:with-param name="textToBeEncoded" select="normalize-space(string($title))" />
                </xsl:call-template>
            </xsl:variable>
            <!--
            <xsl:if test="$debugEnabled">
                <xsl:message>
                    title:<xsl:value-of select="$title" />
                    encoded-title:<xsl:value-of select="$encodedTitle" />
                    level:<xsl:value-of select="@text:level" />
                    file-uRL:<xsl:value-of select="$fileURL" />
                    header-no:<xsl:value-of select="position() + $previousHeader2" />
                </xsl:message>
            </xsl:if>
            -->
            <xsl:element name="heading" namespace="">
                <!-- odd but 'descendant:text()' didn't work, but '.', to get all text nodes of the header -->
                <xsl:attribute name="title">
                    <xsl:value-of select="normalize-space(string($title))" />
                </xsl:attribute>
                <xsl:attribute name="encoded-title">
                    <xsl:value-of select="$encodedTitle" />
                </xsl:attribute>
                <xsl:attribute name="level">
                    <xsl:value-of select="@text:level" />
                </xsl:attribute>
                <xsl:attribute name="file-url">
                    <xsl:value-of select="$fileURL" />
                </xsl:attribute>
                <xsl:attribute name="header-no">
                    <xsl:value-of select="position() + $previousHeader2" />
                </xsl:attribute>
            </xsl:element>
        </xsl:for-each>
    </xsl:template>


    <xsl:template name="getAllHeaderNo">
        <xsl:choose>
            <xsl:when test="function-available('sxg:get-all-child-documents-heading-count')">
                <xsl:call-template name="addAllHeaderNoElement">
                    <xsl:with-param name="allHeader" select="sxg:get-all-child-documents-heading-count()" />
                </xsl:call-template>
            </xsl:when>
            <xsl:when test="function-available('java:org.openoffice.xslt.OOoMasterDocument.getAllChildDocumentsHeadingCount')">
                <xsl:call-template name="addAllHeaderNoElement">
                    <xsl:with-param name="allHeader" select="java:org.openoffice.xslt.OOoMasterDocument.getAllChildDocumentsHeadingCount()" />
                </xsl:call-template>
            </xsl:when>
            <xsl:otherwise>
                <xsl:message terminate="yes">ERROR: Function not found: nodeset</xsl:message>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:template>

    <xsl:template name="addAllHeaderNoElement">
        <xsl:param name="allHeader" />

        <xsl:element name="heading-count" namespace="">
            <xsl:value-of select="$allHeader" />
        </xsl:element>
    </xsl:template>

</xsl:stylesheet>
