/*************************************************************************
 *
 *  $RCSfile: rngitem.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: er $ $Date: 2001/05/13 03:25:17 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef MACOSX
// We need an empty block in here. Otherwise, if the #ifndef _SFXRNGITEM_HXX
// line is the first line, the Mac OS X version of the gcc preprocessor will
// incorrectly optimize the inclusion process and will never include this file
// a second time
#endif

#ifndef _SFXRNGITEM_HXX

#ifndef NUMTYPE

#define NUMTYPE	USHORT
#define SfxXRangeItem SfxRangeItem
#define SfxXRangesItem SfxUShortRangesItem
#include <svtools/rngitem.hxx>
#undef NUMTYPE
#undef SfxXRangeItem
#undef SfxXRangesItem

#ifndef _SFXITEMS_HXX
#define NUMTYPE	ULONG
#define SfxXRangeItem SfxULongRangeItem
#define SfxXRangesItem SfxULongRangesItem
#include <svtools/rngitem.hxx>
#undef NUMTYPE
#undef SfxXRangeItem
#undef SfxXRangesItem
#endif

#define _SFXRNGITEM_HXX

#if SUPD<355
DBG_NAMEEX(SfxRangeItem);
#endif

#else

#include <tools/solar.h>
#include <tools/rtti.hxx>
#include <svtools/poolitem.hxx>

class SfxArguments;
class SvStream;

// -----------------------------------------------------------------------

class SfxXRangeItem : public SfxPoolItem
{
private:
	NUMTYPE 					nFrom;
	NUMTYPE 					nTo;
public:
								TYPEINFO();
								SfxXRangeItem();
								SfxXRangeItem( USHORT nWID, NUMTYPE nFrom, NUMTYPE nTo );
								SfxXRangeItem( USHORT nWID, SvStream &rStream );
								SfxXRangeItem( const SfxXRangeItem& rItem );
#if SUPD<355
	virtual 					~SfxXRangeItem() {};
#endif
	virtual int 				operator==( const SfxPoolItem& ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;
	virtual SfxPoolItem*    	Clone( SfxItemPool *pPool = 0 ) const;
	inline NUMTYPE&				From() { return nFrom; }
	inline NUMTYPE				From() const { return nFrom; }
	inline NUMTYPE&				To() { return nTo; }
	inline NUMTYPE				To() const { return nTo; }
	inline BOOL					HasRange() const { return nTo>nFrom; }
	virtual SfxPoolItem*		Create( SvStream &, USHORT nVersion ) const;
	virtual SvStream&			Store( SvStream &, USHORT nItemVersion ) const;
};

// -----------------------------------------------------------------------

class SfxXRangesItem : public SfxPoolItem
{
private:
	NUMTYPE*					_pRanges;

public:
								TYPEINFO();
								SfxXRangesItem();
								SfxXRangesItem( USHORT nWID, const NUMTYPE *pRanges );
								SfxXRangesItem( USHORT nWID, SvStream &rStream );
								SfxXRangesItem( const SfxXRangesItem& rItem );
	virtual 					~SfxXRangesItem();
	virtual int 				operator==( const SfxPoolItem& ) const;
	virtual SfxItemPresentation GetPresentation( SfxItemPresentation ePres,
									SfxMapUnit eCoreMetric,
									SfxMapUnit ePresMetric,
									XubString &rText,
                                    const IntlWrapper * = 0 ) const;
	virtual SfxPoolItem*    	Clone( SfxItemPool *pPool = 0 ) const;
	inline const NUMTYPE*		GetRanges() const { return _pRanges; }
	virtual SfxPoolItem*		Create( SvStream &, USHORT nVersion ) const;
	virtual SvStream&			Store( SvStream &, USHORT nItemVersion ) const;
};

#endif
#endif
