/*************************************************************************
 *
 *  $RCSfile: contdlg.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2000/12/07 15:01:21 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONTDLG_HXX_
#define _CONTDLG_HXX_

#ifndef _BASEDLGS_HXX //autogen
#include <sfx2/basedlgs.hxx>
#endif
#ifndef _SFXCTRLITEM_HXX //autogen
#include <sfx2/ctrlitem.hxx>
#endif
#ifndef _SFX_CHILDWIN_HXX //autogen
#include <sfx2/childwin.hxx>
#endif

/*************************************************************************
|*
|* Ableitung vom SfxChildWindow als "Behaelter" fuer Float
|*
\************************************************************************/

class Graphic;

class SvxContourDlgChildWindow : public SfxChildWindow
{
 public:

	SvxContourDlgChildWindow( Window*, USHORT, SfxBindings*, SfxChildWinInfo* );

	SFX_DECL_CHILDWINDOW( SvxContourDlgChildWindow );

	static void UpdateContourDlg( const Graphic& rGraphic, BOOL bGraphicLinked,
								  const PolyPolygon* pPolyPoly = NULL,
								  void* pEditingObj = NULL );
};

#ifndef _REDUCED_ContourDlg_HXX_
#define _REDUCED_CONTDLG_HXX_

class SvxSuperContourDlg;

/*************************************************************************
|*
|*
|*
\************************************************************************/

class SvxContourDlgItem : public SfxControllerItem
{
	SvxSuperContourDlg&	rDlg;

protected:

	virtual void		StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );

public:

						SvxContourDlgItem( USHORT nId, SvxSuperContourDlg& rDlg, SfxBindings& rBindings );
};

/*************************************************************************
|*
|*
|*
\************************************************************************/

class SvxContourDlg : public SfxFloatingWindow
{
	SvxSuperContourDlg*	pSuperClass;

#if 0 // _SOLAR__PRIVATE

protected:

	void				SetSuperClass( SvxSuperContourDlg& rSuperClass ) { pSuperClass = &rSuperClass; }

#endif // __PRIVATE

public:

						SvxContourDlg( SfxBindings *pBindings, SfxChildWindow *pCW,
									   Window* pParent, const ResId& rResId );
						~SvxContourDlg();

	void				SetExecState( BOOL bEnable );

	void				SetGraphic( const Graphic& rGraphic );
	void				SetGraphicLinked( BOOL bLinked );
	const Graphic&		GetGraphic() const;
	BOOL				IsGraphicChanged() const;

	void				SetPolyPolygon( const PolyPolygon& rPolyPoly );
	PolyPolygon			GetPolyPolygon();

	void				SetEditingObject( void* pObj );
	const void*			GetEditingObject() const;

	void				Update( const Graphic& rGraphic, BOOL bGraphicLinked,
								const PolyPolygon* pPolyPoly = NULL, void* pEditingObj = NULL );

	static PolyPolygon	CreateAutoContour( 	const Graphic& rGraphic,
											const Rectangle* pRect = NULL,
											const ULONG nFlags = 0L );
	static void			ScaleContour( PolyPolygon& rContour, const Graphic& rGraphic,
									  const MapUnit eUnit, const Size& rDisplaySize );
};

/*************************************************************************
|*
|* Defines
|*
\************************************************************************/

#define SVXCONTOURDLG() ( (SvxContourDlg*) ( SfxViewFrame::Current()->GetChildWindow( 	\
						  SvxContourDlgChildWindow::GetChildWindowId() )-> 	\
						  GetWindow() ) )

#endif // _REDUCED_CONTDLG_HXX_
#endif // _CONTDLG_HXX_

