/*
 * Decompiled with CFR 0.152.
 */
package stardiv.app;

import com.sun.star.lib.sandbox.ResourceViewer;
import java.awt.Dimension;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.PrintJob;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.Vector;
import stardiv.app.AppletMessageHandler;
import stardiv.app.AppletProps;
import stardiv.app.TextFrame;
import stardiv.applet.AppletExecutionContext;
import stardiv.applet.DocumentProxy;
import stardiv.controller.SjSettings;

public class AppletViewer
extends Frame
implements Observer {
    ResourceViewer resourceViewer;
    private static String defaultSaveFile = "Applet.ser";
    public static File theUserPropertiesFile;
    public static File theAppletViewerPropsFile;
    private AppletExecutionContext appletExecutionContext = null;
    Hashtable atts = null;
    static DocumentProxy documentViewer;
    Label label;
    PrintStream statusMsgStream;
    static Vector contexts;
    static Hashtable systemParam;
    AppletProps props;
    static int c;
    static int x;
    static int y;
    static String encoding;
    static boolean didInitialize;
    private static AppletMessageHandler amh;

    public AppletViewer(int n, int n2, URL uRL, Hashtable hashtable, PrintStream printStream) {
        this.statusMsgStream = printStream;
        this.atts = hashtable;
        this.setTitle(amh.getMessage("tool.title", hashtable.get("code")));
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu(amh.getMessage("menu.applet"));
        this.addMenuItem(menu, "menuitem.restart");
        this.addMenuItem(menu, "menuitem.reload");
        this.addMenuItem(menu, "menuitem.stop");
        this.addMenuItem(menu, "menuitem.save");
        this.addMenuItem(menu, "menuitem.start");
        this.addMenuItem(menu, "menuitem.clone");
        menu.add(new MenuItem("-"));
        this.addMenuItem(menu, "menuitem.tag");
        this.addMenuItem(menu, "menuitem.info");
        this.addMenuItem(menu, "menuitem.edit").setEnabled(false);
        this.addMenuItem(menu, "menuitem.encoding");
        menu.add(new MenuItem("-"));
        this.addMenuItem(menu, "menuitem.print");
        menu.add(new MenuItem("-"));
        this.addMenuItem(menu, "menuitem.props");
        menu.add(new MenuItem("-"));
        this.addMenuItem(menu, "menuitem.close");
        this.addMenuItem(menu, "menuitem.quit");
        menuBar.add(menu);
        this.setMenuBar(menuBar);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                AppletViewer.this.appletExecutionContext.shutdown();
            }

            public void windowIconified(WindowEvent windowEvent) {
                AppletViewer.this.appletExecutionContext.sendLoad();
            }

            public void windowDeiconified(WindowEvent windowEvent) {
                AppletViewer.this.appletExecutionContext.sendStart();
            }
        });
        this.label = new Label(amh.getMessage("label.hello"));
        this.add("South", this.label);
        this.appletExecutionContext = new AppletExecutionContext(uRL, hashtable, this, 0L);
        this.appletExecutionContext.init();
        this.appletExecutionContext.addObserver(this);
        contexts.addElement(this.appletExecutionContext);
        this.pack();
        this.setVisible(true);
        this.appletExecutionContext.startUp();
    }

    public MenuItem addMenuItem(Menu menu, String string) {
        MenuItem menuItem = new MenuItem(amh.getMessage(string));
        menuItem.addActionListener(new UserActionListener());
        return menu.add(menuItem);
    }

    public void showDocument(URL uRL) {
    }

    public void showDocument(URL uRL, String string) {
    }

    public void showStatus(String string) {
        this.label.setText(string);
    }

    public void update(Observable observable, Object object) {
        this.showStatus((String)object);
    }

    public Object getJavaScriptJSObjectWindow() {
        return null;
    }

    public static void printTag(PrintStream printStream, Hashtable hashtable) {
        printStream.print("<applet");
        String string = (String)hashtable.get("codebase");
        if (string != null) {
            printStream.print(" codebase=\"" + string + "\"");
        }
        if ((string = (String)hashtable.get("code")) == null) {
            string = "applet.class";
        }
        printStream.print(" code=\"" + string + "\"");
        string = (String)hashtable.get("width");
        if (string == null) {
            string = "150";
        }
        printStream.print(" width=" + string);
        string = (String)hashtable.get("height");
        if (string == null) {
            string = "100";
        }
        printStream.print(" height=" + string);
        string = (String)hashtable.get("name");
        if (string != null) {
            printStream.print(" name=\"" + string + "\"");
        }
        printStream.println(">");
        int n = hashtable.size();
        String[] stringArray = new String[n];
        n = 0;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            int n2 = 0;
            while (n2 < n) {
                if (stringArray[n2].compareTo(string2) >= 0) break;
                ++n2;
            }
            System.arraycopy(stringArray, n2, stringArray, n2 + 1, n - n2);
            stringArray[n2] = string2;
            ++n;
        }
        int n3 = 0;
        while (n3 < n) {
            String string3 = stringArray[n3];
            if (systemParam.get(string3) == null) {
                printStream.println("<param name=" + string3 + " value=\"" + hashtable.get(string3) + "\">");
            }
            ++n3;
        }
        printStream.println("</applet>");
    }

    public void updateAtts() {
        Dimension dimension = this.getSize();
        Insets insets = this.getInsets();
        this.atts.put("width", new Integer(dimension.width - (insets.left + insets.right)).toString());
        this.atts.put("height", new Integer(dimension.height - (insets.top + insets.bottom)).toString());
    }

    void appletSave() {
        FileDialog fileDialog = new FileDialog((Frame)this, "Serialize Applet into File", 1);
        fileDialog.setDirectory(System.getProperty("user.dir"));
        fileDialog.setFile(defaultSaveFile);
        fileDialog.show();
        String string = fileDialog.getFile();
        if (string == null) {
            return;
        }
        String string2 = fileDialog.getDirectory();
        File file = new File(string2, string);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            this.showStatus(amh.getMessage("appletsave.err1", this.appletExecutionContext.getApplet().toString(), file.toString()));
            objectOutputStream.writeObject(this.appletExecutionContext.getApplet());
        }
        catch (IOException iOException) {
            System.err.println(amh.getMessage("appletsave.err2", iOException));
        }
    }

    void appletClone() {
        Point point = this.getLocation();
        this.updateAtts();
    }

    void appletTag() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.updateAtts();
        AppletViewer.printTag(new PrintStream(byteArrayOutputStream), this.atts);
        this.showStatus(amh.getMessage("applettag"));
        Point point = this.getLocation();
        new TextFrame(point.x + 50, point.y + 20, amh.getMessage("applettag.textframe"), byteArrayOutputStream.toString());
    }

    void appletInfo() {
        String string = this.appletExecutionContext.getApplet().getAppletInfo();
        if (string == null) {
            string = amh.getMessage("appletinfo.applet");
        }
        string = string + "\n\n";
        String[][] stringArray = this.appletExecutionContext.getApplet().getParameterInfo();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                string = string + stringArray[n][0] + " -- " + stringArray[n][1] + " -- " + stringArray[n][2] + "\n";
                ++n;
            }
        } else {
            string = string + amh.getMessage("appletinfo.param");
        }
        Point point = this.getLocation();
        new TextFrame(point.x + 50, point.y + 20, amh.getMessage("appletinfo.textframe"), string);
    }

    void appletCharacterEncoding() {
        this.showStatus(amh.getMessage("appletencoding", encoding));
    }

    void appletEdit() {
    }

    void appletPrint() {
        PrintJob printJob = Toolkit.getDefaultToolkit().getPrintJob(this, amh.getMessage("appletprint.printjob"), null);
        if (printJob != null) {
            Dimension dimension = printJob.getPageDimension();
            int n = printJob.getPageResolution();
            boolean bl = printJob.lastPageFirst();
            Graphics graphics = printJob.getGraphics();
            if (graphics != null) {
                this.appletExecutionContext.getApplet().printComponents(graphics);
                graphics.dispose();
            } else {
                this.statusMsgStream.println(amh.getMessage("appletprint.fail"));
            }
            this.statusMsgStream.println(amh.getMessage("appletprint.finish"));
            printJob.end();
        } else {
            this.statusMsgStream.println(amh.getMessage("appletprint.cancel"));
        }
    }

    public synchronized void networkProperties() {
        if (this.props == null) {
            this.props = new AppletProps(this.appletExecutionContext);
        }
        this.props.addNotify();
        this.props.setVisible(true);
    }

    public void appletClose() {
        this.appletExecutionContext.shutdown();
        contexts.removeElement(this);
        if (contexts.size() == 0) {
            this.appletSystemExit();
        }
    }

    private void appletSystemExit() {
        System.exit(0);
    }

    protected void appletQuit() {
        this.appletExecutionContext.shutdown();
        this.appletSystemExit();
    }

    public void processUserAction(ActionEvent actionEvent) {
        String string = ((MenuItem)actionEvent.getSource()).getLabel();
        if (amh.getMessage("menuitem.restart").equals(string)) {
            this.appletExecutionContext.restart();
            return;
        }
        if (amh.getMessage("menuitem.reload").equals(string)) {
            this.appletExecutionContext.reload();
            return;
        }
        if (amh.getMessage("menuitem.clone").equals(string)) {
            this.appletClone();
            return;
        }
        if (amh.getMessage("menuitem.stop").equals(string)) {
            this.appletExecutionContext.sendStop();
            return;
        }
        if (amh.getMessage("menuitem.save").equals(string)) {
            this.appletSave();
            return;
        }
        if (amh.getMessage("menuitem.start").equals(string)) {
            this.appletExecutionContext.sendStart();
            return;
        }
        if (amh.getMessage("menuitem.tag").equals(string)) {
            this.appletTag();
            return;
        }
        if (amh.getMessage("menuitem.info").equals(string)) {
            this.appletInfo();
            return;
        }
        if (amh.getMessage("menuitem.encoding").equals(string)) {
            this.appletCharacterEncoding();
            return;
        }
        if (amh.getMessage("menuitem.edit").equals(string)) {
            this.appletEdit();
            return;
        }
        if (amh.getMessage("menuitem.print").equals(string)) {
            this.appletPrint();
            return;
        }
        if (amh.getMessage("menuitem.props").equals(string)) {
            this.networkProperties();
            return;
        }
        if (amh.getMessage("menuitem.close").equals(string)) {
            this.appletClose();
            return;
        }
        if (amh.getMessage("menuitem.quit").equals(string)) {
            this.appletQuit();
            return;
        }
    }

    public static void init() {
        Properties properties = new Properties();
        properties.put("http.proxyHost", "wwwproxy");
        properties.put("http.proxyPort", "3128");
        properties.put("ftpProxySet", "true");
        properties.put("ftpProxyHost", "wwwproxy");
        properties.put("ftpProxyPort", "3128");
        properties.put("ftpProxyPort", "3128");
        properties.put("stardiv.debug.trace", "window");
        properties.put("stardiv.debug.warning", "window");
        properties.put("stardiv.debug.error", "window");
        properties.put("stardiv.security.defaultSecurityManager", "true");
        try {
            FileInputStream fileInputStream = new FileInputStream(theUserPropertiesFile);
            properties.load(new BufferedInputStream(fileInputStream));
            fileInputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        SjSettings.changeProperties(properties);
    }

    public static void skipSpace(Reader reader) throws IOException {
        while (c >= 0 && (c == 32 || c == 9 || c == 10 || c == 13)) {
            c = reader.read();
        }
    }

    public static String scanIdentifier(Reader reader) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        while (c >= 97 && c <= 122 || c >= 65 && c <= 90 || c >= 48 && c <= 57 || c == 95) {
            stringBuffer.append((char)c);
            c = reader.read();
        }
        return stringBuffer.toString();
    }

    public static Hashtable scanTag(Reader reader) throws IOException {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        AppletViewer.skipSpace(reader);
        while (c >= 0 && c != 62) {
            String string = AppletViewer.scanIdentifier(reader);
            String string2 = "";
            AppletViewer.skipSpace(reader);
            if (c == 61) {
                int n = -1;
                c = reader.read();
                AppletViewer.skipSpace(reader);
                if (c == 39 || c == 34) {
                    n = c;
                    c = reader.read();
                }
                StringBuffer stringBuffer = new StringBuffer();
                while (c > 0 && (n < 0 && c != 32 && c != 9 && c != 10 && c != 13 && c != 62 || n >= 0 && c != n)) {
                    stringBuffer.append((char)c);
                    c = reader.read();
                }
                if (c == n) {
                    c = reader.read();
                }
                AppletViewer.skipSpace(reader);
                string2 = stringBuffer.toString();
            }
            hashtable.put(string.toLowerCase(), string2);
            AppletViewer.skipSpace(reader);
        }
        return hashtable;
    }

    private static Reader makeReader(InputStream inputStream) {
        if (encoding != null) {
            try {
                return new BufferedReader(new InputStreamReader(inputStream, encoding));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        encoding = inputStreamReader.getEncoding();
        return new BufferedReader(inputStreamReader);
    }

    public static void parse(URL uRL) throws IOException {
        AppletViewer.parse(uRL, System.out);
    }

    public static void parse(URL uRL, PrintStream printStream) throws IOException {
        String string = amh.getMessage("parse.warning.requiresname");
        String string2 = amh.getMessage("parse.warning.paramoutside");
        String string3 = amh.getMessage("parse.warning.requirescode");
        String string4 = amh.getMessage("parse.warning.requiresheight");
        String string5 = amh.getMessage("parse.warning.requireswidth");
        String string6 = amh.getMessage("parse.warning.appnotLongersupported");
        URLConnection uRLConnection = uRL.openConnection();
        Reader reader = AppletViewer.makeReader(uRLConnection.getInputStream());
        uRL = uRLConnection.getURL();
        Hashtable hashtable = null;
        while ((c = reader.read()) != -1) {
            Cloneable cloneable;
            String string7;
            if (c != 60) continue;
            c = reader.read();
            if (c == 47) {
                c = reader.read();
                string7 = AppletViewer.scanIdentifier(reader);
                if (!string7.equalsIgnoreCase("applet")) continue;
                if (hashtable != null) {
                    new AppletViewer(x, y, uRL, hashtable, System.out);
                    y += 20;
                    cloneable = Toolkit.getDefaultToolkit().getScreenSize();
                    if ((x += 50) > ((Dimension)cloneable).width - 30) {
                        x = 100;
                    }
                    if (y > ((Dimension)cloneable).height - 30) {
                        y = 50;
                    }
                }
                hashtable = null;
                continue;
            }
            string7 = AppletViewer.scanIdentifier(reader);
            if (string7.equalsIgnoreCase("param")) {
                cloneable = AppletViewer.scanTag(reader);
                String string8 = (String)((Hashtable)cloneable).get("name");
                if (string8 == null) {
                    printStream.println(string);
                    continue;
                }
                String string9 = (String)((Hashtable)cloneable).get("value");
                if (string9 == null) {
                    printStream.println(string);
                    continue;
                }
                if (hashtable != null) {
                    hashtable.put(string8.toLowerCase(), string9);
                    continue;
                }
                printStream.println(string2);
                continue;
            }
            if (string7.equalsIgnoreCase("applet")) {
                hashtable = AppletViewer.scanTag(reader);
                if (hashtable.get("code") == null && hashtable.get("object") == null) {
                    printStream.println(string3);
                    hashtable = null;
                    continue;
                }
                if (hashtable.get("width") == null) {
                    printStream.println(string5);
                    hashtable = null;
                    continue;
                }
                if (hashtable.get("height") != null) continue;
                printStream.println(string4);
                hashtable = null;
                continue;
            }
            if (!string7.equalsIgnoreCase("app")) continue;
            printStream.println(string6);
            cloneable = AppletViewer.scanTag(reader);
            string7 = (String)((Hashtable)cloneable).get("class");
            if (string7 != null) {
                ((Hashtable)cloneable).remove("class");
                ((Hashtable)cloneable).put("code", string7 + ".class");
            }
            if ((string7 = (String)((Hashtable)cloneable).get("src")) != null) {
                ((Hashtable)cloneable).remove("src");
                ((Hashtable)cloneable).put("codebase", string7);
            }
            if (((Hashtable)cloneable).get("width") == null) {
                ((Hashtable)cloneable).put("width", "100");
            }
            if (((Hashtable)cloneable).get("height") == null) {
                ((Hashtable)cloneable).put("height", "100");
            }
            AppletViewer.printTag(printStream, (Hashtable)cloneable);
            printStream.println();
        }
        reader.close();
    }

    static void usage() {
        System.out.println(amh.getMessage("usage"));
    }

    public static void mainInit() {
        if (!didInitialize) {
            didInitialize = true;
            AppletViewer.init();
        }
    }

    public static void main(String[] stringArray) {
        AppletViewer.mainInit();
        if (stringArray.length == 0) {
            System.out.println(amh.getMessage("main.err.inputfile"));
            AppletViewer.usage();
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            block12: {
                try {
                    URL uRL = null;
                    if (stringArray[n].equals("-encoding")) {
                        if (n + 1 < stringArray.length) {
                            encoding = stringArray[++n];
                            break block12;
                        }
                        AppletViewer.usage();
                        System.exit(1);
                    } else if (stringArray[n].indexOf(58) <= 1) {
                        String string = System.getProperty("user.dir");
                        String string2 = string.charAt(0) == '/' || string.charAt(0) == File.separatorChar ? "file:" : "file:/";
                        uRL = new URL(string2 + string.replace(File.separatorChar, '/') + "/");
                        uRL = new URL(uRL, stringArray[n]);
                    } else {
                        uRL = new URL(stringArray[n]);
                    }
                    AppletViewer.parse(uRL);
                    documentViewer = DocumentProxy.getDocumentProxy(uRL, Toolkit.getDefaultToolkit());
                }
                catch (MalformedURLException malformedURLException) {
                    System.out.println(amh.getMessage("main.err.badurl", stringArray[n], malformedURLException.getMessage()));
                    System.exit(1);
                }
                catch (IOException iOException) {
                    System.out.println(amh.getMessage("main.err.io", iOException.getMessage()));
                    if (stringArray[n].indexOf(58) < 0) {
                        System.out.println(amh.getMessage("main.err.readablefile", stringArray[n]));
                    } else {
                        System.out.println(amh.getMessage("main.err.correcturl", stringArray[n]));
                    }
                    System.exit(1);
                }
            }
            ++n;
        }
    }

    static {
        documentViewer = null;
        contexts = new Vector();
        String string = File.separator;
        File file = new File(System.getProperty("user.home"));
        File file2 = new File(file, ".hotjava");
        file2.mkdirs();
        theUserPropertiesFile = new File(file2, "properties");
        File file3 = new File(System.getProperty("java.home"));
        theAppletViewerPropsFile = new File(file3, "lib" + string + "appletviewer.properties");
        systemParam = new Hashtable();
        systemParam.put("codebase", "codebase");
        systemParam.put("code", "code");
        systemParam.put("alt", "alt");
        systemParam.put("width", "width");
        systemParam.put("height", "height");
        systemParam.put("align", "align");
        systemParam.put("vspace", "vspace");
        systemParam.put("hspace", "hspace");
        x = 100;
        y = 50;
        encoding = null;
        didInitialize = false;
        amh = new AppletMessageHandler("appletviewer");
    }

    private final class UserActionListener
    implements ActionListener {
        private UserActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AppletViewer.this.processUserAction(actionEvent);
        }
    }
}

